/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.AppletConfirmHandler;
import com.gargoylesoftware.htmlunit.FailingHttpStatusCodeException;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlParameter;
import com.gargoylesoftware.htmlunit.html.applets.AppletClassLoader;
import com.gargoylesoftware.htmlunit.html.applets.AppletStubImpl;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLObjectElement;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.applet.Applet;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.NodeList;

public class HtmlObject
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlObject.class);
    private static final String APPLET_TYPE = "application/x-java-applet";
    private static final String ARCHIVE = "archive";
    private static final String CACHE_ARCHIVE = "cache_archive";
    private static final String CODEBASE = "codebase";
    public static final String TAG_NAME = "object";
    private Applet applet_;
    private AppletClassLoader appletClassLoader_;
    private List<URL> archiveUrls_;

    HtmlObject(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getDeclareAttribute() {
        return this.getAttribute("declare");
    }

    public final String getClassIdAttribute() {
        return this.getAttribute("classid");
    }

    public final String getCodebaseAttribute() {
        return this.getAttribute(CODEBASE);
    }

    public final String getDataAttribute() {
        return this.getAttribute("data");
    }

    public final String getTypeAttribute() {
        return this.getAttribute("type");
    }

    public final String getCodeTypeAttribute() {
        return this.getAttribute("codetype");
    }

    public final String getArchiveAttribute() {
        return this.getAttribute(ARCHIVE);
    }

    public final String getStandbyAttribute() {
        return this.getAttribute("standby");
    }

    public final String getHeightAttribute() {
        return this.getAttribute("height");
    }

    public final String getWidthAttribute() {
        return this.getAttribute("width");
    }

    public final String getUseMapAttribute() {
        return this.getAttribute("usemap");
    }

    public final String getNameAttribute() {
        return this.getAttribute("name");
    }

    public final String getTabIndexAttribute() {
        return this.getAttribute("tabindex");
    }

    public final String getAlignAttribute() {
        return this.getAttribute("align");
    }

    public final String getBorderAttribute() {
        return this.getAttribute("border");
    }

    public final String getHspaceAttribute() {
        return this.getAttribute("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttribute("vspace");
    }

    @Override
    protected void onAllChildrenAddedToPage(boolean postponed) {
        String clsId;
        if (this.getOwnerDocument() instanceof XmlPage) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Object node added: " + this.asXml()));
        }
        if (ATTRIBUTE_NOT_DEFINED != (clsId = this.getClassIdAttribute())) {
            ((HTMLObjectElement)this.getScriptableObject()).setClassid(clsId);
        }
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    public Applet getApplet() throws IOException {
        this.setupAppletIfNeeded();
        return this.applet_;
    }

    private synchronized void setupAppletIfNeeded() throws IOException {
        URL archiveUrl;
        String tempUrl;
        String tmpArchive;
        int i;
        HtmlPage page;
        WebClient webclient;
        AppletConfirmHandler handler;
        if (this.applet_ != null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.getTypeAttribute()) || !this.getTypeAttribute().startsWith(APPLET_TYPE)) {
            return;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.getNameAttribute());
        params.put("height", this.getHeightAttribute());
        params.put("width", this.getWidthAttribute());
        NodeList paramTags = this.getElementsByTagName("param");
        Iterator iterator = paramTags.iterator();
        while (iterator.hasNext()) {
            HtmlElement paramTag = (HtmlElement)iterator.next();
            HtmlParameter parameter = (HtmlParameter)paramTag;
            params.put(parameter.getNameAttribute(), parameter.getValueAttribute());
        }
        if (StringUtils.isEmpty((CharSequence)((CharSequence)params.get(CODEBASE))) && StringUtils.isNotEmpty((CharSequence)this.getCodebaseAttribute())) {
            params.put(CODEBASE, this.getCodebaseAttribute());
        }
        String codebaseProperty = (String)params.get(CODEBASE);
        if (StringUtils.isEmpty((CharSequence)((CharSequence)params.get(ARCHIVE))) && StringUtils.isNotEmpty((CharSequence)this.getArchiveAttribute())) {
            params.put(ARCHIVE, this.getArchiveAttribute());
        }
        if (null != (handler = (webclient = (page = (HtmlPage)this.getPage()).getWebClient()).getAppletConfirmHandler()) && !handler.confirm(this)) {
            return;
        }
        String appletClassName = this.getAttribute("code");
        if (StringUtils.isEmpty((CharSequence)appletClassName)) {
            appletClassName = (String)params.get("code");
        }
        if (appletClassName.endsWith(".class")) {
            appletClassName = appletClassName.substring(0, appletClassName.length() - 6);
        }
        this.appletClassLoader_ = new AppletClassLoader((Window)this.getPage().getEnclosingWindow().getScriptableObject(), Thread.currentThread().getContextClassLoader());
        String documentUrl = page.getUrl().toExternalForm();
        String baseUrl = UrlUtils.resolveUrl(documentUrl, ".");
        if (StringUtils.isNotEmpty((CharSequence)codebaseProperty)) {
            baseUrl = UrlUtils.resolveUrl(baseUrl, codebaseProperty);
        }
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.archiveUrls_ = new LinkedList<URL>();
        String[] archives = StringUtils.split((String)((String)params.get(ARCHIVE)), (char)',');
        if (null != archives) {
            for (i = 0; i < archives.length; ++i) {
                tmpArchive = archives[i].trim();
                tempUrl = UrlUtils.resolveUrl(baseUrl, tmpArchive);
                archiveUrl = UrlUtils.toUrlUnsafe(tempUrl);
                this.appletClassLoader_.addArchiveToClassPath(archiveUrl);
                this.archiveUrls_.add(archiveUrl);
            }
        }
        if (null != (archives = StringUtils.split((String)((String)params.get(CACHE_ARCHIVE)), (char)','))) {
            for (i = 0; i < archives.length; ++i) {
                tmpArchive = archives[i].trim();
                tempUrl = UrlUtils.resolveUrl(baseUrl, tmpArchive);
                archiveUrl = UrlUtils.toUrlUnsafe(tempUrl);
                this.appletClassLoader_.addArchiveToClassPath(archiveUrl);
                this.archiveUrls_.add(archiveUrl);
            }
        }
        this.archiveUrls_ = Collections.unmodifiableList(this.archiveUrls_);
        if (this.archiveUrls_.isEmpty()) {
            String tempUrl2 = UrlUtils.resolveUrl(baseUrl, this.getAttribute("code"));
            URL classUrl = UrlUtils.toUrlUnsafe(tempUrl2);
            WebResponse response = webclient.loadWebResponse(new WebRequest(classUrl));
            try {
                webclient.throwFailingHttpStatusCodeExceptionIfNecessary(response);
                this.appletClassLoader_.addClassToClassPath(appletClassName, response);
            }
            catch (FailingHttpStatusCodeException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        try {
            Class<?> appletClass = this.appletClassLoader_.loadClass(appletClassName);
            this.applet_ = (Applet)appletClass.newInstance();
            this.applet_.setStub(new AppletStubImpl(this.getHtmlPageOrNull(), params, UrlUtils.toUrlUnsafe(baseUrl), UrlUtils.toUrlUnsafe(documentUrl)));
            this.applet_.init();
            this.applet_.start();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error((Object)("Loading applet '" + appletClassName + "' failed\n    " + e.toString() + "\n    Classpath:\n" + this.appletClassLoader_.info()));
            throw new RuntimeException(e);
        }
    }
}

