/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Iterator;
import com.gargoylesoftware.htmlunit.javascript.host.Map;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.arrays.ArrayBufferViewBase;
import java.util.LinkedHashSet;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Delegator;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class Set
extends SimpleScriptable {
    private static final String SET_ITERATOR_NAME = "Set Iterator";
    private static Iterator ITERATOR_PROTOTYPE_;
    private java.util.Set<Object> set_ = new LinkedHashSet<Object>();

    public Set() {
    }

    @JsxConstructor
    public Set(Object iterable) {
        Window window;
        if (iterable != Undefined.instance && (window = (Window)ScriptRuntime.getTopCallScope((Context)Context.getCurrentContext())).getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MAP_CONSTRUCTOR_ARGUMENT)) {
            if (iterable instanceof NativeArray) {
                NativeArray array = (NativeArray)iterable;
                int i = 0;
                while ((long)i < array.getLength()) {
                    this.add(ScriptableObject.getProperty((Scriptable)array, (int)i));
                    ++i;
                }
            } else if (iterable instanceof ArrayBufferViewBase) {
                ArrayBufferViewBase array = (ArrayBufferViewBase)iterable;
                for (int i = 0; i < array.getLength(); ++i) {
                    this.add(ScriptableObject.getProperty((Scriptable)array, (int)i));
                }
            } else if (iterable instanceof String) {
                String string = (String)iterable;
                for (int i = 0; i < string.length(); ++i) {
                    this.add(String.valueOf(string.charAt(i)));
                }
            } else if (iterable instanceof Set) {
                Set set = (Set)iterable;
                for (Object object : set.set_) {
                    this.add(object);
                }
            } else if (iterable instanceof Map) {
                Iterator iterator = (Iterator)((Map)iterable).entries();
                SimpleScriptable object = iterator.next();
                while (Undefined.instance != object.get("value", null)) {
                    this.add(object);
                    object = iterator.next();
                }
            } else {
                throw Context.reportRuntimeError((String)("TypeError: object is not iterable (" + iterable.getClass().getName() + ")"));
            }
        }
    }

    @JsxGetter
    public int getSize() {
        return this.set_.size();
    }

    @JsxFunction
    public Set add(Object value) {
        if (value instanceof Delegator) {
            value = ((Delegator)value).getDelegee();
        }
        if (value == NOT_FOUND) {
            value = Undefined.instance;
        }
        this.set_.add(value);
        return this;
    }

    @JsxFunction
    public void clear() {
        this.set_.clear();
    }

    @JsxFunction
    public boolean delete(Object key) {
        return this.set_.remove(key);
    }

    @JsxFunction
    public boolean has(Object value) {
        return this.set_.contains(value);
    }

    @Override
    public Object get(String name, Scriptable start) {
        if (name.equals("Symbol(Symbol.iterator)")) {
            return ScriptableObject.getProperty((Scriptable)start, (String)"values");
        }
        return super.get(name, start);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public Object values() {
        Iterator object = new Iterator(SET_ITERATOR_NAME, this.set_.iterator());
        ((HtmlUnitScriptable)object).setParentScope(this.getParentScope());
        Set.setIteratorPrototype((Scriptable)object);
        return object;
    }

    private static void setIteratorPrototype(Scriptable scriptable) {
        if (ITERATOR_PROTOTYPE_ == null) {
            ITERATOR_PROTOTYPE_ = new Iterator(SET_ITERATOR_NAME, null);
        }
        scriptable.setPrototype((Scriptable)ITERATOR_PROTOTYPE_);
    }

    @JsxFunction
    public void forEach(Function callback, Object thisArg) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_MAP_CONSTRUCTOR_ARGUMENT)) {
            Object thisArgument = thisArg instanceof Scriptable ? (Scriptable)thisArg : this.getWindow();
            for (Object object : this.set_) {
                callback.call(Context.getCurrentContext(), this.getParentScope(), thisArgument, new Object[]{object, object, this});
            }
        }
    }
}

