/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.security.Principal;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerFilter;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.jaas.JassCredentialCallbackHandler;
import org.apache.activemq.security.SecurityContext;

public class JaasAuthenticationBroker
extends BrokerFilter {
    private final String jassConfiguration;
    private final CopyOnWriteArrayList<SecurityContext> securityContexts = new CopyOnWriteArrayList();

    public JaasAuthenticationBroker(Broker next, String jassConfiguration) {
        super(next);
        this.jassConfiguration = jassConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnection(ConnectionContext context, ConnectionInfo info2) throws Exception {
        if (context.getSecurityContext() == null) {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(JaasAuthenticationBroker.class.getClassLoader());
            try {
                try {
                    JassCredentialCallbackHandler callback = new JassCredentialCallbackHandler(info2.getUserName(), info2.getPassword());
                    LoginContext lc = new LoginContext(this.jassConfiguration, (CallbackHandler)callback);
                    lc.login();
                    Subject subject = lc.getSubject();
                    JaasSecurityContext s = new JaasSecurityContext(info2.getUserName(), subject);
                    context.setSecurityContext(s);
                    this.securityContexts.add(s);
                }
                catch (Exception e) {
                    throw (SecurityException)new SecurityException("User name [" + info2.getUserName() + "] or password is invalid.").initCause(e);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(original);
            }
        }
        super.addConnection(context, info2);
    }

    @Override
    public void removeConnection(ConnectionContext context, ConnectionInfo info2, Throwable error2) throws Exception {
        super.removeConnection(context, info2, error2);
        if (this.securityContexts.remove(context.getSecurityContext())) {
            context.setSecurityContext(null);
        }
    }

    public void refresh() {
        for (SecurityContext sc : this.securityContexts) {
            sc.getAuthorizedReadDests().clear();
            sc.getAuthorizedWriteDests().clear();
        }
    }

    static class JaasSecurityContext
    extends SecurityContext {
        private final Subject subject;

        public JaasSecurityContext(String userName, Subject subject) {
            super(userName);
            this.subject = subject;
        }

        @Override
        public Set<Principal> getPrincipals() {
            return this.subject.getPrincipals();
        }
    }
}

