/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.client.impl;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueAttributes;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.ActiveMQClientLogger;
import org.apache.activemq.artemis.core.client.ActiveMQClientMessageBundle;
import org.apache.activemq.artemis.core.client.impl.ActiveMQXAResource;
import org.apache.activemq.artemis.core.client.impl.ClientConsumerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientLargeMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientMessageImpl;
import org.apache.activemq.artemis.core.client.impl.ClientMessageInternal;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCreditManager;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCreditManagerImpl;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientProducerImpl;
import org.apache.activemq.artemis.core.client.impl.ClientProducerInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.message.impl.CoreMessageObjectPools;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ConsumerContext;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.spi.core.remoting.SessionContext;
import org.apache.activemq.artemis.utils.ConfirmationWindowWarning;
import org.apache.activemq.artemis.utils.TokenBucketLimiterImpl;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.XidCodecSupport;
import org.jboss.logging.Logger;

public final class ClientSessionImpl
implements ClientSessionInternal,
FailureListener {
    private static final Logger logger = Logger.getLogger(ClientSessionImpl.class);
    private final Map<String, String> metadata = new HashMap<String, String>();
    private final ClientSessionFactoryInternal sessionFactory;
    private String name;
    private final String username;
    private final String password;
    private final boolean xa;
    private final Executor executor;
    private final Executor flowControlExecutor;
    private final Set<ClientProducerInternal> producers = new HashSet<ClientProducerInternal>();
    private final Map<ConsumerContext, ClientConsumerInternal> consumers = new LinkedHashMap<ConsumerContext, ClientConsumerInternal>();
    private volatile boolean closed;
    private final boolean autoCommitAcks;
    private final boolean preAcknowledge;
    private final boolean autoCommitSends;
    private final boolean blockOnAcknowledge;
    private final boolean autoGroup;
    private final int ackBatchSize;
    private final int consumerWindowSize;
    private final int consumerMaxRate;
    private final int confirmationWindowSize;
    private final int producerMaxRate;
    private final boolean blockOnNonDurableSend;
    private final boolean blockOnDurableSend;
    private final int minLargeMessageSize;
    private final boolean compressLargeMessages;
    private volatile int initialMessagePacketSize;
    private final boolean cacheLargeMessageClient;
    private final SessionContext sessionContext;
    private boolean forceNotSameRM;
    private final ClientProducerCreditManager producerCreditManager;
    private volatile boolean started;
    private volatile boolean rollbackOnly;
    private volatile boolean workDone;
    private final String groupID;
    private volatile boolean inClose;
    private volatile boolean mayAttemptToFailover = true;
    private Xid currentXID;
    private final AtomicInteger concurrentCall = new AtomicInteger(0);
    private final ConfirmationWindowWarning confirmationWindowWarning;
    private final Executor closeExecutor;
    private final CoreMessageObjectPools coreMessageObjectPools = new CoreMessageObjectPools();

    ClientSessionImpl(ClientSessionFactoryInternal sessionFactory, String name, String username, String password, boolean xa, boolean autoCommitSends, boolean autoCommitAcks, boolean preAcknowledge, boolean blockOnAcknowledge, boolean autoGroup, int ackBatchSize, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnNonDurableSend, boolean blockOnDurableSend, boolean cacheLargeMessageClient, int minLargeMessageSize, boolean compressLargeMessages, int initialMessagePacketSize, String groupID, SessionContext sessionContext, Executor executor, Executor flowControlExecutor, Executor closeExecutor) throws ActiveMQException {
        this.sessionFactory = sessionFactory;
        this.name = name;
        this.username = username;
        this.password = password;
        this.executor = executor;
        this.flowControlExecutor = flowControlExecutor;
        this.xa = xa;
        this.autoCommitAcks = autoCommitAcks;
        this.preAcknowledge = preAcknowledge;
        this.autoCommitSends = autoCommitSends;
        this.blockOnAcknowledge = blockOnAcknowledge;
        this.autoGroup = autoGroup;
        this.ackBatchSize = ackBatchSize;
        this.consumerWindowSize = consumerWindowSize;
        this.consumerMaxRate = consumerMaxRate;
        this.confirmationWindowSize = confirmationWindowSize;
        this.producerMaxRate = producerMaxRate;
        this.blockOnNonDurableSend = blockOnNonDurableSend;
        this.blockOnDurableSend = blockOnDurableSend;
        this.cacheLargeMessageClient = cacheLargeMessageClient;
        this.minLargeMessageSize = minLargeMessageSize;
        this.compressLargeMessages = compressLargeMessages;
        this.initialMessagePacketSize = initialMessagePacketSize;
        this.groupID = groupID;
        this.producerCreditManager = new ClientProducerCreditManagerImpl(this, producerWindowSize);
        this.sessionContext = sessionContext;
        sessionContext.setSession(this);
        this.confirmationWindowWarning = sessionFactory.getConfirmationWindowWarning();
        this.closeExecutor = closeExecutor;
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName) throws ActiveMQException {
        this.createQueue(address, queueName, false);
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, boolean durable) throws ActiveMQException {
        this.createQueue(address, queueName, null, durable, false);
    }

    @Override
    public void createQueue(String address, String queueName, boolean durable) throws ActiveMQException {
        this.createQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName), durable);
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, boolean durable) throws ActiveMQException {
        this.createSharedQueue(address, queueName, null, durable);
    }

    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable) throws ActiveMQException {
        this.createSharedQueue(address, ActiveMQDefaultConfiguration.getDefaultRoutingType(), queueName, filterString, durable);
    }

    @Override
    public void createAddress(SimpleString address, Set<RoutingType> routingTypes, boolean autoCreated) throws ActiveMQException {
        this.createAddress(address, EnumSet.copyOf(routingTypes), autoCreated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createAddress(SimpleString address, EnumSet<RoutingType> routingTypes, boolean autoCreated) throws ActiveMQException {
        this.checkClosed();
        this.startCall();
        try {
            this.sessionContext.createAddress(address, routingTypes, autoCreated);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void createAddress(SimpleString address, RoutingType routingType, boolean autoCreated) throws ActiveMQException {
        this.createAddress(address, EnumSet.of(routingType), autoCreated);
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable) throws ActiveMQException {
        this.createQueue(address, queueName, filterString, durable, false);
    }

    @Override
    public void createQueue(String address, String queueName, String filterString, boolean durable) throws ActiveMQException {
        this.createQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString), durable);
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, SimpleString filterString, boolean durable, boolean autoCreated) throws ActiveMQException {
        this.createQueue(address, ActiveMQDefaultConfiguration.getDefaultRoutingType(), queueName, filterString, durable, autoCreated);
    }

    @Override
    public void createQueue(String address, String queueName, String filterString, boolean durable, boolean autoCreated) throws ActiveMQException {
        this.createQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString), durable, autoCreated);
    }

    @Override
    public void createTemporaryQueue(SimpleString address, SimpleString queueName) throws ActiveMQException {
        this.createTemporaryQueue(address, queueName, (SimpleString)null);
    }

    @Override
    public void createTemporaryQueue(String address, String queueName) throws ActiveMQException {
        this.createTemporaryQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName));
    }

    @Override
    public void createTemporaryQueue(SimpleString address, SimpleString queueName, SimpleString filter) throws ActiveMQException {
        this.createTemporaryQueue(address, ActiveMQDefaultConfiguration.getDefaultRoutingType(), queueName, filter);
    }

    @Override
    public void createTemporaryQueue(String address, String queueName, String filter) throws ActiveMQException {
        this.createTemporaryQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filter));
    }

    @Override
    public void createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filterString, boolean durable, boolean autoCreated) throws ActiveMQException {
        this.internalCreateQueue(address, queueName, false, autoCreated, new QueueAttributes().setRoutingType(routingType).setFilterString(filterString).setDurable(Boolean.valueOf(durable)).setPurgeOnNoConsumers(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers())).setMaxConsumers(Integer.valueOf(ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers())));
    }

    @Override
    public void createQueue(String address, RoutingType routingType, String queueName, String filterString, boolean durable, boolean autoCreated) throws ActiveMQException {
        this.createQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString), durable, autoCreated);
    }

    @Override
    public void createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filterString, boolean durable, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers) throws ActiveMQException {
        this.internalCreateQueue(address, queueName, false, autoCreated, new QueueAttributes().setRoutingType(routingType).setFilterString(filterString).setDurable(Boolean.valueOf(durable)).setMaxConsumers(Integer.valueOf(maxConsumers)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)));
    }

    @Override
    public void createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filterString, boolean durable, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue) throws ActiveMQException {
        this.internalCreateQueue(address, queueName, false, autoCreated, new QueueAttributes().setRoutingType(routingType).setFilterString(filterString).setDurable(Boolean.valueOf(durable)).setMaxConsumers(Integer.valueOf(maxConsumers)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)).setExclusive(exclusive).setLastValue(lastValue));
    }

    @Override
    public void createQueue(SimpleString address, SimpleString queueName, boolean autoCreated, QueueAttributes queueAttributes) throws ActiveMQException {
        this.internalCreateQueue(address, queueName, false, autoCreated, queueAttributes);
    }

    @Override
    public void createQueue(String address, RoutingType routingType, String queueName, String filterString, boolean durable, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers) throws ActiveMQException {
        this.createQueue(address, routingType, queueName, filterString, durable, autoCreated, maxConsumers, purgeOnNoConsumers, null, null);
    }

    @Override
    public void createQueue(String address, RoutingType routingType, String queueName, String filterString, boolean durable, boolean autoCreated, int maxConsumers, boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue) throws ActiveMQException {
        this.createQueue(SimpleString.toSimpleString((String)address), routingType, SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString), durable, autoCreated, maxConsumers, purgeOnNoConsumers, exclusive, lastValue);
    }

    @Override
    public void createTemporaryQueue(SimpleString address, RoutingType routingType, SimpleString queueName) throws ActiveMQException {
        this.createTemporaryQueue(address, routingType, queueName, null);
    }

    @Override
    public void createTemporaryQueue(String address, RoutingType routingType, String queueName) throws ActiveMQException {
        this.createTemporaryQueue(SimpleString.toSimpleString((String)address), routingType, SimpleString.toSimpleString((String)queueName));
    }

    @Override
    public void createTemporaryQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, int maxConsumers, boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue) throws ActiveMQException {
        this.internalCreateQueue(address, queueName, true, false, new QueueAttributes().setRoutingType(routingType).setFilterString(filter).setDurable(Boolean.valueOf(false)).setPurgeOnNoConsumers(Boolean.valueOf(purgeOnNoConsumers)).setMaxConsumers(Integer.valueOf(maxConsumers)).setExclusive(exclusive).setLastValue(lastValue));
    }

    @Override
    public void createTemporaryQueue(SimpleString address, SimpleString queueName, QueueAttributes queueAttributes) throws ActiveMQException {
        this.internalCreateQueue(address, queueName, true, false, queueAttributes);
    }

    @Override
    public void createTemporaryQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter) throws ActiveMQException {
        this.createTemporaryQueue(address, routingType, queueName, filter, ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers(), ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers(), null, null);
    }

    @Override
    public void createTemporaryQueue(String address, RoutingType routingType, String queueName, String filter) throws ActiveMQException {
        this.createTemporaryQueue(SimpleString.toSimpleString((String)address), routingType, SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filter));
    }

    @Override
    public void createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, boolean durable) throws ActiveMQException {
        this.internalCreateQueue(address, queueName, false, false, new QueueAttributes().setRoutingType(routingType).setFilterString(null).setDurable(Boolean.valueOf(durable)).setPurgeOnNoConsumers(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers())).setMaxConsumers(Integer.valueOf(ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers())));
    }

    @Override
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString queueName, boolean durable) throws ActiveMQException {
        this.createSharedQueue(address, routingType, queueName, null, durable);
    }

    @Override
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable) throws ActiveMQException {
        this.createSharedQueue(address, routingType, queueName, filter, durable, null, null, null, null);
    }

    @Override
    public void createSharedQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean lastValue) throws ActiveMQException {
        QueueAttributes queueAttributes = new QueueAttributes().setRoutingType(routingType).setFilterString(filter).setDurable(Boolean.valueOf(durable)).setPurgeOnNoConsumers(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers())).setMaxConsumers(Integer.valueOf(ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers())).setExclusive(exclusive).setLastValue(lastValue);
        this.createSharedQueue(address, queueName, queueAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSharedQueue(SimpleString address, SimpleString queueName, QueueAttributes queueAttributes) throws ActiveMQException {
        this.checkClosed();
        this.startCall();
        try {
            this.sessionContext.createSharedQueue(address, queueName, queueAttributes);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void createQueue(String address, RoutingType routingType, String queueName, boolean durable) throws ActiveMQException {
        this.createQueue(SimpleString.toSimpleString((String)address), routingType, SimpleString.toSimpleString((String)queueName), durable);
    }

    @Override
    public void createQueue(String address, RoutingType routingType, String queueName) throws ActiveMQException {
        this.internalCreateQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName), false, false, new QueueAttributes().setRoutingType(routingType).setFilterString(null).setDurable(Boolean.valueOf(false)).setPurgeOnNoConsumers(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers())).setMaxConsumers(Integer.valueOf(ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers())));
    }

    @Override
    public void createQueue(SimpleString address, RoutingType routingType, SimpleString queueName) throws ActiveMQException {
        this.internalCreateQueue(address, queueName, false, false, new QueueAttributes().setRoutingType(routingType).setFilterString(null).setDurable(Boolean.valueOf(false)).setPurgeOnNoConsumers(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers())).setMaxConsumers(Integer.valueOf(ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers())));
    }

    @Override
    public void createQueue(SimpleString address, RoutingType routingType, SimpleString queueName, SimpleString filter, boolean durable) throws ActiveMQException {
        this.internalCreateQueue(address, queueName, false, false, new QueueAttributes().setRoutingType(routingType).setFilterString(filter).setDurable(Boolean.valueOf(durable)).setPurgeOnNoConsumers(Boolean.valueOf(ActiveMQDefaultConfiguration.getDefaultPurgeOnNoConsumers())).setMaxConsumers(Integer.valueOf(ActiveMQDefaultConfiguration.getDefaultMaxQueueConsumers())));
    }

    @Override
    public void createQueue(String address, RoutingType routingType, String queueName, String filter, boolean durable) throws ActiveMQException {
        this.createQueue(SimpleString.toSimpleString((String)address), routingType, SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filter), durable);
    }

    @Override
    public void deleteQueue(SimpleString queueName) throws ActiveMQException {
        this.checkClosed();
        this.startCall();
        try {
            this.sessionContext.deleteQueue(queueName);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void deleteQueue(String queueName) throws ActiveMQException {
        this.deleteQueue(SimpleString.toSimpleString((String)queueName));
    }

    @Override
    public ClientSession.QueueQuery queueQuery(SimpleString queueName) throws ActiveMQException {
        this.checkClosed();
        this.startCall();
        try {
            ClientSession.QueueQuery queueQuery = this.sessionContext.queueQuery(queueName);
            return queueQuery;
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public ClientSession.AddressQuery addressQuery(SimpleString address) throws ActiveMQException {
        this.checkClosed();
        return this.sessionContext.addressQuery(address);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName) throws ActiveMQException {
        return this.createConsumer(queueName, null, false);
    }

    @Override
    public ClientConsumer createConsumer(String queueName) throws ActiveMQException {
        return this.createConsumer(SimpleString.toSimpleString((String)queueName));
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString) throws ActiveMQException {
        return this.createConsumer(queueName, filterString, this.consumerWindowSize, this.consumerMaxRate, false);
    }

    @Override
    public void createQueue(String address, String queueName) throws ActiveMQException {
        this.createQueue(SimpleString.toSimpleString((String)address), SimpleString.toSimpleString((String)queueName));
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString) throws ActiveMQException {
        return this.createConsumer(SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString));
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, boolean browseOnly) throws ActiveMQException {
        return this.createConsumer(queueName, filterString, this.consumerWindowSize, this.consumerMaxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, int priority, boolean browseOnly) throws ActiveMQException {
        return this.createConsumer(queueName, filterString, priority, this.consumerWindowSize, this.consumerMaxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, boolean browseOnly) throws ActiveMQException {
        return this.createConsumer(queueName, null, this.consumerWindowSize, this.consumerMaxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString, boolean browseOnly) throws ActiveMQException {
        return this.createConsumer(SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString), browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, boolean browseOnly) throws ActiveMQException {
        return this.createConsumer(SimpleString.toSimpleString((String)queueName), null, browseOnly);
    }

    @Override
    public boolean isWritable(ReadyListener callback) {
        return this.sessionContext.isWritable(callback);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, int windowSize, int maxRate, boolean browseOnly) throws ActiveMQException {
        return this.createConsumer(queueName, filterString, ActiveMQDefaultConfiguration.getDefaultConsumerPriority(), windowSize, maxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(SimpleString queueName, SimpleString filterString, int priority, int windowSize, int maxRate, boolean browseOnly) throws ActiveMQException {
        return this.internalCreateConsumer(queueName, filterString, priority, windowSize, maxRate, browseOnly);
    }

    @Override
    public ClientConsumer createConsumer(String queueName, String filterString, int windowSize, int maxRate, boolean browseOnly) throws ActiveMQException {
        return this.createConsumer(SimpleString.toSimpleString((String)queueName), SimpleString.toSimpleString((String)filterString), windowSize, maxRate, browseOnly);
    }

    @Override
    public ClientProducer createProducer() throws ActiveMQException {
        return this.createProducer((SimpleString)null);
    }

    @Override
    public ClientProducer createProducer(SimpleString address) throws ActiveMQException {
        return this.createProducer(address, this.producerMaxRate);
    }

    @Override
    public ClientProducer createProducer(String address) throws ActiveMQException {
        return this.createProducer(SimpleString.toSimpleString((String)address));
    }

    @Override
    public ClientProducer createProducer(SimpleString address, int maxRate) throws ActiveMQException {
        return this.internalCreateProducer(address, maxRate);
    }

    public ClientProducer createProducer(String address, int rate) throws ActiveMQException {
        return this.createProducer(SimpleString.toSimpleString((String)address), rate);
    }

    @Override
    public XAResource getXAResource() {
        return this;
    }

    private void rollbackOnFailover(boolean outcomeKnown) throws ActiveMQException {
        this.rollback(false);
        if (outcomeKnown) {
            throw ActiveMQClientMessageBundle.BUNDLE.txRolledBack();
        }
        throw ActiveMQClientMessageBundle.BUNDLE.txOutcomeUnknown();
    }

    @Override
    public void commit() throws ActiveMQException {
        this.commit(true);
    }

    @Override
    public void commit(boolean block) throws ActiveMQException {
        this.checkClosed();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"Sending commit");
        }
        if (this.rollbackOnly) {
            this.rollbackOnFailover(true);
        }
        this.flushAcks();
        if (this.rollbackOnly) {
            this.rollbackOnFailover(true);
        }
        try {
            this.sessionContext.simpleCommit(block);
        }
        catch (ActiveMQException e) {
            if (e.getType() == ActiveMQExceptionType.UNBLOCKED || e.getType() == ActiveMQExceptionType.CONNECTION_TIMEDOUT || this.rollbackOnly) {
                this.rollbackOnFailover(false);
            }
            throw e;
        }
        if (this.rollbackOnly) {
            this.rollbackOnFailover(false);
        }
        this.workDone = false;
    }

    @Override
    public boolean isRollbackOnly() {
        return this.rollbackOnly;
    }

    @Override
    public void rollback() throws ActiveMQException {
        this.rollback(false);
    }

    @Override
    public void rollback(boolean isLastMessageAsDelivered) throws ActiveMQException {
        this.rollback(isLastMessageAsDelivered, true);
    }

    public void rollback(boolean isLastMessageAsDelivered, boolean waitConsumers) throws ActiveMQException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("calling rollback(isLastMessageAsDelivered=" + isLastMessageAsDelivered + ")"));
        }
        this.checkClosed();
        boolean wasStarted = this.started;
        if (wasStarted) {
            this.stop();
        }
        for (ClientConsumerInternal consumer : this.cloneConsumers()) {
            consumer.clear(waitConsumers);
        }
        this.flushAcks();
        this.sessionContext.simpleRollback(isLastMessageAsDelivered);
        if (wasStarted) {
            this.start();
        }
        this.rollbackOnly = false;
    }

    @Override
    public void markRollbackOnly() {
        this.rollbackOnly = true;
    }

    @Override
    public ClientMessage createMessage(byte type, boolean durable, long expiration, long timestamp, byte priority) {
        return new ClientMessageImpl(type, durable, expiration, timestamp, priority, this.initialMessagePacketSize, this.coreMessageObjectPools);
    }

    @Override
    public ClientMessage createMessage(byte type, boolean durable) {
        return this.createMessage(type, durable, 0L, System.currentTimeMillis(), (byte)4);
    }

    @Override
    public ClientMessage createMessage(boolean durable) {
        return this.createMessage((byte)0, durable);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isAutoCommitSends() {
        return this.autoCommitSends;
    }

    @Override
    public boolean isAutoCommitAcks() {
        return this.autoCommitAcks;
    }

    @Override
    public boolean isBlockOnAcknowledge() {
        return this.blockOnAcknowledge;
    }

    @Override
    public boolean isXA() {
        return this.xa;
    }

    @Override
    public void resetIfNeeded() throws ActiveMQException {
        if (this.rollbackOnly) {
            ActiveMQClientLogger.LOGGER.resettingSessionAfterFailure();
            this.rollback(false);
        }
    }

    @Override
    public ClientSessionImpl start() throws ActiveMQException {
        this.checkClosed();
        if (!this.started) {
            for (ClientConsumerInternal clientConsumerInternal : this.cloneConsumers()) {
                clientConsumerInternal.start();
            }
            this.sessionContext.sessionStart();
            this.started = true;
        }
        return this;
    }

    @Override
    public void stop() throws ActiveMQException {
        this.stop(true);
    }

    public void stop(boolean waitForOnMessage) throws ActiveMQException {
        this.checkClosed();
        if (this.started) {
            for (ClientConsumerInternal clientConsumerInternal : this.cloneConsumers()) {
                clientConsumerInternal.stop(waitForOnMessage);
            }
            this.sessionContext.sessionStop();
            this.started = false;
        }
    }

    @Override
    public void addFailureListener(SessionFailureListener listener) {
        this.sessionFactory.addFailureListener(listener);
    }

    @Override
    public boolean removeFailureListener(SessionFailureListener listener) {
        return this.sessionFactory.removeFailureListener(listener);
    }

    @Override
    public void addFailoverListener(FailoverEventListener listener) {
        this.sessionFactory.addFailoverListener(listener);
    }

    @Override
    public boolean removeFailoverListener(FailoverEventListener listener) {
        return this.sessionFactory.removeFailoverListener(listener);
    }

    @Override
    public int getVersion() {
        return this.sessionContext.getServerVersion();
    }

    @Override
    public boolean isClosing() {
        return this.inClose;
    }

    @Override
    public String getNodeId() {
        return this.sessionFactory.getLiveNodeId();
    }

    @Override
    public int getMinLargeMessageSize() {
        return this.minLargeMessageSize;
    }

    @Override
    public boolean isCompressLargeMessages() {
        return this.compressLargeMessages;
    }

    @Override
    public boolean isCacheLargeMessageClient() {
        return this.cacheLargeMessageClient;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void acknowledge(ClientConsumer consumer, Message message) throws ActiveMQException {
        if (this.preAcknowledge) {
            return;
        }
        this.checkClosed();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("client ack messageID = " + message.getMessageID()));
        }
        this.startCall();
        try {
            this.sessionContext.sendACK(false, this.blockOnAcknowledge, consumer, message);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void individualAcknowledge(ClientConsumer consumer, Message message) throws ActiveMQException {
        if (this.preAcknowledge) {
            return;
        }
        this.checkClosed();
        this.startCall();
        try {
            this.sessionContext.sendACK(true, this.blockOnAcknowledge, consumer, message);
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public void expire(ClientConsumer consumer, Message message) throws ActiveMQException {
        this.checkClosed();
        if (!this.preAcknowledge) {
            this.sessionContext.expireMessage(consumer, message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConsumer(ClientConsumerInternal consumer) {
        Map<ConsumerContext, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            this.consumers.put(consumer.getConsumerContext(), consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addProducer(ClientProducerInternal producer) {
        Set<ClientProducerInternal> set = this.producers;
        synchronized (set) {
            this.producers.add(producer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConsumer(ClientConsumerInternal consumer) throws ActiveMQException {
        Map<ConsumerContext, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            this.consumers.remove(consumer.getConsumerContext());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeProducer(ClientProducerInternal producer) {
        Set<ClientProducerInternal> set = this.producers;
        synchronized (set) {
            this.producers.remove(producer);
        }
    }

    @Override
    public void handleReceiveMessage(ConsumerContext consumerID, ClientMessageInternal message) throws Exception {
        ClientConsumerInternal consumer = this.getConsumer(consumerID);
        if (consumer != null) {
            consumer.handleMessage(message);
        }
    }

    @Override
    public void handleReceiveLargeMessage(ConsumerContext consumerID, ClientLargeMessageInternal clientLargeMessage, long largeMessageSize) throws Exception {
        ClientConsumerInternal consumer = this.getConsumer(consumerID);
        if (consumer != null) {
            consumer.handleLargeMessage(clientLargeMessage, largeMessageSize);
        }
    }

    @Override
    public void handleReceiveContinuation(ConsumerContext consumerID, byte[] chunk, int flowControlSize, boolean isContinues) throws Exception {
        ClientConsumerInternal consumer = this.getConsumer(consumerID);
        if (consumer != null) {
            consumer.handleLargeMessageContinuation(chunk, flowControlSize, isContinues);
        }
    }

    @Override
    public void handleConsumerDisconnect(ConsumerContext context) throws ActiveMQException {
        final ClientConsumerInternal consumer = this.getConsumer(context);
        if (consumer != null) {
            this.closeExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        consumer.close();
                    }
                    catch (ActiveMQException e) {
                        ActiveMQClientLogger.LOGGER.unableToCloseConsumer((Exception)((Object)e));
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws ActiveMQException {
        if (this.closed) {
            logger.debug((Object)("Session was already closed, giving up now, this=" + this));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Calling close on session " + this));
        }
        try {
            this.closeChildren();
            ClientProducerCreditManager clientProducerCreditManager = this.producerCreditManager;
            synchronized (clientProducerCreditManager) {
                this.producerCreditManager.close();
            }
            this.inClose = true;
            this.sessionContext.sessionClose();
        }
        catch (Throwable e) {
            logger.trace((Object)"Failed to close session", e);
        }
        this.doCleanup(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void cleanUp(boolean failingOver) throws ActiveMQException {
        if (this.closed) {
            return;
        }
        ClientProducerCreditManager clientProducerCreditManager = this.producerCreditManager;
        synchronized (clientProducerCreditManager) {
            this.producerCreditManager.close();
        }
        this.cleanUpChildren();
        this.doCleanup(failingOver);
    }

    @Override
    public ClientSessionImpl setSendAcknowledgementHandler(SendAcknowledgementHandler handler) {
        this.sessionContext.setSendAcknowledgementHandler(handler);
        return this;
    }

    @Override
    public void preHandleFailover(RemotingConnection connection) {
        this.sessionContext.lockCommunications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handleFailover(RemotingConnection backupConnection, ActiveMQException cause) {
        HashMap<String, String> metaDataToSend;
        boolean suc = true;
        ClientSessionImpl clientSessionImpl = this;
        synchronized (clientSessionImpl) {
            if (this.closed) {
                return true;
            }
            boolean resetCreditManager = false;
            try {
                boolean reattached = this.sessionContext.reattachOnNewConnection(backupConnection);
                if (!reattached) {
                    this.name = UUIDGenerator.getInstance().generateStringUUID();
                    this.sessionContext.resetName(this.name);
                    for (ClientConsumerInternal clientConsumerInternal : this.cloneConsumers()) {
                        clientConsumerInternal.clearAtFailover();
                    }
                    if (!this.inClose && this.mayAttemptToFailover) {
                        this.sessionContext.recreateSession(this.username, this.password, this.minLargeMessageSize, this.xa, this.autoCommitSends, this.autoCommitAcks, this.preAcknowledge);
                        for (Map.Entry entry : this.consumers.entrySet()) {
                            ClientConsumerInternal consumerInternal = (ClientConsumerInternal)entry.getValue();
                            this.sessionContext.recreateConsumerOnServer(consumerInternal, ((ConsumerContext)entry.getKey()).getId(), this.started);
                        }
                        if (!(this.autoCommitAcks && this.autoCommitSends || !this.workDone)) {
                            this.rollbackOnly = true;
                        }
                        if (this.currentXID != null) {
                            this.sessionContext.xaFailed(this.currentXID);
                            this.rollbackOnly = true;
                        }
                        if (this.started) {
                            for (ClientConsumerInternal clientConsumerInternal : this.cloneConsumers()) {
                                clientConsumerInternal.clearAtFailover();
                                clientConsumerInternal.start();
                            }
                            this.sessionContext.restartSession();
                        }
                        resetCreditManager = true;
                    }
                    this.sessionContext.returnBlocking(cause);
                }
            }
            catch (Throwable t) {
                ActiveMQClientLogger.LOGGER.failedToHandleFailover(t);
                suc = false;
            }
            finally {
                this.sessionContext.releaseCommunications();
            }
            if (resetCreditManager) {
                ClientProducerCreditManager clientProducerCreditManager = this.producerCreditManager;
                synchronized (clientProducerCreditManager) {
                    this.producerCreditManager.reset();
                }
            }
        }
        Map<String, String> map = this.metadata;
        synchronized (map) {
            metaDataToSend = new HashMap<String, String>(this.metadata);
        }
        this.sessionContext.resetMetadata(metaDataToSend);
        return suc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetaData(String key, String data) throws ActiveMQException {
        Map<String, String> map = this.metadata;
        synchronized (map) {
            this.metadata.put(key, data);
        }
        this.sessionContext.addSessionMetadata(key, data);
    }

    @Override
    public void addUniqueMetaData(String key, String data) throws ActiveMQException {
        this.sessionContext.addUniqueMetaData(key, data);
    }

    @Override
    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public void setAddress(Message message, SimpleString address) {
        logger.tracef("setAddress() Setting default address as %s", (Object)address);
        message.setAddress(address);
    }

    @Override
    public void setPacketSize(int packetSize) {
        if (packetSize > this.initialMessagePacketSize) {
            this.initialMessagePacketSize = (int)((double)packetSize * 1.2);
        }
    }

    @Override
    public void workDone() {
        this.workDone = true;
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
        this.sessionContext.sendProducerCreditsMessage(credits, address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientProducerCredits getCredits(SimpleString address, boolean anon) {
        ClientProducerCreditManager clientProducerCreditManager = this.producerCreditManager;
        synchronized (clientProducerCreditManager) {
            return this.producerCreditManager.getCredits(address, anon, this.sessionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnCredits(SimpleString address) {
        ClientProducerCreditManager clientProducerCreditManager = this.producerCreditManager;
        synchronized (clientProducerCreditManager) {
            this.producerCreditManager.returnCredits(address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReceiveProducerCredits(SimpleString address, int credits) {
        ClientProducerCreditManager clientProducerCreditManager = this.producerCreditManager;
        synchronized (clientProducerCreditManager) {
            this.producerCreditManager.receiveCredits(address, credits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReceiveProducerFailCredits(SimpleString address, int credits) {
        ClientProducerCreditManager clientProducerCreditManager = this.producerCreditManager;
        synchronized (clientProducerCreditManager) {
            this.producerCreditManager.receiveFailCredits(address, credits);
        }
    }

    @Override
    public ClientProducerCreditManager getProducerCreditManager() {
        return this.producerCreditManager;
    }

    @Override
    public void startCall() {
        if (this.concurrentCall.incrementAndGet() > 1) {
            ActiveMQClientLogger.LOGGER.invalidConcurrentSessionUsage(new Exception("trace"));
        }
    }

    @Override
    public void endCall() {
        this.concurrentCall.decrementAndGet();
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("call commit(xid=" + ClientSessionImpl.convert(xid)));
        }
        this.checkXA();
        if (this.rollbackOnly) {
            if (onePhase) {
                throw new XAException(-7);
            }
            ActiveMQClientLogger.LOGGER.commitAfterFailover();
        }
        this.startCall();
        try {
            this.sessionContext.xaCommit(xid, onePhase);
            this.workDone = false;
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable t) {
            XAException xaException;
            ActiveMQClientLogger.LOGGER.failoverDuringCommit();
            if (onePhase) {
                logger.debug((Object)("Throwing oneFase RMFAIL on xid=" + xid), t);
                xaException = new XAException(-7);
            } else {
                logger.debug((Object)("Throwing twoFase Retry on xid=" + xid), t);
                xaException = new XAException(4);
            }
            xaException.initCause(t);
            throw xaException;
        }
        finally {
            this.endCall();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Calling end:: " + ClientSessionImpl.convert(xid) + ", flags=" + this.convertTXFlag(flags)));
        }
        this.checkXA();
        try {
            if (this.rollbackOnly) {
                try {
                    this.rollback(false, false);
                }
                catch (Throwable ignored) {
                    logger.debug((Object)"Error on rollback during end call!", ignored);
                }
                throw new XAException(-7);
            }
            try {
                this.flushAcks();
                this.startCall();
                try {
                    this.sessionContext.xaEnd(xid, flags);
                }
                finally {
                    this.endCall();
                }
            }
            catch (XAException xae) {
                throw xae;
            }
            catch (Throwable t) {
                ActiveMQClientLogger.LOGGER.errorCallingEnd(t);
                XAException xaException = new XAException(-7);
                xaException.initCause(t);
                throw xaException;
            }
        }
        finally {
            this.currentXID = null;
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.checkXA();
        this.startCall();
        try {
            this.sessionContext.xaForget(xid);
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (Throwable t) {
            XAException xaException = new XAException(-7);
            xaException.initCause(t);
            throw xaException;
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        this.checkXA();
        try {
            return this.sessionContext.recoverSessionTimeout();
        }
        catch (Throwable t) {
            XAException xaException = new XAException(-7);
            xaException.initCause(t);
            throw xaException;
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        this.checkXA();
        try {
            return this.sessionContext.configureTransactionTimeout(seconds);
        }
        catch (Throwable t) {
            this.markRollbackOnly();
            XAException xaException = new XAException(-7);
            xaException.initCause(t);
            throw xaException;
        }
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        this.checkXA();
        if (this.forceNotSameRM) {
            return false;
        }
        ClientSessionInternal other = this.getSessionInternalFromXAResource(xares);
        if (other == null) {
            return false;
        }
        String liveNodeId = this.sessionFactory.getLiveNodeId();
        String otherLiveNodeId = ((ClientSessionFactoryInternal)other.getSessionFactory()).getLiveNodeId();
        if (liveNodeId != null && otherLiveNodeId != null) {
            return liveNodeId.equals(otherLiveNodeId);
        }
        return this.sessionFactory == other.getSessionFactory();
    }

    private ClientSessionInternal getSessionInternalFromXAResource(XAResource xares) {
        if (xares == null) {
            return null;
        }
        if (xares instanceof ClientSessionInternal) {
            return (ClientSessionInternal)xares;
        }
        if (xares instanceof ActiveMQXAResource) {
            return this.getSessionInternalFromXAResource(((ActiveMQXAResource)xares).getResource());
        }
        return null;
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.checkXA();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Calling prepare:: " + ClientSessionImpl.convert(xid)));
        }
        if (this.rollbackOnly) {
            throw new XAException(-7);
        }
        this.startCall();
        try {
            int n = this.sessionContext.xaPrepare(xid);
            return n;
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (ActiveMQException e) {
            if (e.getType() == ActiveMQExceptionType.UNBLOCKED || e.getType() == ActiveMQExceptionType.CONNECTION_TIMEDOUT) {
                try {
                    int n = this.sessionContext.xaPrepare(xid);
                    return n;
                }
                catch (Throwable throwable) {
                    ActiveMQClientLogger.LOGGER.failoverDuringPrepareRollingBack();
                    try {
                        this.rollback(false);
                    }
                    catch (Throwable t) {
                        XAException xaException = new XAException(-7);
                        xaException.initCause(t);
                        throw xaException;
                    }
                    ActiveMQClientLogger.LOGGER.errorDuringPrepare(e);
                    throw new XAException(-7);
                }
            }
            ActiveMQClientLogger.LOGGER.errorDuringPrepare(e);
            XAException xaException = new XAException(-7);
            xaException.initCause(e);
            throw xaException;
        }
        catch (Throwable t) {
            ActiveMQClientLogger.LOGGER.errorDuringPrepare(t);
            XAException xaException = new XAException(-7);
            xaException.initCause(t);
            throw xaException;
        }
        finally {
            this.endCall();
        }
    }

    @Override
    public Xid[] recover(int flags) throws XAException {
        this.checkXA();
        if ((flags & 0x1000000) == 0x1000000) {
            try {
                return this.sessionContext.xaScan();
            }
            catch (Throwable t) {
                XAException xaException = new XAException(-7);
                xaException.initCause(t);
                throw xaException;
            }
        }
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        this.checkXA();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Calling rollback:: " + ClientSessionImpl.convert(xid)));
        }
        try {
            boolean wasStarted = this.started;
            if (wasStarted) {
                this.stop(false);
            }
            for (ClientConsumerInternal consumer : this.cloneConsumers()) {
                consumer.clear(false);
            }
            this.flushAcks();
            try {
                this.sessionContext.xaRollback(xid, wasStarted);
            }
            finally {
                if (wasStarted) {
                    this.start();
                }
            }
            this.workDone = false;
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (ActiveMQException e) {
            if (e.getType() == ActiveMQExceptionType.UNBLOCKED || e.getType() == ActiveMQExceptionType.CONNECTION_TIMEDOUT || e.getType() == ActiveMQExceptionType.SHUTDOWN_ERROR) {
                throw new XAException(4);
            }
            XAException xaException = new XAException(-7);
            xaException.initCause(e);
            throw xaException;
        }
        catch (Throwable t) {
            XAException xaException = new XAException(-7);
            xaException.initCause(t);
            throw xaException;
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Calling start:: " + ClientSessionImpl.convert(xid) + " clientXID=" + xid + " flags = " + this.convertTXFlag(flags)));
        }
        this.checkXA();
        try {
            this.sessionContext.xaStart(xid, flags);
            this.currentXID = xid;
        }
        catch (XAException xae) {
            throw xae;
        }
        catch (ActiveMQException e) {
            if (e.getType() == ActiveMQExceptionType.UNBLOCKED || e.getType() == ActiveMQExceptionType.CONNECTION_TIMEDOUT) {
                try {
                    this.sessionContext.xaStart(xid, flags);
                }
                catch (XAException xae) {
                    throw xae;
                }
                catch (Throwable t) {
                    XAException xaException = new XAException(-7);
                    xaException.initCause(t);
                    throw xaException;
                }
            }
            XAException xaException = new XAException(-7);
            xaException.initCause(e);
            throw xaException;
        }
        catch (Throwable t) {
            XAException xaException = new XAException(-7);
            xaException.initCause(t);
            throw xaException;
        }
    }

    @Override
    public void connectionFailed(ActiveMQException me, boolean failedOver) {
        try {
            this.cleanUp(false);
        }
        catch (Exception e) {
            ActiveMQClientLogger.LOGGER.failedToCleanupSession(e);
        }
    }

    @Override
    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    @Override
    public void setForceNotSameRM(boolean force) {
        this.forceNotSameRM = force;
    }

    @Override
    public RemotingConnection getConnection() {
        return this.sessionContext.getRemotingConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Map<String, String> map = this.metadata;
        synchronized (map) {
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                buffer.append(entry.getKey() + "=" + entry.getValue() + ",");
            }
        }
        return "ClientSessionImpl [name=" + this.name + ", username=" + this.username + ", closed=" + this.closed + ", factory = " + this.sessionFactory + ", metaData=(" + buffer + ")]@" + Integer.toHexString(this.hashCode());
    }

    private ClientConsumer internalCreateConsumer(SimpleString queueName, SimpleString filterString, int priority, int windowSize, int maxRate, boolean browseOnly) throws ActiveMQException {
        this.checkClosed();
        ClientConsumerInternal consumer = this.sessionContext.createConsumer(queueName, filterString, priority, windowSize, maxRate, this.ackBatchSize, browseOnly, this.executor, this.flowControlExecutor);
        this.addConsumer(consumer);
        if (consumer.getClientWindowSize() != 0) {
            this.sessionContext.sendConsumerCredits(consumer, consumer.getInitialWindowSize());
        }
        return consumer;
    }

    private ClientProducer internalCreateProducer(SimpleString address, int maxRate) throws ActiveMQException {
        this.checkClosed();
        ClientProducerImpl producer = new ClientProducerImpl(this, address, maxRate == -1 ? null : new TokenBucketLimiterImpl(maxRate, false), this.autoCommitSends && this.blockOnNonDurableSend, this.autoCommitSends && this.blockOnDurableSend, this.autoGroup, this.groupID == null ? null : new SimpleString(this.groupID), this.minLargeMessageSize, this.sessionContext);
        this.addProducer(producer);
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalCreateQueue(SimpleString address, SimpleString queueName, boolean temp, boolean autoCreated, QueueAttributes queueAttributes) throws ActiveMQException {
        this.checkClosed();
        if (queueAttributes.getDurable().booleanValue() && temp) {
            throw ActiveMQClientMessageBundle.BUNDLE.queueMisConfigured();
        }
        this.startCall();
        try {
            this.sessionContext.createQueue(address, queueName, temp, autoCreated, queueAttributes);
        }
        finally {
            this.endCall();
        }
    }

    private void checkXA() throws XAException {
        if (!this.xa) {
            ActiveMQClientLogger.LOGGER.sessionNotXA();
            throw new XAException(-7);
        }
    }

    private void checkClosed() throws ActiveMQException {
        if (this.closed || this.inClose) {
            throw ActiveMQClientMessageBundle.BUNDLE.sessionClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConsumerInternal getConsumer(ConsumerContext consumerContext) {
        Map<ConsumerContext, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            return this.consumers.get(consumerContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCleanup(boolean failingOver) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("calling cleanup on " + this));
        }
        ClientSessionImpl clientSessionImpl = this;
        synchronized (clientSessionImpl) {
            this.closed = true;
            this.sessionContext.cleanup();
        }
        this.sessionFactory.removeSession(this, failingOver);
    }

    private void cleanUpChildren() throws ActiveMQException {
        Set<ClientConsumerInternal> consumersClone = this.cloneConsumers();
        for (ClientConsumerInternal consumer : consumersClone) {
            consumer.cleanUp();
        }
        Set<ClientProducerInternal> producersClone = this.cloneProducers();
        for (ClientProducerInternal producer : producersClone) {
            producer.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClientProducerInternal> cloneProducers() {
        HashSet<ClientProducerInternal> producersClone;
        Set<ClientProducerInternal> set = this.producers;
        synchronized (set) {
            producersClone = new HashSet<ClientProducerInternal>(this.producers);
        }
        return producersClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<ClientConsumerInternal> cloneConsumers() {
        Map<ConsumerContext, ClientConsumerInternal> map = this.consumers;
        synchronized (map) {
            return new HashSet<ClientConsumerInternal>(this.consumers.values());
        }
    }

    private void closeChildren() throws ActiveMQException {
        Set<ClientConsumerInternal> consumersClone = this.cloneConsumers();
        for (ClientConsumer clientConsumer : consumersClone) {
            clientConsumer.close();
        }
        Set<ClientProducerInternal> producersClone = this.cloneProducers();
        for (ClientProducer clientProducer : producersClone) {
            clientProducer.close();
        }
    }

    private void flushAcks() throws ActiveMQException {
        for (ClientConsumerInternal consumer : this.cloneConsumers()) {
            consumer.flushAcks();
        }
    }

    public static Object convert(Xid xid) {
        ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)200);
        XidCodecSupport.encodeXid(xid, buffer);
        Xid obj = XidCodecSupport.decodeXid(buffer);
        return "xid=" + obj + ",clientXID=" + xid;
    }

    private String convertTXFlag(int flags) {
        if (flags == 0x2000000) {
            return "SESS_XA_SUSPEND";
        }
        if (flags == 0x4000000) {
            return "TMSUCCESS";
        }
        if (flags == 0x20000000) {
            return "TMFAIL";
        }
        if (flags == 0x200000) {
            return "TMJOIN";
        }
        if (flags == 0x8000000) {
            return "TMRESUME";
        }
        if (flags == 0) {
            return "TMNOFLAGS";
        }
        return "XAER_INVAL(" + flags + ")";
    }

    @Override
    public void setStopSignal() {
        this.mayAttemptToFailover = false;
    }

    @Override
    public boolean isConfirmationWindowEnabled() {
        if (this.confirmationWindowWarning.disabled) {
            if (!this.confirmationWindowWarning.warningIssued.get()) {
                ActiveMQClientLogger.LOGGER.confirmationWindowDisabledWarning();
                this.confirmationWindowWarning.warningIssued.set(true);
            }
            return false;
        }
        return true;
    }

    @Override
    public void scheduleConfirmation(final SendAcknowledgementHandler handler, final Message message) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                handler.sendAcknowledged(message);
            }
        });
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }
}

