/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.shaded.org.jgroups.blocks.executor;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.shaded.org.jgroups.blocks.executor.ExecutionService;
import org.apache.activemq.artemis.shaded.org.jgroups.util.FutureListener;
import org.apache.activemq.artemis.shaded.org.jgroups.util.NotifyingFuture;

public class ExecutionCompletionService<V>
implements CompletionService<V> {
    protected final ExecutionService executor;
    protected final BlockingQueue<NotifyingFuture<V>> completionQueue;
    protected final QueueingListener listener;

    public ExecutionCompletionService(ExecutionService executor) {
        this(executor, null, null);
    }

    public ExecutionCompletionService(ExecutionService executor, BlockingQueue<NotifyingFuture<V>> completionQueue) {
        this(executor, completionQueue, null);
    }

    protected ExecutionCompletionService(ExecutionService executor, BlockingQueue<NotifyingFuture<V>> completionQueue, QueueingListener listener) {
        if (executor == null) {
            throw new NullPointerException();
        }
        this.executor = executor;
        this.completionQueue = completionQueue == null ? new LinkedBlockingQueue<NotifyingFuture<V>>() : completionQueue;
        this.listener = listener == null ? new QueueingListener() : listener;
    }

    @Override
    public Future<V> submit(Callable<V> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        Future f = this.executor.submit(task);
        f.setListener(this.listener);
        return f;
    }

    @Override
    public Future<V> submit(Runnable task, V result) {
        if (task == null) {
            throw new NullPointerException();
        }
        Future f = this.executor.submit(task, result);
        f.setListener(this.listener);
        return f;
    }

    @Override
    public NotifyingFuture<V> take() throws InterruptedException {
        return this.completionQueue.take();
    }

    @Override
    public NotifyingFuture<V> poll() {
        return (NotifyingFuture)this.completionQueue.poll();
    }

    @Override
    public NotifyingFuture<V> poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.completionQueue.poll(timeout, unit);
    }

    protected class QueueingListener
    implements FutureListener<V> {
        protected QueueingListener() {
        }

        @Override
        public void futureDone(Future<V> future) {
            ExecutionCompletionService.this.completionQueue.add((NotifyingFuture)future);
        }
    }
}

