/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.server.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.naming.NamingException;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActivateCallback;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueCreator;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.ResourceManager;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.jms.client.ActiveMQQueue;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.activemq.artemis.jms.client.SelectorTranslator;
import org.apache.activemq.artemis.jms.persistence.JMSStorageManager;
import org.apache.activemq.artemis.jms.persistence.config.PersistedBindings;
import org.apache.activemq.artemis.jms.persistence.config.PersistedConnectionFactory;
import org.apache.activemq.artemis.jms.persistence.config.PersistedDestination;
import org.apache.activemq.artemis.jms.persistence.config.PersistedType;
import org.apache.activemq.artemis.jms.persistence.impl.journal.JMSJournalStorageManagerImpl;
import org.apache.activemq.artemis.jms.persistence.impl.nullpm.NullJMSStorageManagerImpl;
import org.apache.activemq.artemis.jms.server.ActiveMQJMSServerBundle;
import org.apache.activemq.artemis.jms.server.ActiveMQJMSServerLogger;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.config.ConnectionFactoryConfiguration;
import org.apache.activemq.artemis.jms.server.config.JMSConfiguration;
import org.apache.activemq.artemis.jms.server.config.JMSQueueConfiguration;
import org.apache.activemq.artemis.jms.server.config.TopicConfiguration;
import org.apache.activemq.artemis.jms.server.config.impl.ConnectionFactoryConfigurationImpl;
import org.apache.activemq.artemis.jms.server.management.JMSManagementService;
import org.apache.activemq.artemis.jms.server.management.JMSNotificationType;
import org.apache.activemq.artemis.jms.server.management.impl.JMSManagementServiceImpl;
import org.apache.activemq.artemis.jms.transaction.JMSTransactionDetail;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.utils.IDGenerator;
import org.apache.activemq.artemis.utils.TimeAndCounterIDGenerator;
import org.apache.activemq.artemis.utils.TypedProperties;
import org.apache.activemq.artemis.utils.json.JSONArray;
import org.apache.activemq.artemis.utils.json.JSONObject;

public class JMSServerManagerImpl
implements JMSServerManager,
ActivateCallback {
    private static final String REJECT_FILTER = "__AMQX=-1";
    private BindingRegistry registry;
    private final Map<String, ActiveMQQueue> queues = new HashMap<String, ActiveMQQueue>();
    private final Map<String, ActiveMQTopic> topics = new HashMap<String, ActiveMQTopic>();
    private final Map<String, ActiveMQConnectionFactory> connectionFactories = new HashMap<String, ActiveMQConnectionFactory>();
    private final Map<String, List<String>> queueBindings = new HashMap<String, List<String>>();
    private final Map<String, List<String>> topicBindings = new HashMap<String, List<String>>();
    private final Map<String, List<String>> connectionFactoryBindings = new HashMap<String, List<String>>();
    private final List<Runnable> cachedCommands = new ArrayList<Runnable>();
    private final ActiveMQServer server;
    private JMSManagementService jmsManagementService;
    private boolean startCalled;
    private boolean active;
    private JMSConfiguration config;
    private Configuration coreConfig;
    private JMSStorageManager storage;
    private final Map<String, List<String>> unRecoveredBindings = new HashMap<String, List<String>>();

    public JMSServerManagerImpl(ActiveMQServer server) throws Exception {
        this.server = server;
        this.coreConfig = server.getConfiguration();
    }

    public JMSServerManagerImpl(ActiveMQServer server, BindingRegistry registry) throws Exception {
        this.server = server;
        this.coreConfig = server.getConfiguration();
        this.registry = registry;
    }

    public JMSServerManagerImpl(ActiveMQServer server, JMSConfiguration configuration) throws Exception {
        this.server = server;
        this.coreConfig = server.getConfiguration();
        this.config = configuration;
    }

    public void preActivate() {
    }

    public synchronized void activated() {
        if (!this.startCalled) {
            return;
        }
        try {
            this.jmsManagementService = new JMSManagementServiceImpl(this.server.getManagementService(), this.server, this);
            this.jmsManagementService.registerJMSServer(this);
            this.active = true;
            this.initJournal();
            this.deploy();
            for (Runnable run : this.cachedCommands) {
                ActiveMQJMSServerLogger.LOGGER.serverRunningCachedCommand(run);
                run.run();
            }
            this.recoverBindings();
        }
        catch (Exception e) {
            this.active = false;
            ActiveMQJMSServerLogger.LOGGER.jmsDeployerStartError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deActivate() {
        try {
            JMSServerManagerImpl jMSServerManagerImpl = this;
            synchronized (jMSServerManagerImpl) {
                if (!this.active) {
                    return;
                }
                if (this.storage != null && this.storage.isStarted()) {
                    this.storage.stop();
                }
                this.unbindBindings(this.queueBindings);
                this.unbindBindings(this.topicBindings);
                this.unbindBindings(this.connectionFactoryBindings);
                for (String connectionFactory : new HashSet<String>(this.connectionFactories.keySet())) {
                    this.shutdownConnectionFactory(connectionFactory);
                }
                this.connectionFactories.clear();
                this.connectionFactoryBindings.clear();
                this.queueBindings.clear();
                this.queues.clear();
                this.topicBindings.clear();
                this.topics.clear();
                if (this.jmsManagementService != null) {
                    this.jmsManagementService.unregisterJMSServer();
                    this.jmsManagementService.stop();
                }
                this.jmsManagementService = null;
                this.active = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void activationComplete() {
    }

    public void recoverregistryBindings(String name, PersistedType type) throws NamingException {
        List<String> bindings = this.unRecoveredBindings.get(name);
        if (bindings != null && bindings.size() > 0) {
            Map<String, ActiveMQQueue> objects;
            Map<String, List<String>> mapBindings;
            switch (type) {
                case Queue: {
                    mapBindings = this.queueBindings;
                    objects = this.queues;
                    break;
                }
                case Topic: {
                    mapBindings = this.topicBindings;
                    objects = this.topics;
                    break;
                }
                default: {
                    mapBindings = this.connectionFactoryBindings;
                    objects = this.connectionFactories;
                }
            }
            ActiveMQQueue objectToBind = objects.get(name);
            List<String> bindingsList = mapBindings.get(name);
            if (objectToBind == null) {
                return;
            }
            if (bindingsList == null) {
                bindingsList = new ArrayList<String>();
                mapBindings.put(name, bindingsList);
            }
            for (String binding : bindings) {
                bindingsList.add(binding);
                this.bindToBindings(binding, objectToBind);
            }
            this.unRecoveredBindings.remove(name);
        }
    }

    private void recoverBindings() throws Exception {
        List<PersistedBindings> bindingsSpace = this.storage.recoverPersistedBindings();
        for (PersistedBindings record : bindingsSpace) {
            Map<String, ActiveMQQueue> objects;
            Map<String, List<String>> mapBindings;
            switch (record.getType()) {
                case Queue: {
                    mapBindings = this.queueBindings;
                    objects = this.queues;
                    break;
                }
                case Topic: {
                    mapBindings = this.topicBindings;
                    objects = this.topics;
                    break;
                }
                default: {
                    mapBindings = this.connectionFactoryBindings;
                    objects = this.connectionFactories;
                }
            }
            ActiveMQQueue objectToBind = objects.get(record.getName());
            List<String> bindingsList = mapBindings.get(record.getName());
            if (objectToBind == null) {
                this.unRecoveredBindings.put(record.getName(), record.getBindings());
                continue;
            }
            if (bindingsList == null) {
                bindingsList = new ArrayList<String>();
                mapBindings.put(record.getName(), bindingsList);
            }
            for (String bindings : record.getBindings()) {
                bindingsList.add(bindings);
                this.bindToBindings(bindings, objectToBind);
            }
        }
    }

    public synchronized void start() throws Exception {
        if (this.startCalled) {
            return;
        }
        this.server.setJMSQueueCreator((QueueCreator)new JMSQueueCreator());
        this.server.registerActivateCallback((ActivateCallback)this);
        this.startCalled = true;
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        JMSServerManagerImpl jMSServerManagerImpl = this;
        synchronized (jMSServerManagerImpl) {
            if (!this.startCalled) {
                return;
            }
            this.startCalled = false;
            this.deActivate();
            if (this.registry != null) {
                this.registry.close();
            }
        }
        this.server.stop();
    }

    @Override
    public boolean isStarted() {
        return this.server.isStarted();
    }

    @Override
    public BindingRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void setRegistry(BindingRegistry registry) {
        this.registry = registry;
    }

    @Override
    public ActiveMQServer getActiveMQServer() {
        return this.server;
    }

    @Override
    public void addAddressSettings(String address, AddressSettings addressSettings) {
        this.server.getAddressSettingsRepository().addMatch(address, (Object)addressSettings);
    }

    @Override
    public AddressSettings getAddressSettings(String address) {
        return (AddressSettings)this.server.getAddressSettingsRepository().getMatch(address);
    }

    @Override
    public void addSecurity(String addressMatch, Set<Role> roles) {
        this.server.getSecurityRepository().addMatch(addressMatch, roles);
    }

    @Override
    public Set<Role> getSecurity(String addressMatch) {
        return (Set)this.server.getSecurityRepository().getMatch(addressMatch);
    }

    @Override
    public synchronized String getVersion() {
        this.checkInitialised();
        return this.server.getVersion().getFullVersion();
    }

    @Override
    public synchronized boolean createQueue(boolean storeConfig, String queueName, String selectorString, boolean durable, String ... bindings) throws Exception {
        return this.internalCreateJMSQueue(storeConfig, queueName, selectorString, durable, false, bindings);
    }

    protected boolean internalCreateJMSQueue(final boolean storeConfig, final String queueName, final String selectorString, final boolean durable, boolean autoCreated, final String ... bindings) throws Exception {
        if (this.active && this.queues.get(queueName) != null) {
            return false;
        }
        this.runAfterActive(new WrappedRunnable(){

            public String toString() {
                return "createQueue for " + queueName;
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.checkBindings(bindings);
                if (JMSServerManagerImpl.this.internalCreateQueue(queueName, selectorString, durable)) {
                    ActiveMQDestination destination = (ActiveMQDestination)JMSServerManagerImpl.this.queues.get(queueName);
                    if (destination == null) {
                        throw new IllegalArgumentException("Queue does not exist");
                    }
                    String[] usedBindings = null;
                    if (bindings != null) {
                        ArrayList<String> bindingsToAdd = new ArrayList<String>();
                        for (String bindingsItem : bindings) {
                            if (!JMSServerManagerImpl.this.bindToBindings(bindingsItem, destination)) continue;
                            bindingsToAdd.add(bindingsItem);
                        }
                        usedBindings = bindingsToAdd.toArray(new String[bindingsToAdd.size()]);
                        JMSServerManagerImpl.this.addToBindings(JMSServerManagerImpl.this.queueBindings, queueName, usedBindings);
                    }
                    if (storeConfig && durable) {
                        JMSServerManagerImpl.this.storage.storeDestination(new PersistedDestination(PersistedType.Queue, queueName, selectorString, durable));
                        if (usedBindings != null) {
                            JMSServerManagerImpl.this.storage.addBindings(PersistedType.Queue, queueName, usedBindings);
                        }
                    }
                }
            }
        });
        this.sendNotification(JMSNotificationType.QUEUE_CREATED, queueName);
        return true;
    }

    @Override
    public synchronized boolean createTopic(final boolean storeConfig, final String topicName, final String ... bindings) throws Exception {
        if (this.active && this.topics.get(topicName) != null) {
            return false;
        }
        this.runAfterActive(new WrappedRunnable(){

            public String toString() {
                return "createTopic for " + topicName;
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.checkBindings(bindings);
                if (JMSServerManagerImpl.this.internalCreateTopic(topicName)) {
                    ActiveMQDestination destination = (ActiveMQDestination)JMSServerManagerImpl.this.topics.get(topicName);
                    if (destination == null) {
                        throw new IllegalArgumentException("Queue does not exist");
                    }
                    ArrayList<String> bindingsToAdd = new ArrayList<String>();
                    if (bindings != null) {
                        for (String bindingsItem : bindings) {
                            if (!JMSServerManagerImpl.this.bindToBindings(bindingsItem, destination)) continue;
                            bindingsToAdd.add(bindingsItem);
                        }
                    }
                    String[] usedBindings = bindingsToAdd.toArray(new String[bindingsToAdd.size()]);
                    JMSServerManagerImpl.this.addToBindings(JMSServerManagerImpl.this.topicBindings, topicName, usedBindings);
                    if (storeConfig) {
                        JMSServerManagerImpl.this.storage.storeDestination(new PersistedDestination(PersistedType.Topic, topicName));
                        JMSServerManagerImpl.this.storage.addBindings(PersistedType.Topic, topicName, usedBindings);
                    }
                }
            }
        });
        this.sendNotification(JMSNotificationType.TOPIC_CREATED, topicName);
        return true;
    }

    @Override
    public boolean addTopicToBindingRegistry(String topicName, String registryBinding) throws Exception {
        this.checkInitialised();
        this.checkBindings(registryBinding);
        ActiveMQTopic destination = this.topics.get(topicName);
        if (destination == null) {
            throw new IllegalArgumentException("Topic does not exist");
        }
        if (destination.getTopicName() == null) {
            throw new IllegalArgumentException(topicName + " is not a topic");
        }
        boolean added = this.bindToBindings(registryBinding, destination);
        if (added) {
            this.addToBindings(this.topicBindings, topicName, registryBinding);
            this.storage.addBindings(PersistedType.Topic, topicName, registryBinding);
        }
        return added;
    }

    @Override
    public String[] getBindingsOnQueue(String queue) {
        return this.getBindingsList(this.queueBindings, queue);
    }

    @Override
    public String[] getBindingsOnTopic(String topic) {
        return this.getBindingsList(this.topicBindings, topic);
    }

    @Override
    public String[] getBindingsOnConnectionFactory(String factoryName) {
        return this.getBindingsList(this.connectionFactoryBindings, factoryName);
    }

    @Override
    public boolean addQueueToBindingRegistry(String queueName, String registryBinding) throws Exception {
        this.checkInitialised();
        this.checkBindings(registryBinding);
        ActiveMQQueue destination = this.queues.get(queueName);
        if (destination == null) {
            throw new IllegalArgumentException("Queue does not exist");
        }
        if (destination.getQueueName() == null) {
            throw new IllegalArgumentException(queueName + " is not a queue");
        }
        boolean added = this.bindToBindings(registryBinding, destination);
        if (added) {
            this.addToBindings(this.queueBindings, queueName, registryBinding);
            this.storage.addBindings(PersistedType.Queue, queueName, registryBinding);
        }
        return added;
    }

    @Override
    public boolean addConnectionFactoryToBindingRegistry(String name, String registryBinding) throws Exception {
        this.checkInitialised();
        this.checkBindings(registryBinding);
        ActiveMQConnectionFactory factory = this.connectionFactories.get(name);
        if (factory == null) {
            throw new IllegalArgumentException("Factory does not exist");
        }
        if (this.registry.lookup(registryBinding) != null) {
            throw ActiveMQJMSServerBundle.BUNDLE.cfBindingsExists(name);
        }
        boolean added = this.bindToBindings(registryBinding, factory);
        if (added) {
            this.addToBindings(this.connectionFactoryBindings, name, registryBinding);
            this.storage.addBindings(PersistedType.ConnectionFactory, name, registryBinding);
        }
        return added;
    }

    @Override
    public boolean removeQueueFromBindingRegistry(String name, String bindings) throws Exception {
        this.checkInitialised();
        boolean removed = this.removeFromBindings(this.queueBindings, name, bindings);
        if (removed) {
            this.storage.deleteBindings(PersistedType.Queue, name, bindings);
        }
        return removed;
    }

    @Override
    public boolean removeQueueFromBindingRegistry(final String name) throws Exception {
        final AtomicBoolean valueReturn = new AtomicBoolean(false);
        this.runAfterActive(new WrappedRunnable(){

            public String toString() {
                return "removeQueueFromBindings for " + name;
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.checkInitialised();
                if (JMSServerManagerImpl.this.removeFromBindings(JMSServerManagerImpl.this.queues, JMSServerManagerImpl.this.queueBindings, name)) {
                    JMSServerManagerImpl.this.storage.deleteDestination(PersistedType.Queue, name);
                    valueReturn.set(true);
                }
            }
        });
        return valueReturn.get();
    }

    @Override
    public boolean removeTopicFromBindingRegistry(String name, String bindings) throws Exception {
        this.checkInitialised();
        if (this.removeFromBindings(this.topicBindings, name, bindings)) {
            this.storage.deleteBindings(PersistedType.Topic, name, bindings);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTopicFromBindingRegistry(final String name) throws Exception {
        final AtomicBoolean valueReturn = new AtomicBoolean(false);
        this.runAfterActive(new WrappedRunnable(){

            public String toString() {
                return "removeTopicFromBindings for " + name;
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.checkInitialised();
                if (JMSServerManagerImpl.this.removeFromBindings(JMSServerManagerImpl.this.topics, JMSServerManagerImpl.this.topicBindings, name)) {
                    JMSServerManagerImpl.this.storage.deleteDestination(PersistedType.Topic, name);
                    valueReturn.set(true);
                }
            }
        });
        return valueReturn.get();
    }

    @Override
    public boolean removeConnectionFactoryFromBindingRegistry(String name, String bindings) throws Exception {
        this.checkInitialised();
        this.removeFromBindings(this.connectionFactoryBindings, name, bindings);
        this.storage.deleteBindings(PersistedType.ConnectionFactory, name, bindings);
        return true;
    }

    @Override
    public boolean removeConnectionFactoryFromBindingRegistry(String name) throws Exception {
        this.checkInitialised();
        this.removeFromBindings(this.connectionFactories, this.connectionFactoryBindings, name);
        this.storage.deleteConnectionFactory(name);
        return true;
    }

    @Override
    public synchronized boolean destroyQueue(String name) throws Exception {
        return this.destroyQueue(name, true);
    }

    @Override
    public synchronized boolean destroyQueue(String name, boolean removeConsumers) throws Exception {
        this.checkInitialised();
        this.server.destroyQueue(ActiveMQDestination.createQueueAddressFromName((String)name), null, !removeConsumers, removeConsumers);
        if (this.server.getPostOffice().getBinding(ActiveMQDestination.createQueueAddressFromName((String)name)) == null) {
            this.removeFromBindings(this.queues, this.queueBindings, name);
            this.queues.remove(name);
            this.queueBindings.remove(name);
            this.jmsManagementService.unregisterQueue(name);
            this.storage.deleteDestination(PersistedType.Queue, name);
            this.sendNotification(JMSNotificationType.QUEUE_DESTROYED, name);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean destroyTopic(String name) throws Exception {
        return this.destroyTopic(name, true);
    }

    @Override
    public synchronized boolean destroyTopic(String name, boolean removeConsumers) throws Exception {
        this.checkInitialised();
        AddressControl addressControl = (AddressControl)this.server.getManagementService().getResource("core.address." + ActiveMQDestination.createTopicAddressFromName((String)name));
        if (addressControl != null) {
            for (String queueName : addressControl.getQueueNames()) {
                Binding binding = this.server.getPostOffice().getBinding(new SimpleString(queueName));
                if (binding == null) {
                    ActiveMQJMSServerLogger.LOGGER.noQueueOnTopic(queueName, name);
                    continue;
                }
                if (binding.getType() == BindingType.REMOTE_QUEUE) continue;
                this.server.destroyQueue(SimpleString.toSimpleString((String)queueName), null, !removeConsumers, removeConsumers);
            }
            if (addressControl.getQueueNames().length == 0) {
                this.removeFromBindings(this.topics, this.topicBindings, name);
                this.topics.remove(name);
                this.topicBindings.remove(name);
                this.jmsManagementService.unregisterTopic(name);
                this.storage.deleteDestination(PersistedType.Topic, name);
                this.sendNotification(JMSNotificationType.TOPIC_DESTROYED, name);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public synchronized void createConnectionFactory(String name, boolean ha, JMSFactoryType cfType, List<String> connectorNames, String ... registryBindings) throws Exception {
        this.checkInitialised();
        ActiveMQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfiguration configuration = new ConnectionFactoryConfigurationImpl().setName(name).setHA(ha).setConnectorNames(connectorNames).setFactoryType(cfType);
            this.createConnectionFactory(true, configuration, registryBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, boolean ha, JMSFactoryType cfType, List<String> connectorNames, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, long callFailoverTimeout, boolean cacheLargeMessagesClient, int minLargeMessageSize, boolean compressLargeMessage, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, String groupId, String ... registryBindings) throws Exception {
        this.checkInitialised();
        ActiveMQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfiguration configuration = new ConnectionFactoryConfigurationImpl().setName(name).setHA(ha).setConnectorNames(connectorNames).setClientID(clientID).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setFactoryType(cfType).setCallTimeout(callTimeout).setCallFailoverTimeout(callFailoverTimeout).setCacheLargeMessagesClient(cacheLargeMessagesClient).setMinLargeMessageSize(minLargeMessageSize).setConsumerWindowSize(consumerWindowSize).setConsumerMaxRate(consumerMaxRate).setConfirmationWindowSize(confirmationWindowSize).setProducerWindowSize(producerWindowSize).setProducerMaxRate(producerMaxRate).setBlockOnAcknowledge(blockOnAcknowledge).setBlockOnDurableSend(blockOnDurableSend).setBlockOnNonDurableSend(blockOnNonDurableSend).setAutoGroup(autoGroup).setPreAcknowledge(preAcknowledge).setLoadBalancingPolicyClassName(loadBalancingPolicyClassName).setTransactionBatchSize(transactionBatchSize).setDupsOKBatchSize(dupsOKBatchSize).setUseGlobalPools(useGlobalPools).setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize).setThreadPoolMaxSize(threadPoolMaxSize).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setMaxRetryInterval(maxRetryInterval).setReconnectAttempts(reconnectAttempts).setFailoverOnInitialConnection(failoverOnInitialConnection).setGroupID(groupId);
            this.createConnectionFactory(true, configuration, registryBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, boolean ha, JMSFactoryType cfType, String discoveryGroupName, String clientID, long clientFailureCheckPeriod, long connectionTTL, long callTimeout, long callFailoverTimeout, boolean cacheLargeMessagesClient, int minLargeMessageSize, boolean compressLargeMessages, int consumerWindowSize, int consumerMaxRate, int confirmationWindowSize, int producerWindowSize, int producerMaxRate, boolean blockOnAcknowledge, boolean blockOnDurableSend, boolean blockOnNonDurableSend, boolean autoGroup, boolean preAcknowledge, String loadBalancingPolicyClassName, int transactionBatchSize, int dupsOKBatchSize, boolean useGlobalPools, int scheduledThreadPoolMaxSize, int threadPoolMaxSize, long retryInterval, double retryIntervalMultiplier, long maxRetryInterval, int reconnectAttempts, boolean failoverOnInitialConnection, String groupId, String ... registryBindings) throws Exception {
        this.checkInitialised();
        ActiveMQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfiguration configuration = new ConnectionFactoryConfigurationImpl().setName(name).setHA(ha).setBindings(registryBindings).setDiscoveryGroupName(discoveryGroupName).setFactoryType(cfType).setClientID(clientID).setClientFailureCheckPeriod(clientFailureCheckPeriod).setConnectionTTL(connectionTTL).setCallTimeout(callTimeout).setCallFailoverTimeout(callFailoverTimeout).setCacheLargeMessagesClient(cacheLargeMessagesClient).setMinLargeMessageSize(minLargeMessageSize).setCompressLargeMessages(compressLargeMessages).setConsumerWindowSize(consumerWindowSize).setConsumerMaxRate(consumerMaxRate).setConfirmationWindowSize(confirmationWindowSize).setProducerWindowSize(producerWindowSize).setProducerMaxRate(producerMaxRate).setBlockOnAcknowledge(blockOnAcknowledge).setBlockOnDurableSend(blockOnDurableSend).setBlockOnNonDurableSend(blockOnNonDurableSend).setAutoGroup(autoGroup).setPreAcknowledge(preAcknowledge).setLoadBalancingPolicyClassName(loadBalancingPolicyClassName).setTransactionBatchSize(transactionBatchSize).setDupsOKBatchSize(dupsOKBatchSize).setUseGlobalPools(useGlobalPools).setScheduledThreadPoolMaxSize(scheduledThreadPoolMaxSize).setThreadPoolMaxSize(threadPoolMaxSize).setRetryInterval(retryInterval).setRetryIntervalMultiplier(retryIntervalMultiplier).setMaxRetryInterval(maxRetryInterval).setReconnectAttempts(reconnectAttempts).setFailoverOnInitialConnection(failoverOnInitialConnection);
            this.createConnectionFactory(true, configuration, registryBindings);
        }
    }

    @Override
    public synchronized void createConnectionFactory(String name, boolean ha, JMSFactoryType cfType, String discoveryGroupName, String ... registryBindings) throws Exception {
        this.checkInitialised();
        ActiveMQConnectionFactory cf = this.connectionFactories.get(name);
        if (cf == null) {
            ConnectionFactoryConfiguration configuration = new ConnectionFactoryConfigurationImpl().setName(name).setHA(ha).setBindings(registryBindings).setDiscoveryGroupName(discoveryGroupName);
            this.createConnectionFactory(true, configuration, registryBindings);
        }
    }

    @Override
    public synchronized ActiveMQConnectionFactory recreateCF(String name, ConnectionFactoryConfiguration cf) throws Exception {
        List<String> bindings = this.connectionFactoryBindings.get(name);
        if (bindings == null) {
            throw ActiveMQJMSServerBundle.BUNDLE.cfDoesntExist(name);
        }
        String[] usedBindings = bindings.toArray(new String[bindings.size()]);
        ActiveMQConnectionFactory realCF = this.internalCreateCFPOJO(cf);
        if (cf.isPersisted()) {
            this.storage.storeConnectionFactory(new PersistedConnectionFactory(cf));
            this.storage.addBindings(PersistedType.ConnectionFactory, cf.getName(), usedBindings);
        }
        for (String bindingsElement : usedBindings) {
            this.bindToBindings(bindingsElement, realCF);
        }
        return realCF;
    }

    @Override
    public synchronized void createConnectionFactory(final boolean storeConfig, final ConnectionFactoryConfiguration cfConfig, final String ... bindings) throws Exception {
        this.runAfterActive(new WrappedRunnable(){

            public String toString() {
                return "createConnectionFactory for " + cfConfig.getName();
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.checkBindings(bindings);
                ActiveMQConnectionFactory cf = JMSServerManagerImpl.this.internalCreateCF(storeConfig, cfConfig);
                ArrayList<String> bindingsToAdd = new ArrayList<String>();
                for (String bindingsItem : bindings) {
                    if (!JMSServerManagerImpl.this.bindToBindings(bindingsItem, cf)) continue;
                    bindingsToAdd.add(bindingsItem);
                }
                String[] usedBindings = bindingsToAdd.toArray(new String[bindingsToAdd.size()]);
                JMSServerManagerImpl.this.addToBindings(JMSServerManagerImpl.this.connectionFactoryBindings, cfConfig.getName(), usedBindings);
                if (storeConfig) {
                    JMSServerManagerImpl.this.storage.storeConnectionFactory(new PersistedConnectionFactory(cfConfig));
                    JMSServerManagerImpl.this.storage.addBindings(PersistedType.ConnectionFactory, cfConfig.getName(), usedBindings);
                }
                JMSServerManagerImpl.this.recoverregistryBindings(cfConfig.getName(), PersistedType.ConnectionFactory);
                JMSServerManagerImpl.this.sendNotification(JMSNotificationType.CONNECTION_FACTORY_CREATED, cfConfig.getName());
            }
        });
    }

    private void sendNotification(JMSNotificationType type, String message) {
        TypedProperties prop = new TypedProperties();
        prop.putSimpleStringProperty(JMSNotificationType.MESSAGE, SimpleString.toSimpleString((String)message));
        Notification notif = new Notification(null, (NotificationType)type, prop);
        try {
            this.server.getManagementService().sendNotification(notif);
        }
        catch (Exception e) {
            ActiveMQJMSServerLogger.LOGGER.warn("Failed to send notification : " + notif);
        }
    }

    public JMSStorageManager getJMSStorageManager() {
        return this.storage;
    }

    public void replaceStorageManager(JMSStorageManager newStorage) {
        this.storage = newStorage;
    }

    private String[] getBindingsList(Map<String, List<String>> map, String name) {
        List<String> result = map.get(name);
        if (result == null) {
            return new String[0];
        }
        String[] strings = new String[result.size()];
        result.toArray(strings);
        return strings;
    }

    private boolean internalCreateQueue(String queueName, String selectorString, boolean durable) throws Exception {
        if (this.queues.get(queueName) != null) {
            return false;
        }
        ActiveMQQueue activeMQQueue = ActiveMQDestination.createQueue((String)queueName);
        String coreFilterString = null;
        if (selectorString != null) {
            coreFilterString = SelectorTranslator.convertToActiveMQFilterString((String)selectorString);
        }
        Queue queue = this.server.deployQueue(SimpleString.toSimpleString((String)activeMQQueue.getAddress()), SimpleString.toSimpleString((String)activeMQQueue.getAddress()), SimpleString.toSimpleString((String)coreFilterString), durable, false);
        this.queues.put(queueName, activeMQQueue);
        this.recoverregistryBindings(queueName, PersistedType.Queue);
        this.jmsManagementService.registerQueue(activeMQQueue, queue);
        return true;
    }

    private boolean internalCreateTopic(String topicName) throws Exception {
        if (this.topics.get(topicName) != null) {
            return false;
        }
        ActiveMQTopic activeMQTopic = ActiveMQDestination.createTopic((String)topicName);
        this.server.deployQueue(SimpleString.toSimpleString((String)activeMQTopic.getAddress()), SimpleString.toSimpleString((String)activeMQTopic.getAddress()), SimpleString.toSimpleString((String)REJECT_FILTER), true, false);
        this.topics.put(topicName, activeMQTopic);
        this.recoverregistryBindings(topicName, PersistedType.Topic);
        this.jmsManagementService.registerTopic(activeMQTopic);
        return true;
    }

    private ActiveMQConnectionFactory internalCreateCF(boolean persisted, ConnectionFactoryConfiguration cfConfig) throws Exception {
        this.checkInitialised();
        ActiveMQConnectionFactory cf = this.connectionFactories.get(cfConfig.getName());
        if (cf == null) {
            cf = this.internalCreateCFPOJO(cfConfig);
        }
        this.connectionFactories.put(cfConfig.getName(), cf);
        this.jmsManagementService.registerConnectionFactory(cfConfig.getName(), cfConfig, cf);
        return cf;
    }

    protected ActiveMQConnectionFactory internalCreateCFPOJO(ConnectionFactoryConfiguration cfConfig) throws ActiveMQException {
        ActiveMQConnectionFactory cf;
        if (cfConfig.getDiscoveryGroupName() != null) {
            DiscoveryGroupConfiguration groupConfig = (DiscoveryGroupConfiguration)this.server.getConfiguration().getDiscoveryGroupConfigurations().get(cfConfig.getDiscoveryGroupName());
            if (groupConfig == null) {
                throw ActiveMQJMSServerBundle.BUNDLE.discoveryGroupDoesntExist(cfConfig.getDiscoveryGroupName());
            }
            cf = cfConfig.isHA() ? ActiveMQJMSClient.createConnectionFactoryWithHA((DiscoveryGroupConfiguration)groupConfig, (JMSFactoryType)cfConfig.getFactoryType()) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((DiscoveryGroupConfiguration)groupConfig, (JMSFactoryType)cfConfig.getFactoryType());
        } else {
            if (cfConfig.getConnectorNames() == null || cfConfig.getConnectorNames().size() == 0) {
                throw ActiveMQJMSServerBundle.BUNDLE.noConnectorNameOnCF();
            }
            TransportConfiguration[] configs = new TransportConfiguration[cfConfig.getConnectorNames().size()];
            int count = 0;
            for (String name : cfConfig.getConnectorNames()) {
                TransportConfiguration connector = (TransportConfiguration)this.server.getConfiguration().getConnectorConfigurations().get(name);
                if (connector == null) {
                    throw ActiveMQJMSServerBundle.BUNDLE.noConnectorNameConfiguredOnCF(name);
                }
                this.correctInvalidNettyConnectorHost(connector);
                configs[count++] = connector;
            }
            cf = cfConfig.isHA() ? ActiveMQJMSClient.createConnectionFactoryWithHA((JMSFactoryType)cfConfig.getFactoryType(), (TransportConfiguration[])configs) : ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)cfConfig.getFactoryType(), (TransportConfiguration[])configs);
        }
        cf.setClientID(cfConfig.getClientID());
        cf.setClientFailureCheckPeriod(cfConfig.getClientFailureCheckPeriod());
        cf.setConnectionTTL(cfConfig.getConnectionTTL());
        cf.setCallTimeout(cfConfig.getCallTimeout());
        cf.setCallFailoverTimeout(cfConfig.getCallFailoverTimeout());
        cf.setCacheLargeMessagesClient(cfConfig.isCacheLargeMessagesClient());
        cf.setMinLargeMessageSize(cfConfig.getMinLargeMessageSize());
        cf.setConsumerWindowSize(cfConfig.getConsumerWindowSize());
        cf.setConsumerMaxRate(cfConfig.getConsumerMaxRate());
        cf.setConfirmationWindowSize(cfConfig.getConfirmationWindowSize());
        cf.setProducerWindowSize(cfConfig.getProducerWindowSize());
        cf.setProducerMaxRate(cfConfig.getProducerMaxRate());
        cf.setBlockOnAcknowledge(cfConfig.isBlockOnAcknowledge());
        cf.setBlockOnDurableSend(cfConfig.isBlockOnDurableSend());
        cf.setBlockOnNonDurableSend(cfConfig.isBlockOnNonDurableSend());
        cf.setAutoGroup(cfConfig.isAutoGroup());
        cf.setPreAcknowledge(cfConfig.isPreAcknowledge());
        cf.setConnectionLoadBalancingPolicyClassName(cfConfig.getLoadBalancingPolicyClassName());
        cf.setTransactionBatchSize(cfConfig.getTransactionBatchSize());
        cf.setDupsOKBatchSize(cfConfig.getDupsOKBatchSize());
        cf.setUseGlobalPools(cfConfig.isUseGlobalPools());
        cf.setScheduledThreadPoolMaxSize(cfConfig.getScheduledThreadPoolMaxSize());
        cf.setThreadPoolMaxSize(cfConfig.getThreadPoolMaxSize());
        cf.setRetryInterval(cfConfig.getRetryInterval());
        cf.setRetryIntervalMultiplier(cfConfig.getRetryIntervalMultiplier());
        cf.setMaxRetryInterval(cfConfig.getMaxRetryInterval());
        cf.setReconnectAttempts(cfConfig.getReconnectAttempts());
        cf.setFailoverOnInitialConnection(cfConfig.isFailoverOnInitialConnection());
        cf.setCompressLargeMessage(cfConfig.isCompressLargeMessages());
        cf.setGroupID(cfConfig.getGroupID());
        return cf;
    }

    @Override
    public synchronized boolean destroyConnectionFactory(final String name) throws Exception {
        final AtomicBoolean valueReturn = new AtomicBoolean(false);
        this.runAfterActive(new WrappedRunnable(){

            public String toString() {
                return "destroyConnectionFactory for " + name;
            }

            @Override
            public void runException() throws Exception {
                JMSServerManagerImpl.this.shutdownConnectionFactory(name);
                JMSServerManagerImpl.this.storage.deleteConnectionFactory(name);
                valueReturn.set(true);
            }
        });
        if (valueReturn.get()) {
            this.sendNotification(JMSNotificationType.CONNECTION_FACTORY_DESTROYED, name);
        }
        return valueReturn.get();
    }

    protected boolean shutdownConnectionFactory(String name) throws Exception {
        this.checkInitialised();
        List<String> registryBindings = this.connectionFactoryBindings.get(name);
        if (this.registry != null) {
            for (String registryBinding : registryBindings) {
                this.registry.unbind(registryBinding);
            }
        }
        this.connectionFactoryBindings.remove(name);
        this.connectionFactories.remove(name);
        this.jmsManagementService.unregisterConnectionFactory(name);
        return true;
    }

    @Override
    public String[] listRemoteAddresses() throws Exception {
        this.checkInitialised();
        return this.server.getActiveMQServerControl().listRemoteAddresses();
    }

    @Override
    public String[] listRemoteAddresses(String ipAddress) throws Exception {
        this.checkInitialised();
        return this.server.getActiveMQServerControl().listRemoteAddresses(ipAddress);
    }

    @Override
    public boolean closeConnectionsForAddress(String ipAddress) throws Exception {
        this.checkInitialised();
        return this.server.getActiveMQServerControl().closeConnectionsForAddress(ipAddress);
    }

    @Override
    public boolean closeConsumerConnectionsForAddress(String address) throws Exception {
        this.checkInitialised();
        return this.server.getActiveMQServerControl().closeConsumerConnectionsForAddress(address);
    }

    @Override
    public boolean closeConnectionsForUser(String userName) throws Exception {
        this.checkInitialised();
        return this.server.getActiveMQServerControl().closeConnectionsForUser(userName);
    }

    @Override
    public String[] listConnectionIDs() throws Exception {
        return this.server.getActiveMQServerControl().listConnectionIDs();
    }

    @Override
    public String[] listSessions(String connectionID) throws Exception {
        this.checkInitialised();
        return this.server.getActiveMQServerControl().listSessions(connectionID);
    }

    @Override
    public String listPreparedTransactionDetailsAsJSON() throws Exception {
        ResourceManager resourceManager = this.server.getResourceManager();
        Map xids = resourceManager.getPreparedTransactionsWithCreationTime();
        if (xids == null || xids.size() == 0) {
            return "";
        }
        ArrayList xidsSortedByCreationTime = new ArrayList(xids.entrySet());
        Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

            @Override
            public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                return (int)(entry1.getValue() - entry2.getValue());
            }
        });
        JSONArray txDetailListJson = new JSONArray();
        for (Map.Entry entry : xidsSortedByCreationTime) {
            Xid xid = (Xid)entry.getKey();
            Transaction tx = resourceManager.getTransaction(xid);
            if (tx == null) continue;
            JMSTransactionDetail detail = new JMSTransactionDetail(xid, tx, (Long)entry.getValue());
            txDetailListJson.put((Object)detail.toJSON());
        }
        return txDetailListJson.toString();
    }

    @Override
    public String listPreparedTransactionDetailsAsHTML() throws Exception {
        ResourceManager resourceManager = this.server.getResourceManager();
        Map xids = resourceManager.getPreparedTransactionsWithCreationTime();
        if (xids == null || xids.size() == 0) {
            return "<h3>*** Prepared Transaction Details ***</h3><p>No entry.</p>";
        }
        ArrayList xidsSortedByCreationTime = new ArrayList(xids.entrySet());
        Collections.sort(xidsSortedByCreationTime, new Comparator<Map.Entry<Xid, Long>>(){

            @Override
            public int compare(Map.Entry<Xid, Long> entry1, Map.Entry<Xid, Long> entry2) {
                return (int)(entry1.getValue() - entry2.getValue());
            }
        });
        StringBuilder html = new StringBuilder();
        html.append("<h3>*** Prepared Transaction Details ***</h3>");
        for (Map.Entry entry : xidsSortedByCreationTime) {
            Xid xid = (Xid)entry.getKey();
            Transaction tx = resourceManager.getTransaction(xid);
            if (tx == null) continue;
            JMSTransactionDetail detail = new JMSTransactionDetail(xid, tx, (Long)entry.getValue());
            JSONObject txJson = detail.toJSON();
            html.append("<table border=\"1\">");
            html.append("<tr><th>creation_time</th>");
            html.append("<td>" + txJson.get("creation_time") + "</td>");
            html.append("<th>xid_as_base_64</th>");
            html.append("<td colspan=\"3\">" + txJson.get("xid_as_base64") + "</td></tr>");
            html.append("<tr><th>xid_format_id</th>");
            html.append("<td>" + txJson.get("xid_format_id") + "</td>");
            html.append("<th>xid_global_txid</th>");
            html.append("<td>" + txJson.get("xid_global_txid") + "</td>");
            html.append("<th>xid_branch_qual</th>");
            html.append("<td>" + txJson.get("xid_branch_qual") + "</td></tr>");
            html.append("<tr><th colspan=\"6\">Message List</th></tr>");
            html.append("<tr><td colspan=\"6\">");
            html.append("<table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">");
            JSONArray msgs = txJson.getJSONArray("tx_related_messages");
            for (int i = 0; i < msgs.length(); ++i) {
                JSONObject msgJson = msgs.getJSONObject(i);
                JSONObject props = msgJson.getJSONObject("message_properties");
                StringBuilder propstr = new StringBuilder();
                Iterator propkeys = props.keys();
                while (propkeys.hasNext()) {
                    String key = (String)propkeys.next();
                    propstr.append(key);
                    propstr.append("=");
                    propstr.append(props.get(key));
                    propstr.append(", ");
                }
                html.append("<th>operation_type</th>");
                html.append("<td>" + msgJson.get("message_operation_type") + "</th>");
                html.append("<th>message_type</th>");
                html.append("<td>" + msgJson.get("message_type") + "</td></tr>");
                html.append("<tr><th>properties</th>");
                html.append("<td colspan=\"3\">" + propstr.toString() + "</td></tr>");
            }
            html.append("</table></td></tr>");
            html.append("</table><br/>");
        }
        return html.toString();
    }

    private synchronized void checkInitialised() {
        if (!this.active) {
            throw new IllegalStateException("Cannot access JMS Server, core server is not yet active");
        }
    }

    private void addToBindings(Map<String, List<String>> map, String name, String ... bindings) {
        List<String> list = map.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            map.put(name, list);
        }
        for (String bindingsItem : bindings) {
            list.add(bindingsItem);
        }
    }

    private void checkBindings(String ... bindingsNames) throws NamingException {
        if (bindingsNames != null) {
            for (String bindingsName : bindingsNames) {
                if (this.registry == null || this.registry.lookup(bindingsName) == null) continue;
                throw new NamingException(bindingsName + " already has an object bound");
            }
        }
    }

    private boolean bindToBindings(String bindingsName, Object objectToBind) throws NamingException {
        if (this.registry != null) {
            this.registry.unbind(bindingsName);
            this.registry.bind(bindingsName, objectToBind);
        }
        return true;
    }

    private void deploy() throws Exception {
        if (this.config == null) {
            return;
        }
        List<ConnectionFactoryConfiguration> connectionFactoryConfigurations = this.config.getConnectionFactoryConfigurations();
        for (ConnectionFactoryConfiguration connectionFactoryConfiguration : connectionFactoryConfigurations) {
            this.createConnectionFactory(false, connectionFactoryConfiguration, connectionFactoryConfiguration.getBindings());
        }
        List<JMSQueueConfiguration> queueConfigs = this.config.getQueueConfigurations();
        for (JMSQueueConfiguration qConfig : queueConfigs) {
            this.createQueue(false, qConfig.getName(), qConfig.getSelector(), qConfig.isDurable(), qConfig.getBindings());
        }
        List<TopicConfiguration> list = this.config.getTopicConfigurations();
        for (TopicConfiguration tConfig : list) {
            this.createTopic(false, tConfig.getName(), tConfig.getBindings());
        }
    }

    private void unbindBindings(Map<String, List<String>> param) {
        if (this.registry != null) {
            for (List<String> elementList : param.values()) {
                for (String key : elementList) {
                    try {
                        this.registry.unbind(key);
                    }
                    catch (Exception e) {
                        ActiveMQJMSServerLogger.LOGGER.bindingsUnbindError(e, key);
                    }
                }
            }
        }
    }

    private void initJournal() throws Exception {
        this.coreConfig = this.server.getConfiguration();
        this.createJournal();
        this.storage.load();
        List<PersistedConnectionFactory> cfs = this.storage.recoverConnectionFactories();
        for (PersistedConnectionFactory cf : cfs) {
            this.internalCreateCF(true, cf.getConfig());
        }
        List<PersistedDestination> destinations = this.storage.recoverDestinations();
        for (PersistedDestination destination : destinations) {
            if (destination.getType() == PersistedType.Queue) {
                this.internalCreateQueue(destination.getName(), destination.getSelector(), destination.isDurable());
                continue;
            }
            if (destination.getType() != PersistedType.Topic) continue;
            this.internalCreateTopic(destination.getName());
        }
    }

    private void createJournal() throws Exception {
        if (this.storage == null) {
            this.storage = this.coreConfig.isPersistenceEnabled() ? new JMSJournalStorageManagerImpl((IDGenerator)new TimeAndCounterIDGenerator(), this.server.getConfiguration(), this.server.getReplicationManager()) : new NullJMSStorageManagerImpl();
        } else if (this.storage.isStarted()) {
            this.storage.stop();
        }
        this.storage.start();
    }

    private synchronized boolean removeFromBindings(Map<String, ?> keys, Map<String, List<String>> bindingsMap, String name) throws Exception {
        this.checkInitialised();
        List<String> registryBindings = bindingsMap.remove(name);
        if (registryBindings == null || registryBindings.size() == 0) {
            return false;
        }
        keys.remove(name);
        if (this.registry != null) {
            Iterator<String> iter = registryBindings.iterator();
            while (iter.hasNext()) {
                String registryBinding = iter.next();
                this.registry.unbind(registryBinding);
                iter.remove();
            }
        }
        return true;
    }

    private synchronized boolean removeFromBindings(Map<String, List<String>> bindingsMap, String name, String bindings) throws Exception {
        this.checkInitialised();
        List<String> registryBindings = bindingsMap.get(name);
        if (registryBindings == null || registryBindings.size() == 0) {
            return false;
        }
        if (registryBindings.remove(bindings)) {
            this.registry.unbind(bindings);
            return true;
        }
        return false;
    }

    private boolean runAfterActive(WrappedRunnable runnable) throws Exception {
        if (this.active) {
            runnable.runException();
            return true;
        }
        ActiveMQJMSServerLogger.LOGGER.serverCachingCommand(runnable);
        this.cachedCommands.add(runnable);
        return false;
    }

    private void correctInvalidNettyConnectorHost(TransportConfiguration transportConfiguration) {
        Map params = transportConfiguration.getParams();
        if (transportConfiguration.getFactoryClassName().equals(NettyConnectorFactory.class.getCanonicalName()) && params.containsKey("host") && params.get("host").equals("0.0.0.0")) {
            try {
                String newHost = InetAddress.getLocalHost().getHostName();
                ActiveMQJMSServerLogger.LOGGER.invalidHostForConnector(transportConfiguration.getName(), newHost);
                params.put("host", newHost);
            }
            catch (UnknownHostException e) {
                ActiveMQJMSServerLogger.LOGGER.failedToCorrectHost(e, transportConfiguration.getName());
            }
        }
    }

    class JMSQueueCreator
    implements QueueCreator {
        private final SimpleString PREFIX = SimpleString.toSimpleString((String)"jms.queue");

        JMSQueueCreator() {
        }

        public boolean create(SimpleString address) throws Exception {
            AddressSettings settings = (AddressSettings)JMSServerManagerImpl.this.server.getAddressSettingsRepository().getMatch(address.toString());
            if (address.startsWith(this.PREFIX) && settings.isAutoCreateJmsQueues()) {
                JMSServerManagerImpl.this.internalCreateJMSQueue(false, address.toString().substring(this.PREFIX.toString().length() + 1), null, true, true, new String[0]);
                return true;
            }
            return false;
        }
    }

    private abstract class WrappedRunnable
    implements Runnable {
        private WrappedRunnable() {
        }

        @Override
        public void run() {
            try {
                this.runException();
            }
            catch (Exception e) {
                ActiveMQJMSServerLogger.LOGGER.jmsServerError(e);
            }
        }

        public abstract void runException() throws Exception;
    }
}

