/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;

public class MQTTConnection
implements RemotingConnection {
    private final Connection transportConnection;
    private final long creationTime;
    private AtomicBoolean dataReceived;
    private boolean destroyed;
    private boolean connected;
    private String clientID;
    private final List<FailureListener> failureListeners = new CopyOnWriteArrayList<FailureListener>();
    private final List<CloseListener> closeListeners = new CopyOnWriteArrayList<CloseListener>();

    public MQTTConnection(Connection transportConnection) throws Exception {
        this.transportConnection = transportConnection;
        this.creationTime = System.currentTimeMillis();
        this.dataReceived = new AtomicBoolean();
        this.destroyed = false;
    }

    public void scheduledFlush() {
        this.flush();
    }

    public boolean isWritable(ReadyListener callback) {
        return this.transportConnection.isWritable(callback) && this.transportConnection.isOpen();
    }

    public Object getID() {
        return this.transportConnection.getID();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getRemoteAddress() {
        return this.transportConnection.getRemoteAddress();
    }

    public void addFailureListener(FailureListener listener) {
        this.failureListeners.add(listener);
    }

    public boolean removeFailureListener(FailureListener listener) {
        return this.failureListeners.remove(listener);
    }

    public void addCloseListener(CloseListener listener) {
        this.closeListeners.add(listener);
    }

    public boolean removeCloseListener(CloseListener listener) {
        return this.closeListeners.remove(listener);
    }

    public List<CloseListener> removeCloseListeners() {
        List<CloseListener> deletedCloseListeners = this.copyCloseListeners();
        this.closeListeners.clear();
        return deletedCloseListeners;
    }

    public void setCloseListeners(List<CloseListener> listeners) {
        this.closeListeners.clear();
        this.closeListeners.addAll(listeners);
    }

    public List<FailureListener> getFailureListeners() {
        return this.failureListeners;
    }

    public List<FailureListener> removeFailureListeners() {
        List<FailureListener> deletedFailureListeners = this.copyFailureListeners();
        this.failureListeners.clear();
        return deletedFailureListeners;
    }

    public void setFailureListeners(List<FailureListener> listeners) {
        this.failureListeners.clear();
        this.failureListeners.addAll(listeners);
    }

    public ActiveMQBuffer createTransportBuffer(int size) {
        return this.transportConnection.createTransportBuffer(size);
    }

    public void fail(ActiveMQException me) {
        List<FailureListener> copy = this.copyFailureListeners();
        for (FailureListener listener : copy) {
            listener.connectionFailed(me, false);
        }
    }

    private List<FailureListener> copyFailureListeners() {
        return new ArrayList<FailureListener>(this.failureListeners);
    }

    private List<CloseListener> copyCloseListeners() {
        return new ArrayList<CloseListener>(this.closeListeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fail(ActiveMQException me, String scaleDownTargetNodeID) {
        List<FailureListener> list = this.failureListeners;
        synchronized (list) {
            for (FailureListener listener : this.failureListeners) {
                listener.connectionFailed(me, false);
            }
        }
    }

    public Future asyncFail(ActiveMQException me) {
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            this.fail(me);
            return null;
        });
        Thread t = new Thread(task);
        t.start();
        return task;
    }

    public void destroy() {
        this.destroyed = true;
        this.disconnect(false);
    }

    public Connection getTransportConnection() {
        return this.transportConnection;
    }

    public boolean isClient() {
        return false;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void disconnect(boolean criticalError) {
        this.transportConnection.forceClose();
    }

    public void disconnect(String scaleDownNodeID, boolean criticalError) {
        this.transportConnection.forceClose();
    }

    protected void dataReceived() {
        this.dataReceived.set(true);
    }

    public boolean checkDataReceived() {
        return this.dataReceived.compareAndSet(true, false);
    }

    public void flush() {
        this.transportConnection.checkFlushBatchBuffer();
    }

    public void bufferReceived(Object connectionID, ActiveMQBuffer buffer) {
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public boolean getConnected() {
        return this.connected;
    }

    public void killMessage(SimpleString nodeID) {
    }

    public boolean isSupportReconnect() {
        return false;
    }

    public boolean isSupportsFlowControl() {
        return false;
    }

    public Subject getSubject() {
        return null;
    }

    public String getProtocolName() {
        return "MQTT";
    }

    public void setClientID(String cID) {
        this.clientID = cID;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getTransportLocalAddress() {
        return this.getTransportConnection().getLocalAddress();
    }
}

