/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.mqtt;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTInterceptor;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTProtocolManager;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTSessionState;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.AbstractProtocolManagerFactory;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManager;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.apache.activemq.artemis.utils.uri.BeanSupport;
import org.osgi.service.component.annotations.Component;

@Component(service={ProtocolManagerFactory.class})
public class MQTTProtocolManagerFactory
extends AbstractProtocolManagerFactory<MQTTInterceptor> {
    public static final String MQTT_PROTOCOL_NAME = "MQTT";
    private static final String MODULE_NAME = "artemis-mqtt-protocol";
    private static final String[] SUPPORTED_PROTOCOLS = new String[]{"MQTT"};
    private final Map<String, MQTTConnection> connectedClients = new ConcurrentHashMap<String, MQTTConnection>();
    private final Map<String, MQTTSessionState> sessionStates = new ConcurrentHashMap<String, MQTTSessionState>();

    public ProtocolManager createProtocolManager(ActiveMQServer server, Map<String, Object> parameters, List<BaseInterceptor> incomingInterceptors, List<BaseInterceptor> outgoingInterceptors) throws Exception {
        this.stripPasswordParameters(parameters);
        return (ProtocolManager)BeanSupport.setData((Object)((Object)new MQTTProtocolManager(server, this.connectedClients, this.sessionStates, incomingInterceptors, outgoingInterceptors)), parameters);
    }

    public List<MQTTInterceptor> filterInterceptors(List<BaseInterceptor> interceptors) {
        return this.internalFilterInterceptors(MQTTInterceptor.class, interceptors);
    }

    public String[] getProtocols() {
        return SUPPORTED_PROTOCOLS;
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

