/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.calcite.avatica.Meta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AvaticaStatement
implements Statement {
    public final AvaticaConnection connection;
    public final Meta.StatementHandle handle;
    protected boolean closed;
    protected boolean closeOnCompletion;
    protected AvaticaResultSet openResultSet;
    private int queryTimeoutMillis;
    final int resultSetType;
    final int resultSetConcurrency;
    final int resultSetHoldability;
    private int fetchSize;
    private int fetchDirection;
    protected int maxRowCount;

    protected AvaticaStatement(AvaticaConnection connection, Meta.StatementHandle h, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.connection = (AvaticaConnection)Preconditions.checkNotNull((Object)connection);
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
        this.closed = false;
        if (h == null) {
            Meta.ConnectionHandle ch = new Meta.ConnectionHandle(connection.id);
            h = connection.meta.createStatement(ch);
        }
        connection.statementMap.put(h.id, this);
        this.handle = h;
    }

    public int getId() {
        return this.handle.id;
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            int maxRowCount1 = this.maxRowCount <= 0 ? -1 : this.maxRowCount;
            Meta.Signature x = this.connection.meta.prepare(this.handle, sql, maxRowCount1);
            return this.executeInternal(x);
        }
        catch (RuntimeException e) {
            throw this.connection.helper.createException("while executing SQL: " + sql, e);
        }
    }

    public ResultSet executeQueryOld(String sql) throws SQLException {
        try {
            int maxRowCount1 = this.maxRowCount <= 0 ? -1 : this.maxRowCount;
            Meta.Signature x = this.connection.meta.prepare(this.handle, sql, maxRowCount1);
            return this.executeQueryInternal(x);
        }
        catch (RuntimeException e) {
            throw this.connection.helper.createException("error while executing SQL \"" + sql + "\": " + e.getMessage(), e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            int maxRowCount1 = this.maxRowCount <= 0 ? -1 : this.maxRowCount;
            return this.connection.prepareAndExecuteInternal(this, sql, maxRowCount1);
        }
        catch (RuntimeException e) {
            throw this.connection.helper.createException("error while executing SQL \"" + sql + "\": " + e.getMessage(), e);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        ResultSet resultSet = this.executeQuery(sql);
        if (resultSet.getMetaData().getColumnCount() != 1) {
            throw new SQLException("expected one result column");
        }
        if (!resultSet.next()) {
            throw new SQLException("expected one row, got zero");
        }
        int result = resultSet.getInt(1);
        if (resultSet.next()) {
            throw new SQLException("expected one row, got two or more");
        }
        resultSet.close();
        return result;
    }

    @Override
    public synchronized void close() throws SQLException {
        try {
            this.close_();
        }
        catch (RuntimeException e) {
            throw this.connection.helper.createException("While closing statement", e);
        }
    }

    protected void close_() {
        if (!this.closed) {
            this.closed = true;
            if (this.openResultSet != null) {
                AvaticaResultSet c = this.openResultSet;
                this.openResultSet = null;
                c.close();
            }
            this.connection.driver.handler.onStatementClose(this);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getMaxRows() {
        return this.maxRowCount;
    }

    @Override
    public void setMaxRows(int maxRowCount) throws SQLException {
        if (maxRowCount < 0) {
            throw this.connection.helper.createException("illegal maxRows value: " + maxRowCount);
        }
        this.maxRowCount = maxRowCount;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        long timeoutSeconds = this.getQueryTimeoutMillis() / 1000;
        if (timeoutSeconds > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (timeoutSeconds == 0L && this.getQueryTimeoutMillis() > 0) {
            return 1;
        }
        return (int)timeoutSeconds;
    }

    int getQueryTimeoutMillis() {
        return this.queryTimeoutMillis;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw this.connection.helper.createException("illegal timeout value " + seconds);
        }
        this.setQueryTimeoutMillis(seconds * 1000);
    }

    void setQueryTimeoutMillis(int millis) {
        this.queryTimeoutMillis = millis;
    }

    @Override
    public synchronized void cancel() throws SQLException {
        if (this.openResultSet != null) {
            this.openResultSet.cancel();
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.openResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() {
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public AvaticaConnection getConnection() {
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw this.connection.helper.createException("does not implement '" + iface + "'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    protected boolean executeInternal(Meta.Signature signature) throws SQLException {
        ResultSet resultSet = this.executeQueryInternal(signature);
        return true;
    }

    protected ResultSet executeQueryInternal(Meta.Signature signature) throws SQLException {
        return this.connection.executeQueryInternal(this, signature, null);
    }

    void onResultSetClose(ResultSet resultSet) {
        if (this.closeOnCompletion) {
            this.close_();
        }
    }

    protected List<Object> getParameterValues() {
        return Collections.emptyList();
    }
}

