/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.interpreter.AggregateNode;
import org.apache.calcite.interpreter.FilterNode;
import org.apache.calcite.interpreter.Interpreter;
import org.apache.calcite.interpreter.JoinNode;
import org.apache.calcite.interpreter.ProjectNode;
import org.apache.calcite.interpreter.SortNode;
import org.apache.calcite.interpreter.TableScanNode;
import org.apache.calcite.interpreter.UnionNode;
import org.apache.calcite.interpreter.ValuesNode;
import org.apache.calcite.interpreter.WindowNode;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.rules.FilterTableRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.mapping.Mappings;

public class Nodes {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilterScan
    extends TableScan {
        private final ImmutableList<RexNode> filters;
        private final ImmutableIntList projects;

        protected FilterScan(RelOptCluster cluster, RelTraitSet traits, RelOptTable table, ImmutableList<RexNode> filters, ImmutableIntList projects) {
            super(cluster, traits, table);
            this.filters = filters;
            this.projects = projects;
        }
    }

    public static class CoreCompiler
    extends Interpreter.Compiler {
        CoreCompiler(Interpreter interpreter) {
            super(interpreter);
        }

        public void rewrite(Project project) {
            TableScan scan;
            RelOptTable table;
            ProjectableFilterableTable projectableFilterableTable;
            RexNode condition;
            RelNode input = project.getInput();
            Mappings.TargetMapping mapping = project.getMapping();
            if (mapping == null) {
                return;
            }
            if (input instanceof Filter) {
                Filter filter = (Filter)input;
                condition = filter.getCondition();
                input = filter.getInput();
            } else {
                condition = project.getCluster().getRexBuilder().makeLiteral(true);
            }
            if (input instanceof TableScan && (projectableFilterableTable = (table = (scan = (TableScan)input).getTable()).unwrap(ProjectableFilterableTable.class)) != null) {
                FilterTableRule.FilterSplit filterSplit = FilterTableRule.FilterSplit.of(projectableFilterableTable, condition, this.interpreter.getDataContext());
                if (filterSplit.rejectedFilters.isEmpty()) {
                    this.rel = new FilterScan(project.getCluster(), project.getTraitSet(), table, filterSplit.acceptedFilters, ImmutableIntList.copyOf(Mappings.asList(mapping.inverse())));
                    this.rel = RelOptUtil.createFilter(this.rel, RexUtil.apply(mapping, filterSplit.rejectedFilters));
                }
            }
        }

        public void rewrite(Filter filter) {
            if (filter.getInput() instanceof TableScan) {
                FilterableTable filterableTable;
                TableScan scan = (TableScan)filter.getInput();
                RelOptTable table = scan.getTable();
                ProjectableFilterableTable projectableFilterableTable = table.unwrap(ProjectableFilterableTable.class);
                if (projectableFilterableTable != null) {
                    FilterTableRule.FilterSplit filterSplit = FilterTableRule.FilterSplit.of(projectableFilterableTable, filter.getCondition(), this.interpreter.getDataContext());
                    if (!filterSplit.acceptedFilters.isEmpty()) {
                        this.rel = new FilterScan(scan.getCluster(), scan.getTraitSet(), table, filterSplit.acceptedFilters, null);
                        this.rel = RelOptUtil.createFilter(this.rel, filterSplit.rejectedFilters);
                        return;
                    }
                }
                if ((filterableTable = table.unwrap(FilterableTable.class)) != null) {
                    FilterTableRule.FilterSplit filterSplit = FilterTableRule.FilterSplit.of(filterableTable, filter.getCondition(), this.interpreter.getDataContext());
                    if (!filterSplit.acceptedFilters.isEmpty()) {
                        this.rel = new FilterScan(scan.getCluster(), scan.getTraitSet(), table, filterSplit.acceptedFilters, null);
                        this.rel = RelOptUtil.createFilter(this.rel, filterSplit.rejectedFilters);
                    }
                }
            }
        }

        public void visit(Aggregate agg) {
            this.node = new AggregateNode(this.interpreter, agg);
        }

        public void visit(Filter filter) {
            this.node = new FilterNode(this.interpreter, filter);
        }

        public void visit(Project project) {
            this.node = new ProjectNode(this.interpreter, project);
        }

        public void rewrite(Calc calc) {
            Pair<ImmutableList<RexNode>, ImmutableList<RexNode>> projectFilter = calc.getProgram().split();
            this.rel = calc.getInput();
            this.rel = RelOptUtil.createFilter(this.rel, (Iterable)projectFilter.right);
            this.rel = RelOptUtil.createProject(this.rel, (List)projectFilter.left, calc.getRowType().getFieldNames());
        }

        public void visit(Values value) {
            this.node = new ValuesNode(this.interpreter, value);
        }

        public void visit(TableScan scan) {
            this.node = new TableScanNode(this.interpreter, scan, (ImmutableList<RexNode>)ImmutableList.of(), null);
        }

        public void visit(FilterScan scan) {
            this.node = new TableScanNode(this.interpreter, scan, (ImmutableList<RexNode>)scan.filters, scan.projects);
        }

        public void visit(Sort sort) {
            this.node = new SortNode(this.interpreter, sort);
        }

        public void visit(Union union) {
            this.node = new UnionNode(this.interpreter, union);
        }

        public void visit(Join join) {
            this.node = new JoinNode(this.interpreter, join);
        }

        public void visit(Window window) {
            this.node = new WindowNode(this.interpreter, window);
        }
    }
}

