/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.convert.ConverterImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractConverter
extends ConverterImpl {
    public AbstractConverter(RelOptCluster cluster, RelSubset rel, RelTraitDef traitDef, RelTraitSet traits) {
        super(cluster, traitDef, traits, rel);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new AbstractConverter(this.getCluster(), (RelSubset)AbstractConverter.sole(inputs), this.traitDef, traitSet);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return planner.getCostFactory().makeInfiniteCost();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw);
        for (RelTrait trait : this.traitSet) {
            pw.item(trait.getTraitDef().getSimpleName(), trait);
        }
        return pw;
    }

    public static class ExpandConversionRule
    extends RelOptRule {
        public static final ExpandConversionRule INSTANCE = new ExpandConversionRule();

        private ExpandConversionRule() {
            super(ExpandConversionRule.operand(AbstractConverter.class, ExpandConversionRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            AbstractConverter converter;
            RelNode child;
            VolcanoPlanner planner = (VolcanoPlanner)call.getPlanner();
            RelNode converted = planner.changeTraitsUsingConverters(child = (converter = (AbstractConverter)call.rel(0)).getInput(), converter.traitSet);
            if (converted != null) {
                call.transformTo(converted);
            }
        }
    }
}

