/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.runtime.Resources;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.IntList;
import org.apache.calcite.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Aggregate
extends SingleRel {
    public static final Predicate<Aggregate> IS_SIMPLE = new Predicate<Aggregate>(){

        public boolean apply(Aggregate input) {
            return input.getGroupType() == Group.SIMPLE;
        }
    };
    public final boolean indicator;
    protected final List<AggregateCall> aggCalls;
    protected final ImmutableBitSet groupSet;
    public final ImmutableList<ImmutableBitSet> groupSets;

    protected Aggregate(RelOptCluster cluster, RelTraitSet traits, RelNode child, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        super(cluster, traits, child);
        this.indicator = indicator;
        this.aggCalls = ImmutableList.copyOf(aggCalls);
        this.groupSet = (ImmutableBitSet)Preconditions.checkNotNull((Object)groupSet);
        if (groupSets == null) {
            this.groupSets = ImmutableList.of((Object)groupSet);
        } else {
            this.groupSets = ImmutableList.copyOf(groupSets);
            assert (ImmutableBitSet.ORDERING.isStrictlyOrdered(groupSets)) : groupSets;
            for (ImmutableBitSet set : groupSets) {
                assert (groupSet.contains(set));
            }
        }
        assert (groupSet.length() <= child.getRowType().getFieldCount());
        for (AggregateCall aggCall : aggCalls) {
            assert (this.typeMatchesInferred(aggCall, true));
        }
    }

    protected Aggregate(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), input.getBoolean("indicator", false), input.getBitSet("group"), input.getBitSetList("groups"), input.getAggregateCalls("aggs"));
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Aggregate.sole(inputs), this.indicator, this.groupSet, (List<ImmutableBitSet>)this.groupSets, this.aggCalls);
    }

    public abstract Aggregate copy(RelTraitSet var1, RelNode var2, boolean var3, ImmutableBitSet var4, List<ImmutableBitSet> var5, List<AggregateCall> var6);

    @Override
    public boolean isDistinct() {
        return true;
    }

    public List<AggregateCall> getAggCallList() {
        return this.aggCalls;
    }

    public int getGroupCount() {
        return this.groupSet.cardinality();
    }

    public int getIndicatorCount() {
        return this.indicator ? this.getGroupCount() : 0;
    }

    public ImmutableBitSet getGroupSet() {
        return this.groupSet;
    }

    public ImmutableList<ImmutableBitSet> getGroupSets() {
        return this.groupSets;
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        super.explainTerms(pw).item("group", this.groupSet).itemIf("groups", this.groupSets, this.getGroupType() != Group.SIMPLE).itemIf("indicator", this.indicator, this.indicator).itemIf("aggs", this.aggCalls, pw.nest());
        if (!pw.nest()) {
            for (Ord ord : Ord.zip(this.aggCalls)) {
                pw.item(Util.first(((AggregateCall)ord.e).name, "agg#" + ord.i), ord.e);
            }
        }
        return pw;
    }

    @Override
    public double getRows() {
        int groupCount = this.groupSet.cardinality();
        if (groupCount == 0) {
            return 1.0;
        }
        double rowCount = super.getRows();
        return rowCount *= 1.0 - Math.pow(0.5, groupCount);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double rowCount = RelMetadataQuery.getRowCount(this);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    @Override
    protected RelDataType deriveRowType() {
        return Aggregate.deriveRowType(this.getCluster().getTypeFactory(), this.getInput().getRowType(), this.indicator, this.groupSet, this.groupSets, this.aggCalls);
    }

    public static RelDataType deriveRowType(RelDataTypeFactory typeFactory, RelDataType inputRowType, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
        int groupKey;
        IntList groupList = groupSet.toList();
        assert (groupList.size() == groupSet.cardinality());
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        List<RelDataTypeField> fieldList = inputRowType.getFieldList();
        Iterator i$ = groupList.iterator();
        while (i$.hasNext()) {
            groupKey = (Integer)i$.next();
            builder.add(fieldList.get(groupKey));
        }
        if (indicator) {
            i$ = groupList.iterator();
            while (i$.hasNext()) {
                groupKey = (Integer)i$.next();
                RelDataType booleanType = typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BOOLEAN), false);
                builder.add("i$" + fieldList.get(groupKey).getName(), booleanType);
            }
        }
        for (Ord aggCall : Ord.zip(aggCalls)) {
            String name = ((AggregateCall)aggCall.e).name != null ? ((AggregateCall)aggCall.e).name : "$f" + (groupList.size() + aggCall.i);
            builder.add(name, ((AggregateCall)aggCall.e).type);
        }
        return builder.build();
    }

    private boolean typeMatchesInferred(AggregateCall aggCall, boolean fail) {
        SqlAggFunction aggFunction = aggCall.getAggregation();
        AggCallBinding callBinding = aggCall.createBinding(this);
        RelDataType type = aggFunction.inferReturnType(callBinding);
        RelDataType expectedType = aggCall.type;
        return RelOptUtil.eq("aggCall type", expectedType, "inferred type", type, fail);
    }

    public boolean containsDistinctCall() {
        for (AggregateCall call : this.aggCalls) {
            if (!call.isDistinct()) continue;
            return true;
        }
        return false;
    }

    public Group getGroupType() {
        return Group.induce(this.groupSet, this.groupSets);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AggCallBinding
    extends SqlOperatorBinding {
        private final List<RelDataType> operands;
        private final int groupCount;

        public AggCallBinding(RelDataTypeFactory typeFactory, SqlAggFunction aggFunction, List<RelDataType> operands, int groupCount) {
            super(typeFactory, aggFunction);
            this.operands = operands;
            this.groupCount = groupCount;
            assert (operands != null) : "operands of aggregate call should not be null";
            assert (groupCount >= 0) : "number of group by columns should be greater than zero in aggregate call. Got " + groupCount;
        }

        @Override
        public int getGroupCount() {
            return this.groupCount;
        }

        @Override
        public int getOperandCount() {
            return this.operands.size();
        }

        @Override
        public RelDataType getOperandType(int ordinal) {
            return this.operands.get(ordinal);
        }

        @Override
        public CalciteException newError(Resources.ExInst<SqlValidatorException> e) {
            return SqlUtil.newContextException(SqlParserPos.ZERO, e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Group
    extends Enum<Group> {
        public static final /* enum */ Group SIMPLE = new Group();
        public static final /* enum */ Group ROLLUP = new Group();
        public static final /* enum */ Group CUBE = new Group();
        public static final /* enum */ Group OTHER = new Group();
        private static final /* synthetic */ Group[] $VALUES;

        public static Group[] values() {
            return (Group[])$VALUES.clone();
        }

        public static Group valueOf(String name) {
            return Enum.valueOf(Group.class, name);
        }

        public static Group induce(ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets) {
            block7: {
                if (!ImmutableBitSet.ORDERING.isStrictlyOrdered(groupSets)) {
                    throw new IllegalArgumentException("must be sorted: " + groupSets);
                }
                if (groupSets.size() == 1 && groupSets.get(0).equals(groupSet)) {
                    return SIMPLE;
                }
                if (groupSets.size() == IntMath.pow((int)2, (int)groupSet.cardinality())) {
                    return CUBE;
                }
                if (groupSets.size() == groupSet.cardinality() + 1) {
                    ImmutableBitSet g = groupSet;
                    for (ImmutableBitSet bitSet : groupSets) {
                        if (bitSet.equals(g)) {
                            g = g.clear(g.length() - 1);
                            continue;
                        }
                        break block7;
                    }
                    assert (g.isEmpty());
                    return ROLLUP;
                }
            }
            return OTHER;
        }

        static {
            $VALUES = new Group[]{SIMPLE, ROLLUP, CUBE, OTHER};
        }
    }
}

