/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.core;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelInput;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.sql.SqlKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Union
extends SetOp {
    protected Union(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits, inputs, SqlKind.UNION, all);
    }

    protected Union(RelInput input) {
        super(input);
    }

    @Override
    public double getRows() {
        double dRows = Union.estimateRowCount(this);
        if (!this.all) {
            dRows *= 0.5;
        }
        return dRows;
    }

    public static double estimateRowCount(RelNode rel) {
        double dRows = 0.0;
        for (RelNode input : rel.getInputs()) {
            dRows += RelMetadataQuery.getRowCount(input).doubleValue();
        }
        return dRows;
    }
}

