/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.util.Static;

public class FilterTableRule
extends RelOptRule {
    private static final Predicate<TableScan> PREDICATE = new Predicate<TableScan>(){

        public boolean apply(TableScan scan) {
            RelOptTable table = scan.getTable();
            return table.unwrap(FilterableTable.class) != null || table.unwrap(ProjectableFilterableTable.class) != null;
        }
    };
    public static final FilterTableRule INSTANCE = new FilterTableRule();

    private FilterTableRule() {
        super(FilterTableRule.operand(Filter.class, FilterTableRule.operand(EnumerableInterpreter.class, FilterTableRule.operand(TableScan.class, null, PREDICATE, FilterTableRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]));
    }

    public void onMatch(RelOptRuleCall call) {
        FilterSplit filterSplit;
        Filter filter = (Filter)call.rel(0);
        EnumerableInterpreter interpreter = (EnumerableInterpreter)call.rel(1);
        TableScan scan = (TableScan)call.rel(2);
        FilterableTable filterableTable = scan.getTable().unwrap(FilterableTable.class);
        ProjectableFilterableTable projectableFilterableTable = scan.getTable().unwrap(ProjectableFilterableTable.class);
        if (filterableTable != null) {
            filterSplit = FilterSplit.of(filterableTable, filter.getCondition(), null);
        } else if (projectableFilterableTable != null) {
            filterSplit = FilterSplit.of(projectableFilterableTable, filter.getCondition(), null);
        } else {
            throw new AssertionError(scan.getTable());
        }
        RelNode newFilter = RelOptUtil.createFilter(interpreter.getInput(), filterSplit.acceptedFilters, EnumerableRel.FILTER_FACTORY);
        EnumerableInterpreter newInterpreter = new EnumerableInterpreter(interpreter.getCluster(), interpreter.getTraitSet(), newFilter, 0.15);
        RelNode residue = RelOptUtil.createFilter((RelNode)newInterpreter, filterSplit.rejectedFilters);
        call.transformTo(residue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilterSplit {
        public final ImmutableList<RexNode> acceptedFilters;
        public final ImmutableList<RexNode> rejectedFilters;

        public FilterSplit(ImmutableList<RexNode> acceptedFilters, ImmutableList<RexNode> rejectedFilters) {
            this.acceptedFilters = acceptedFilters;
            this.rejectedFilters = rejectedFilters;
        }

        public static FilterSplit of(FilterableTable table, RexNode condition, DataContext dataContext) {
            ArrayList filters = Lists.newArrayList();
            RelOptUtil.decomposeConjunction(condition, filters);
            ImmutableList originalFilters = ImmutableList.copyOf((Collection)filters);
            Enumerable<Object[]> enumerable = table.scan(dataContext, filters);
            return FilterSplit.rest((List<RexNode>)originalFilters, filters, enumerable);
        }

        public static FilterSplit of(ProjectableFilterableTable table, RexNode condition, DataContext dataContext) {
            ArrayList filters = Lists.newArrayList();
            RelOptUtil.decomposeConjunction(condition, filters);
            ImmutableList originalFilters = ImmutableList.copyOf((Collection)filters);
            Enumerable<Object[]> enumerable = table.scan(dataContext, filters, null);
            return FilterSplit.rest((List<RexNode>)originalFilters, filters, enumerable);
        }

        private static FilterSplit rest(List<RexNode> originalFilters, List<RexNode> filters, Enumerable<Object[]> enumerable) {
            if (enumerable == null) {
                throw Static.RESOURCE.filterableTableScanReturnedNull().ex();
            }
            ImmutableList.Builder accepted = ImmutableList.builder();
            ImmutableList.Builder rejected = ImmutableList.builder();
            for (RexNode originalFilter : originalFilters) {
                if (filters.contains(originalFilter)) {
                    rejected.add((Object)originalFilter);
                    continue;
                }
                accepted.add((Object)originalFilter);
            }
            for (RexNode node : filters) {
                if (originalFilters.contains(node)) continue;
                throw Static.RESOURCE.filterableTableInventedFilter(node.toString()).ex();
            }
            return new FilterSplit((ImmutableList<RexNode>)accepted.build(), (ImmutableList<RexNode>)rejected.build());
        }
    }
}

