/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.ReflectiveCallNotNullImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.schema.ImplementableFunction;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TableFunction;
import org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Static;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableFunctionImpl
extends ReflectiveFunctionBase
implements TableFunction,
ImplementableFunction {
    private final CallImplementor implementor;

    private TableFunctionImpl(Method method, CallImplementor implementor) {
        super(method);
        this.implementor = implementor;
    }

    public static TableFunction create(Class<?> clazz) {
        Method method = TableFunctionImpl.findMethod(clazz, "eval");
        if (method == null) {
            return null;
        }
        return TableFunctionImpl.create(method);
    }

    public static TableFunction create(Method method) {
        Class<?> clazz;
        if (!Modifier.isStatic(method.getModifiers()) && !TableFunctionImpl.classHasPublicZeroArgsConstructor(clazz = method.getDeclaringClass())) {
            throw Static.RESOURCE.requireDefaultConstructor(clazz.getName()).ex();
        }
        Class<?> returnType = method.getReturnType();
        if (!QueryableTable.class.isAssignableFrom(returnType)) {
            return null;
        }
        CallImplementor implementor = TableFunctionImpl.createImplementor(method);
        return new TableFunctionImpl(method, implementor);
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory, List<Object> arguments) {
        return this.apply(arguments).getRowType(typeFactory);
    }

    @Override
    public Type getElementType(List<Object> arguments) {
        return this.apply(arguments).getElementType();
    }

    @Override
    public CallImplementor getImplementor() {
        return this.implementor;
    }

    private static CallImplementor createImplementor(Method method) {
        return RexImpTable.createImplementor(new ReflectiveCallNotNullImplementor(method){

            @Override
            public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
                Expression expr = super.implement(translator, call, translatedOperands);
                MethodCallExpression queryable = Expressions.call((Expression)Expressions.convert_((Expression)expr, QueryableTable.class), (Method)BuiltInMethod.QUERYABLE_TABLE_AS_QUERYABLE.method, (Expression[])new Expression[]{Expressions.call((Expression)DataContext.ROOT, (Method)BuiltInMethod.DATA_CONTEXT_GET_QUERY_PROVIDER.method, (Expression[])new Expression[0]), Expressions.constant(null, SchemaPlus.class), Expressions.constant((Object)call.getOperator().getName(), String.class)});
                expr = Expressions.call((Expression)queryable, (Method)BuiltInMethod.QUERYABLE_AS_ENUMERABLE.method, (Expression[])new Expression[0]);
                return expr;
            }
        }, NullPolicy.ANY, false);
    }

    private QueryableTable apply(List<Object> arguments) {
        try {
            Object o = null;
            if (!Modifier.isStatic(this.method.getModifiers())) {
                o = this.method.getDeclaringClass().newInstance();
            }
            Object table = this.method.invoke(o, arguments.toArray());
            return (QueryableTable)table;
        }
        catch (IllegalArgumentException e) {
            throw (CalciteException)Static.RESOURCE.illegalArgumentForTableFunctionCall(this.method.toString(), Arrays.toString(this.method.getParameterTypes()), arguments.toString()).ex(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

