/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.Calendar;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlAbstractDateTimeLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;

public class SqlDateLiteral
extends SqlAbstractDateTimeLiteral {
    SqlDateLiteral(Calendar d, SqlParserPos pos) {
        super(d, false, SqlTypeName.DATE, 0, "yyyy-MM-dd", pos);
    }

    SqlDateLiteral(Calendar d, String format, SqlParserPos pos) {
        super(d, false, SqlTypeName.DATE, 0, format, pos);
    }

    public SqlNode clone(SqlParserPos pos) {
        return new SqlDateLiteral((Calendar)this.value, pos);
    }

    public String toString() {
        return "DATE '" + this.toFormattedString() + "'";
    }

    public String toFormattedString() {
        return this.getDate().toString(this.formatString);
    }

    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        return typeFactory.createSqlType(this.getTypeName());
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        switch (writer.getDialect().getDatabaseProduct()) {
            case MSSQL: {
                writer.literal("'" + this.toFormattedString() + "'");
                break;
            }
            default: {
                writer.literal(this.toString());
            }
        }
    }
}

