/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.fun;

import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.AggregatingSelectScope;
import org.apache.calcite.sql.validate.OrderByScope;
import org.apache.calcite.sql.validate.SelectScope;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.Static;

public class SqlAbstractGroupFunction
extends SqlFunction {
    public SqlAbstractGroupFunction(String name, SqlKind kind, SqlReturnTypeInference returnTypeInference, SqlOperandTypeInference operandTypeInference, SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        super(name, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category);
    }

    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        SelectScope selectScope = SqlValidatorUtil.getEnclosingSelectScope(scope);
        SqlSelect select = selectScope.getNode();
        if (!validator.isAggregate(select)) {
            throw validator.newValidationError(call, Static.RESOURCE.groupingInAggregate(this.getName()));
        }
        AggregatingSelectScope aggregatingSelectScope = SqlValidatorUtil.getEnclosingAggregateSelectScope(scope);
        if (aggregatingSelectScope == null) {
            throw validator.newValidationError(call, Static.RESOURCE.groupingInWrongClause(this.getName()));
        }
        for (SqlNode operand : call.getOperandList()) {
            operand = scope instanceof OrderByScope ? validator.expandOrderExpr(select, operand) : validator.expand(operand, scope);
            if (aggregatingSelectScope.isGroupingExpr(operand)) continue;
            throw validator.newValidationError(operand, Static.RESOURCE.groupingArgument(this.getName()));
        }
    }
}

