/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.utils.CollectionUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractServiceConfig;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.ProtocolConfig;
import org.apache.dubbo.config.ProviderConfig;
import org.apache.dubbo.config.annotation.Service;
import org.apache.dubbo.config.support.Parameter;
import org.apache.dubbo.rpc.model.ApplicationModel;
import org.apache.dubbo.rpc.model.ServiceMetadata;
import org.apache.dubbo.rpc.service.GenericService;
import org.apache.dubbo.rpc.support.ProtocolUtils;

public abstract class ServiceConfigBase<T>
extends AbstractServiceConfig {
    private static final long serialVersionUID = 3033787999037024738L;
    protected String interfaceName;
    protected Class<?> interfaceClass;
    protected T ref;
    protected String path;
    protected ProviderConfig provider;
    protected String providerIds;
    protected volatile String generic;
    protected ServiceMetadata serviceMetadata = new ServiceMetadata();

    public ServiceConfigBase() {
        this.serviceMetadata.addAttribute("ORIGIN_CONFIG", this);
    }

    public ServiceConfigBase(Service service) {
        this.serviceMetadata.addAttribute("ORIGIN_CONFIG", this);
        this.appendAnnotation(Service.class, service);
        this.setMethods(MethodConfig.constructMethodConfig(service.methods()));
    }

    public void exported() {
    }

    @Deprecated
    private static List<ProtocolConfig> convertProviderToProtocol(List<ProviderConfig> providers) {
        if (CollectionUtils.isEmpty(providers)) {
            return null;
        }
        ArrayList<ProtocolConfig> protocols = new ArrayList<ProtocolConfig>(providers.size());
        for (ProviderConfig provider : providers) {
            protocols.add(ServiceConfigBase.convertProviderToProtocol(provider));
        }
        return protocols;
    }

    @Deprecated
    private static List<ProviderConfig> convertProtocolToProvider(List<ProtocolConfig> protocols) {
        if (CollectionUtils.isEmpty(protocols)) {
            return null;
        }
        ArrayList<ProviderConfig> providers = new ArrayList<ProviderConfig>(protocols.size());
        for (ProtocolConfig provider : protocols) {
            providers.add(ServiceConfigBase.convertProtocolToProvider(provider));
        }
        return providers;
    }

    @Deprecated
    private static ProtocolConfig convertProviderToProtocol(ProviderConfig provider) {
        ProtocolConfig protocol = new ProtocolConfig();
        protocol.setName(provider.getProtocol().getName());
        protocol.setServer(provider.getServer());
        protocol.setClient(provider.getClient());
        protocol.setCodec(provider.getCodec());
        protocol.setHost(provider.getHost());
        protocol.setPort(provider.getPort());
        protocol.setPath(provider.getPath());
        protocol.setPayload(provider.getPayload());
        protocol.setThreads(provider.getThreads());
        protocol.setParameters(provider.getParameters());
        return protocol;
    }

    @Deprecated
    private static ProviderConfig convertProtocolToProvider(ProtocolConfig protocol) {
        ProviderConfig provider = new ProviderConfig();
        provider.setProtocol(protocol);
        provider.setServer(protocol.getServer());
        provider.setClient(protocol.getClient());
        provider.setCodec(protocol.getCodec());
        provider.setHost(protocol.getHost());
        provider.setPort(protocol.getPort());
        provider.setPath(protocol.getPath());
        provider.setPayload(protocol.getPayload());
        provider.setThreads(protocol.getThreads());
        provider.setParameters(protocol.getParameters());
        return provider;
    }

    public boolean shouldExport() {
        Boolean export = this.getExport();
        return export == null ? true : export;
    }

    @Override
    public Boolean getExport() {
        return this.export == null && this.provider != null ? this.provider.getExport() : this.export;
    }

    public boolean shouldDelay() {
        Integer delay = this.getDelay();
        return delay != null && delay > 0;
    }

    @Override
    public Integer getDelay() {
        return this.delay == null && this.provider != null ? this.provider.getDelay() : this.delay;
    }

    public void checkRef() {
        if (this.ref == null) {
            throw new IllegalStateException("ref not allow null!");
        }
        if (!this.interfaceClass.isInstance(this.ref)) {
            throw new IllegalStateException("The class " + this.ref.getClass().getName() + " unimplemented interface " + this.interfaceClass + "!");
        }
    }

    public Optional<String> getContextPath(ProtocolConfig protocolConfig) {
        String contextPath = protocolConfig.getContextpath();
        if (StringUtils.isEmpty(contextPath) && this.provider != null) {
            contextPath = this.provider.getContextpath();
        }
        return Optional.ofNullable(contextPath);
    }

    protected Class getServiceClass(T ref) {
        return ref.getClass();
    }

    public void completeCompoundConfigs() {
        if (this.provider != null) {
            if (this.application == null) {
                this.setApplication(this.provider.getApplication());
            }
            if (this.module == null) {
                this.setModule(this.provider.getModule());
            }
            if (this.registries == null) {
                this.setRegistries(this.provider.getRegistries());
            }
            if (this.monitor == null) {
                this.setMonitor(this.provider.getMonitor());
            }
            if (this.protocols == null) {
                this.setProtocols(this.provider.getProtocols());
            }
            if (this.configCenter == null) {
                this.setConfigCenter(this.provider.getConfigCenter());
            }
            if (StringUtils.isEmpty(this.registryIds)) {
                this.setRegistryIds(this.provider.getRegistryIds());
            }
            if (StringUtils.isEmpty(this.protocolIds)) {
                this.setProtocolIds(this.provider.getProtocolIds());
            }
        }
        if (this.module != null) {
            if (this.registries == null) {
                this.setRegistries(this.module.getRegistries());
            }
            if (this.monitor == null) {
                this.setMonitor(this.module.getMonitor());
            }
        }
        if (this.application != null) {
            if (this.registries == null) {
                this.setRegistries(this.application.getRegistries());
            }
            if (this.monitor == null) {
                this.setMonitor(this.application.getMonitor());
            }
        }
    }

    public void checkDefault() {
        this.createProviderIfAbsent();
    }

    private void createProviderIfAbsent() {
        if (this.provider != null) {
            return;
        }
        this.setProvider(ApplicationModel.getConfigManager().getDefaultProvider().orElseGet(() -> {
            ProviderConfig providerConfig = new ProviderConfig();
            providerConfig.refresh();
            return providerConfig;
        }));
    }

    public void checkProtocol() {
        if (CollectionUtils.isEmpty(this.protocols) && this.provider != null) {
            this.setProtocols(this.provider.getProtocols());
        }
        this.convertProtocolIdsToProtocols();
    }

    private void convertProtocolIdsToProtocols() {
        this.computeValidProtocolIds();
        if (StringUtils.isEmpty(this.protocolIds)) {
            if (CollectionUtils.isEmpty(this.protocols)) {
                List<ProtocolConfig> protocolConfigs = ApplicationModel.getConfigManager().getDefaultProtocols();
                if (protocolConfigs.isEmpty()) {
                    protocolConfigs = new ArrayList<ProtocolConfig>(1);
                    ProtocolConfig protocolConfig = new ProtocolConfig();
                    protocolConfig.setDefault(true);
                    protocolConfig.refresh();
                    protocolConfigs.add(protocolConfig);
                    ApplicationModel.getConfigManager().addProtocol(protocolConfig);
                }
                this.setProtocols(protocolConfigs);
            }
        } else {
            String[] arr = CommonConstants.COMMA_SPLIT_PATTERN.split(this.protocolIds);
            List tmpProtocols = CollectionUtils.isNotEmpty(this.protocols) ? this.protocols : new ArrayList();
            Arrays.stream(arr).forEach(id -> {
                if (tmpProtocols.stream().noneMatch(prot -> prot.getId().equals(id))) {
                    Optional<ProtocolConfig> globalProtocol = ApplicationModel.getConfigManager().getProtocol((String)id);
                    if (globalProtocol.isPresent()) {
                        tmpProtocols.add(globalProtocol.get());
                    } else {
                        ProtocolConfig protocolConfig = new ProtocolConfig();
                        protocolConfig.setId((String)id);
                        protocolConfig.refresh();
                        tmpProtocols.add(protocolConfig);
                    }
                }
            });
            if (tmpProtocols.size() > arr.length) {
                throw new IllegalStateException("Too much protocols found, the protocols comply to this service are :" + this.protocolIds + " but got " + this.protocols.size() + " registries!");
            }
            this.setProtocols(tmpProtocols);
        }
    }

    public Class<?> getInterfaceClass() {
        if (this.interfaceClass != null) {
            return this.interfaceClass;
        }
        if (this.ref instanceof GenericService) {
            return GenericService.class;
        }
        try {
            if (this.interfaceName != null && this.interfaceName.length() > 0) {
                this.interfaceClass = Class.forName(this.interfaceName, true, Thread.currentThread().getContextClassLoader());
            }
        }
        catch (ClassNotFoundException t) {
            throw new IllegalStateException(t.getMessage(), t);
        }
        return this.interfaceClass;
    }

    public void setInterfaceClass(Class<?> interfaceClass) {
        this.setInterface(interfaceClass);
    }

    public String getInterface() {
        return this.interfaceName;
    }

    public void setInterface(Class<?> interfaceClass) {
        if (interfaceClass != null && !interfaceClass.isInterface()) {
            throw new IllegalStateException("The interface class " + interfaceClass + " is not a interface!");
        }
        this.interfaceClass = interfaceClass;
        this.setInterface(interfaceClass == null ? null : interfaceClass.getName());
    }

    public void setInterface(String interfaceName) {
        this.interfaceName = interfaceName;
        if (StringUtils.isEmpty(this.id)) {
            this.id = interfaceName;
        }
    }

    public T getRef() {
        return this.ref;
    }

    public void setRef(T ref) {
        this.ref = ref;
    }

    @Parameter(excluded=true)
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ProviderConfig getProvider() {
        return this.provider;
    }

    public void setProvider(ProviderConfig provider) {
        ApplicationModel.getConfigManager().addProvider(provider);
        this.provider = provider;
    }

    @Parameter(excluded=true)
    public String getProviderIds() {
        return this.providerIds;
    }

    public void setProviderIds(String providerIds) {
        this.providerIds = providerIds;
    }

    public String getGeneric() {
        return this.generic;
    }

    public void setGeneric(String generic) {
        if (StringUtils.isEmpty(generic)) {
            return;
        }
        if (!ProtocolUtils.isValidGenericValue(generic)) {
            throw new IllegalArgumentException("Unsupported generic type " + generic);
        }
        this.generic = generic;
    }

    @Override
    public void setMock(Boolean mock) {
        throw new IllegalArgumentException("mock doesn't support on provider side");
    }

    @Override
    public void setMock(String mock) {
        throw new IllegalArgumentException("mock doesn't support on provider side");
    }

    public ServiceMetadata getServiceMetadata() {
        return this.serviceMetadata;
    }

    @Deprecated
    public List<ProviderConfig> getProviders() {
        return ServiceConfigBase.convertProtocolToProvider(this.protocols);
    }

    @Deprecated
    public void setProviders(List<ProviderConfig> providers) {
        this.protocols = ServiceConfigBase.convertProviderToProtocol(providers);
    }

    @Override
    @Parameter(excluded=true)
    public String getPrefix() {
        return "dubbo.service." + this.interfaceName;
    }

    @Parameter(excluded=true)
    public String getUniqueServiceName() {
        return URL.buildKey(this.interfaceName, this.group, this.version);
    }

    private void computeValidProtocolIds() {
        if (StringUtils.isEmpty(this.getProtocolIds()) && this.getProvider() != null && StringUtils.isNotEmpty(this.getProvider().getProtocolIds())) {
            this.setProtocolIds(this.getProvider().getProtocolIds());
        }
    }

    @Override
    protected void computeValidRegistryIds() {
        super.computeValidRegistryIds();
        if (StringUtils.isEmpty(this.getRegistryIds()) && this.getProvider() != null && StringUtils.isNotEmpty(this.getProvider().getRegistryIds())) {
            this.setRegistryIds(this.getProvider().getRegistryIds());
        }
    }

    public abstract void export();

    public abstract void unexport();

    public abstract boolean isExported();

    public abstract boolean isUnexported();
}

