/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.spring.boot.autoconfigure;

import org.apache.dubbo.config.spring.context.properties.DubboConfigBinder;
import org.apache.dubbo.spring.boot.autoconfigure.RelaxedDubboConfigBinder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

@ConditionalOnProperty(prefix="dubbo", name={"enabled"}, matchIfMissing=true)
@ConditionalOnClass(name={"org.springframework.boot.bind.RelaxedPropertyResolver"})
@Configuration
public class DubboRelaxedBindingAutoConfiguration {
    @Bean(name={"dubboScanBasePackagesPropertyResolver"})
    public PropertyResolver dubboScanBasePackagesPropertyResolver(Environment environment) {
        return new RelaxedPropertyResolver((PropertyResolver)environment, "dubbo.scan.");
    }

    @ConditionalOnMissingBean(name={"relaxedDubboConfigBinder"}, value={DubboConfigBinder.class})
    @Bean(value={"relaxedDubboConfigBinder"})
    @Scope(scopeName="prototype")
    public DubboConfigBinder relaxedDubboConfigBinder() {
        return new RelaxedDubboConfigBinder();
    }
}

