/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.channels.AsynchronousCloseException;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.net.PeerServer;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataXceiver;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.Daemon;

class DataXceiverServer
implements Runnable {
    public static final Log LOG = DataNode.LOG;
    private final PeerServer peerServer;
    private final DataNode datanode;
    private final HashMap<Peer, Thread> peers = new HashMap();
    private final HashMap<Peer, DataXceiver> peersXceiver = new HashMap();
    private boolean closed = false;
    int maxXceiverCount = 4096;
    final BlockBalanceThrottler balanceThrottler;
    final long estimateBlockSize;

    DataXceiverServer(PeerServer peerServer, Configuration conf, DataNode datanode) {
        this.peerServer = peerServer;
        this.datanode = datanode;
        this.maxXceiverCount = conf.getInt("dfs.datanode.max.transfer.threads", 4096);
        this.estimateBlockSize = conf.getLongBytes("dfs.blocksize", 0x8000000L);
        this.balanceThrottler = new BlockBalanceThrottler(conf.getLong("dfs.datanode.balance.bandwidthPerSec", 0x100000L), conf.getInt("dfs.datanode.balance.max.concurrent.moves", 5));
    }

    @Override
    public void run() {
        Peer peer = null;
        while (this.datanode.shouldRun && !this.datanode.shutdownForUpgrade) {
            try {
                peer = this.peerServer.accept();
                int curXceiverCount = this.datanode.getXceiverCount();
                if (curXceiverCount > this.maxXceiverCount) {
                    throw new IOException("Xceiver count " + curXceiverCount + " exceeds the limit of concurrent xcievers: " + this.maxXceiverCount);
                }
                new Daemon(this.datanode.threadGroup, (Runnable)DataXceiver.create(peer, this.datanode, this)).start();
            }
            catch (SocketTimeoutException curXceiverCount) {
            }
            catch (AsynchronousCloseException ace) {
                if (!this.datanode.shouldRun || this.datanode.shutdownForUpgrade) continue;
                LOG.warn((Object)(this.datanode.getDisplayName() + ":DataXceiverServer: "), (Throwable)ace);
            }
            catch (IOException ie) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{peer});
                LOG.warn((Object)(this.datanode.getDisplayName() + ":DataXceiverServer: "), (Throwable)ie);
            }
            catch (OutOfMemoryError ie) {
                IOUtils.cleanup(null, (Closeable[])new Closeable[]{peer});
                LOG.error((Object)"DataNode is out of memory. Will retry in 30 seconds.", (Throwable)ie);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Throwable te) {
                LOG.error((Object)(this.datanode.getDisplayName() + ":DataXceiverServer: Exiting due to: "), te);
                this.datanode.shouldRun = false;
            }
        }
        try {
            this.peerServer.close();
            this.closed = true;
        }
        catch (IOException ie) {
            LOG.warn((Object)(this.datanode.getDisplayName() + " :DataXceiverServer: close exception"), (Throwable)ie);
        }
        if (this.datanode.shutdownForUpgrade) {
            this.restartNotifyPeers();
            LOG.info((Object)"Shutting down DataXceiverServer before restart");
            for (int i = 0; this.getNumPeers() > 0 && i < 10; ++i) {
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.closeAllPeers();
    }

    void kill() {
        assert (!this.datanode.shouldRun || this.datanode.shutdownForUpgrade) : "shoudRun should be set to false or restarting should be true before killing";
        try {
            this.peerServer.close();
            this.closed = true;
        }
        catch (IOException ie) {
            LOG.warn((Object)(this.datanode.getDisplayName() + ":DataXceiverServer.kill(): "), (Throwable)ie);
        }
    }

    synchronized void addPeer(Peer peer, Thread t, DataXceiver xceiver) throws IOException {
        if (this.closed) {
            throw new IOException("Server closed.");
        }
        this.peers.put(peer, t);
        this.peersXceiver.put(peer, xceiver);
    }

    synchronized void closePeer(Peer peer) {
        this.peers.remove(peer);
        this.peersXceiver.remove(peer);
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{peer});
    }

    public synchronized void sendOOBToPeers() {
        if (!this.datanode.shutdownForUpgrade) {
            return;
        }
        for (Peer p : this.peers.keySet()) {
            try {
                this.peersXceiver.get(p).sendOOB();
            }
            catch (IOException e) {
                LOG.warn((Object)"Got error when sending OOB message.", (Throwable)e);
            }
            catch (InterruptedException e) {
                LOG.warn((Object)"Interrupted when sending OOB message.");
            }
        }
    }

    synchronized void restartNotifyPeers() {
        assert (this.datanode.shouldRun && this.datanode.shutdownForUpgrade);
        for (Thread t : this.peers.values()) {
            t.interrupt();
        }
    }

    synchronized void closeAllPeers() {
        LOG.info((Object)"Closing all peers.");
        for (Peer p : this.peers.keySet()) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{p});
        }
        this.peers.clear();
        this.peersXceiver.clear();
    }

    synchronized int getNumPeers() {
        return this.peers.size();
    }

    @VisibleForTesting
    synchronized int getNumPeersXceiver() {
        return this.peersXceiver.size();
    }

    @VisibleForTesting
    PeerServer getPeerServer() {
        return this.peerServer;
    }

    synchronized void releasePeer(Peer peer) {
        this.peers.remove(peer);
        this.peersXceiver.remove(peer);
    }

    static class BlockBalanceThrottler
    extends DataTransferThrottler {
        private int numThreads;
        private int maxThreads;

        private BlockBalanceThrottler(long bandwidth, int maxThreads) {
            super(bandwidth);
            this.maxThreads = maxThreads;
            LOG.info((Object)("Balancing bandwith is " + bandwidth + " bytes/s"));
            LOG.info((Object)("Number threads for balancing is " + maxThreads));
        }

        synchronized boolean acquire() {
            if (this.numThreads >= this.maxThreads) {
                return false;
            }
            ++this.numThreads;
            return true;
        }

        synchronized void release() {
            --this.numThreads;
        }
    }
}

