/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.header;

import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.AdditionalLinksPanel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.EntityActionLinkFactory;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.EntityActionUtil;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.model.IModel;

public class EntityHeaderPanel
extends PanelAbstract<EntityModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_ACTIONS = "entityActions";
    private final EntityActionLinkFactory linkFactory = new EntityActionLinkFactory(this.getEntityModel());

    public EntityHeaderPanel(String id, EntityModel entityModel) {
        super(id, entityModel);
    }

    public EntityModel getEntityModel() {
        return (EntityModel)this.getModel();
    }

    protected void onBeforeRender() {
        this.buildGui();
        super.onBeforeRender();
    }

    private void buildGui() {
        this.addOrReplaceIconAndTitle();
        this.buildEntityActionsGui();
    }

    private void addOrReplaceIconAndTitle() {
        ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_TITLE_AND_COPYLINK, (IModel<?>)this.getEntityModel());
        Component component = componentFactory.createComponent((IModel<?>)this.getEntityModel());
        this.addOrReplace(new Component[]{component});
    }

    private void buildEntityActionsGui() {
        EntityModel model = (EntityModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)model.getObject();
        ObjectAdapterMemento adapterMemento = model.getObjectAdapterMemento();
        if (adapter != null) {
            List<ObjectAction> topLevelActions = EntityActionUtil.getTopLevelActions(adapter, this.getDeploymentType(), this.getAuthenticationSession());
            List<LinkAndLabel> entityActionLinks = EntityActionUtil.asLinkAndLabelsForAdditionalLinksPanel(model, topLevelActions);
            AdditionalLinksPanel.addAdditionalLinks((MarkupContainer)this, ID_ENTITY_ACTIONS, entityActionLinks, AdditionalLinksPanel.Style.INLINE_LIST);
        } else {
            this.permanentlyHide(ID_ENTITY_ACTIONS);
        }
    }

    protected DeploymentType getDeploymentType() {
        return IsisContext.getDeploymentType();
    }
}

