/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.entity.icontitle;

import com.google.inject.Inject;
import java.io.Serializable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFacet;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ImageResourceCache;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistryAccessor;
import org.apache.isis.viewer.wicket.ui.panels.PanelAbstract;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.isis.viewer.wicket.ui.util.Links;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ResourceReference;

public class EntityIconAndTitlePanel
extends PanelAbstract<EntityModel> {
    private static final long serialVersionUID = 1L;
    private static final String ID_ENTITY_LINK_WRAPPER = "entityLinkWrapper";
    private static final String ID_ENTITY_FONT_AWESOME = "entityFontAwesome";
    private static final String ID_ENTITY_LINK = "entityLink";
    private static final String ID_ENTITY_TITLE = "entityTitle";
    private static final String ID_ENTITY_ICON = "entityImage";
    private Label label;
    private Image image;
    @Inject
    private ImageResourceCache imageCache;
    @Inject
    private WicketViewerSettings settings;

    public EntityIconAndTitlePanel(String id, EntityModel entityModel) {
        super(id, entityModel);
    }

    public EntityModel getEntityModel() {
        return (EntityModel)this.getModel();
    }

    protected void onBeforeRender() {
        this.buildGui();
        super.onBeforeRender();
    }

    private void buildGui() {
        this.addOrReplaceLinkWrapper();
        this.setOutputMarkupId(true);
    }

    private void addOrReplaceLinkWrapper() {
        EntityModel entityModel = (EntityModel)this.getModel();
        WebMarkupContainer entityLinkWrapper = this.addOrReplaceLinkWrapper(entityModel);
        this.addOrReplace(new Component[]{entityLinkWrapper});
    }

    protected WebMarkupContainer addOrReplaceLinkWrapper(EntityModel entityModel) {
        ObjectAdapter adapter = (ObjectAdapter)entityModel.getObject();
        WebMarkupContainer entityLinkWrapper = new WebMarkupContainer(ID_ENTITY_LINK_WRAPPER);
        AbstractLink link = this.createIconAndTitle(adapter);
        entityLinkWrapper.addOrReplace(new Component[]{link});
        return entityLinkWrapper;
    }

    private AbstractLink createIconAndTitle(ObjectAdapter adapter) {
        AbstractLink link = this.createLinkWrapper();
        String title = this.determineTitle();
        String iconName = adapter.getIconName();
        CssClassFaFacet cssClassFaFacet = (CssClassFaFacet)adapter.getSpecification().getFacet(CssClassFaFacet.class);
        if (iconName != null || cssClassFaFacet == null) {
            Component[] componentArray = new Component[1];
            this.image = this.newImage(ID_ENTITY_ICON, adapter);
            componentArray[0] = this.image;
            link.addOrReplace(componentArray);
            Components.permanentlyHide((MarkupContainer)link, ID_ENTITY_FONT_AWESOME);
        } else {
            Label dummy = new Label(ID_ENTITY_FONT_AWESOME, "");
            link.addOrReplace(new Component[]{dummy});
            dummy.add(new Behavior[]{new CssClassAppender(cssClassFaFacet.value() + " fa-2x")});
            Components.permanentlyHide((MarkupContainer)link, ID_ENTITY_ICON);
        }
        Component[] componentArray = new Component[1];
        this.label = this.newLabel(ID_ENTITY_TITLE, this.titleAbbreviated(title));
        componentArray[0] = this.label;
        link.addOrReplace(componentArray);
        String entityTypeName = adapter.getSpecification().getSingularName();
        link.add(new Behavior[]{new AttributeModifier("title", (Serializable)((Object)(entityTypeName + ": " + title)))});
        return link;
    }

    private AbstractLink createLinkWrapper() {
        PageParameters pageParameters = ((EntityModel)this.getModel()).getPageParametersWithoutUiHints();
        Class<? extends Page> pageClass = this.getPageClassRegistry().getPageClass(PageType.ENTITY);
        return Links.newBookmarkablePageLink(ID_ENTITY_LINK, pageParameters, pageClass);
    }

    private Label newLabel(String id, String title) {
        return new Label(id, title);
    }

    private String titleAbbreviated(String titleString) {
        int maxTitleLength = this.abbreviateTo((EntityModel)this.getModel(), titleString);
        return EntityIconAndTitlePanel.abbreviated(titleString, maxTitleLength);
    }

    private String determineTitle() {
        EntityModel model = (EntityModel)this.getModel();
        ObjectAdapter adapter = (ObjectAdapter)model.getObject();
        return adapter != null ? adapter.titleString(this.getContextAdapterIfAny()) : "(no object)";
    }

    private int abbreviateTo(EntityModel model, String titleString) {
        if (model.getRenderingHint().isInStandaloneTableTitleColumn()) {
            return this.getSettings().getMaxTitleLengthInStandaloneTables();
        }
        if (model.getRenderingHint().isInParentedTableTitleColumn()) {
            return this.getSettings().getMaxTitleLengthInParentedTables();
        }
        return titleString.length();
    }

    protected Image newImage(String id, ObjectAdapter adapter) {
        ResourceReference imageResource = this.imageCache.resourceReferenceFor(adapter);
        Image image = new Image(id, imageResource){
            private static final long serialVersionUID = 1L;

            protected boolean shouldAddAntiCacheParameter() {
                return false;
            }
        };
        return image;
    }

    public ObjectAdapter getContextAdapterIfAny() {
        EntityModel model = (EntityModel)this.getModel();
        ObjectAdapterMemento contextAdapterMementoIfAny = model.getContextAdapterIfAny();
        return contextAdapterMementoIfAny != null ? contextAdapterMementoIfAny.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK) : null;
    }

    static String abbreviated(String str, int maxLength) {
        int length = str.length();
        if (length <= maxLength) {
            return str;
        }
        return maxLength <= 3 ? "" : str.substring(0, maxLength - 3) + "...";
    }

    protected PageClassRegistry getPageClassRegistry() {
        PageClassRegistryAccessor pcra = (PageClassRegistryAccessor)this.getApplication();
        return pcra.getPageClassRegistry();
    }

    protected ImageResourceCache getImageCache() {
        return this.imageCache;
    }

    protected WicketViewerSettings getSettings() {
        return this.settings;
    }
}

