/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facets.SingleIntValueFacet;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.EntityActionUtil;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.TextFieldValueModel;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public abstract class ScalarPanelTextFieldAbstract<T extends Serializable>
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_SCALAR_TYPE_CONTAINER = "scalarTypeContainer";
    protected final Class<T> cls;
    protected WebMarkupContainer scalarTypeContainer;
    private AbstractTextComponent<T> textField;

    public ScalarPanelTextFieldAbstract(String id, ScalarModel scalarModel, Class<T> cls) {
        super(id, scalarModel);
        this.cls = cls;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.scalarTypeContainer = new WebMarkupContainer(ID_SCALAR_TYPE_CONTAINER);
        this.scalarTypeContainer.add(new Behavior[]{new CssClassAppender(this.getScalarPanelType())});
        this.addOrReplace(new Component[]{this.scalarTypeContainer});
    }

    protected AbstractTextComponent<T> getTextField() {
        return this.textField;
    }

    protected AbstractTextComponent<T> createTextFieldForRegular() {
        return this.createTextField("scalarValue");
    }

    protected TextField<T> createTextField(String id) {
        return new TextField(id, this.newTextFieldValueModel(), this.cls);
    }

    protected TextFieldValueModel<T> newTextFieldValueModel() {
        return new TextFieldValueModel(this);
    }

    @Override
    protected MarkupContainer addComponentForRegular() {
        String label;
        this.textField = this.createTextFieldForRegular();
        this.textField.setOutputMarkupId(true);
        this.addStandardSemantics();
        this.addSemantics();
        MarkupContainer labelIfRegular = this.createFormComponentLabel();
        this.scalarTypeContainer.add(new Component[]{labelIfRegular});
        Label scalarName = new Label("scalarName", this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.textField));
        NamedFacet namedFacet = (NamedFacet)((ScalarModel)this.getModel()).getFacet(NamedFacet.class);
        if (namedFacet != null) {
            scalarName.setEscapeModelStrings(namedFacet.escaped());
        }
        List<LinkAndLabel> entityActions = EntityActionUtil.getEntityActionLinksForAssociation(this.scalarModel, this.getDeploymentType());
        this.addPositioningCssTo(labelIfRegular, entityActions);
        if (((ScalarModel)this.getModel()).isRequired() && !Strings.isNullOrEmpty((String)(label = scalarName.getDefaultModelObjectAsString()))) {
            scalarName.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        labelIfRegular.add(new Component[]{scalarName});
        String describedAs = ((ScalarModel)this.getModel()).getDescribedAs();
        if (describedAs != null) {
            labelIfRegular.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)describedAs)))});
        }
        this.addFeedbackTo(labelIfRegular, (Component)this.textField);
        this.addEntityActionLinksBelowAndRight(labelIfRegular, entityActions);
        return labelIfRegular;
    }

    protected abstract IModel<String> getScalarPanelType();

    protected void addSemantics() {
    }

    private MarkupContainer createFormComponentLabel() {
        Fragment textFieldFragment = this.createTextFieldFragment("scalarValueContainer");
        AbstractTextComponent<T> textField = this.getTextField();
        String name = ((ScalarModel)this.getModel()).getName();
        textField.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormGroup scalarNameAndValue = new FormGroup("scalarIfRegular", (FormComponent<?>)textField);
        textFieldFragment.add(new Component[]{textField});
        scalarNameAndValue.add(new Component[]{textFieldFragment});
        return scalarNameAndValue;
    }

    protected Fragment createTextFieldFragment(String id) {
        return new Fragment(id, "text", (MarkupContainer)this);
    }

    protected void addStandardSemantics() {
        this.textField.setRequired(((ScalarModel)this.getModel()).isRequired());
        this.setTextFieldSizeAndMaxLengthIfSpecified(this.textField);
        this.addValidator();
    }

    protected void addValidator() {
        final ScalarModel scalarModel = (ScalarModel)this.getModel();
        this.textField.add(new IValidator<T>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<T> validatable) {
                Serializable proposedValue = (Serializable)validatable.getValue();
                ObjectAdapter proposedAdapter = ScalarPanelTextFieldAbstract.this.getAdapterManager().adapterFor((Object)proposedValue);
                String reasonIfAny = scalarModel.validate(proposedAdapter);
                if (reasonIfAny != null) {
                    ValidationError error = new ValidationError();
                    error.setMessage(reasonIfAny);
                    validatable.error((IValidationError)error);
                }
            }
        });
    }

    protected void setTextFieldSizeAndMaxLengthIfSpecified(AbstractTextComponent<T> textField) {
        Integer maxLength = ScalarPanelTextFieldAbstract.getValueOf((ScalarModel)this.getModel(), MaxLengthFacet.class);
        Integer typicalLength = ScalarPanelTextFieldAbstract.getValueOf((ScalarModel)this.getModel(), TypicalLengthFacet.class);
        if (typicalLength != null && maxLength != null && typicalLength > maxLength) {
            typicalLength = maxLength;
        }
        if (typicalLength != null) {
            textField.add(new Behavior[]{new AttributeModifier("size", (IModel)Model.of((Serializable)((Object)("" + typicalLength))))});
        }
        if (maxLength != null) {
            textField.add(new Behavior[]{new AttributeModifier("maxlength", (IModel)Model.of((Serializable)((Object)("" + maxLength))))});
        }
    }

    private static Integer getValueOf(ScalarModel model, Class<? extends SingleIntValueFacet> facetType) {
        SingleIntValueFacet facet = (SingleIntValueFacet)model.getFacet(facetType);
        return facet != null ? Integer.valueOf(facet.value()) : null;
    }

    @Override
    protected Component addComponentForCompact() {
        Fragment compactFragment = this.getCompactFragment(ScalarPanelAbstract.CompactType.SPAN);
        Label labelIfCompact = new Label("scalarIfCompact", ((ScalarModel)this.getModel()).getObjectAsString());
        compactFragment.add(new Component[]{labelIfCompact});
        this.scalarTypeContainer.addOrReplace(new Component[]{compactFragment});
        return labelIfCompact;
    }

    @Override
    protected void onBeforeRenderWhenViewMode() {
        super.onBeforeRenderWhenViewMode();
        this.textField.setEnabled(false);
        this.setTitleAttribute("");
    }

    @Override
    protected void onBeforeRenderWhenDisabled(String disableReason) {
        super.onBeforeRenderWhenDisabled(disableReason);
        this.textField.setEnabled(false);
        this.setTitleAttribute(disableReason);
    }

    @Override
    protected void onBeforeRenderWhenEnabled() {
        super.onBeforeRenderWhenEnabled();
        this.textField.setEnabled(true);
        this.setTitleAttribute("");
    }

    private void setTitleAttribute(String titleAttribute) {
        this.textField.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)titleAttribute)))});
    }

    @Override
    protected void addFormComponentBehavior(Behavior behavior) {
        this.textField.add(new Behavior[]{behavior});
    }
}

