/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.components.scalars.reference;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.Select2Choice;
import com.vaynberg.wicket.select2.Settings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.facets.all.named.NamedFacet;
import org.apache.isis.core.metamodel.facets.object.autocomplete.AutoCompleteFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.model.isis.WicketViewerSettings;
import org.apache.isis.viewer.wicket.model.links.LinkAndLabel;
import org.apache.isis.viewer.wicket.model.mementos.ObjectAdapterMemento;
import org.apache.isis.viewer.wicket.model.models.EntityModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModel;
import org.apache.isis.viewer.wicket.model.models.ScalarModelWithPending;
import org.apache.isis.viewer.wicket.ui.ComponentFactory;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.components.actionmenu.entityactions.EntityActionUtil;
import org.apache.isis.viewer.wicket.ui.components.scalars.ScalarPanelAbstract;
import org.apache.isis.viewer.wicket.ui.components.scalars.reference.EntityLinkSelect2Panel;
import org.apache.isis.viewer.wicket.ui.components.widgets.ObjectAdapterMementoProviderAbstract;
import org.apache.isis.viewer.wicket.ui.components.widgets.bootstrap.FormGroup;
import org.apache.isis.viewer.wicket.ui.components.widgets.entitysimplelink.EntityLinkSimplePanel;
import org.apache.isis.viewer.wicket.ui.components.widgets.select2.Select2ChoiceUtil;
import org.apache.isis.viewer.wicket.ui.util.Components;
import org.apache.isis.viewer.wicket.ui.util.CssClassAppender;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.LabeledWebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public class ReferencePanel
extends ScalarPanelAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_AUTO_COMPLETE = "autoComplete";
    private static final String ID_ENTITY_ICON_TITLE = "entityIconAndTitle";
    private static final String KEY_DISABLE_DEPENDENT_CHOICE_AUTO_SELECTION = "isis.viewer.wicket.disableDependentChoiceAutoSelection";
    private EntityLinkSelect2Panel entityLink;
    Select2Choice<ObjectAdapterMemento> select2Field;
    private EntityLinkSimplePanel entitySimpleLink;
    @Inject
    private WicketViewerSettings wicketViewerSettings;

    public ReferencePanel(String id, ScalarModel scalarModel) {
        super(id, scalarModel);
    }

    @Override
    protected Component addComponentForCompact() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        String name = scalarModel.getName();
        this.entitySimpleLink = (EntityLinkSimplePanel)this.getComponentFactoryRegistry().createComponent(ComponentType.ENTITY_LINK, (IModel<?>)this.getModel());
        this.entitySimpleLink.setOutputMarkupId(true);
        this.entitySimpleLink.setLabel((IModel)Model.of((Serializable)((Object)name)));
        WebMarkupContainer labelIfCompact = new WebMarkupContainer("scalarIfCompact");
        labelIfCompact.add(new Component[]{this.entitySimpleLink});
        this.addOrReplace(new Component[]{labelIfCompact});
        return labelIfCompact;
    }

    protected FormGroup addComponentForRegular() {
        ScalarModel scalarModel = (ScalarModel)this.getModel();
        String name = scalarModel.getName();
        this.entityLink = new EntityLinkSelect2Panel(ComponentType.ENTITY_LINK.getWicketId(), this);
        this.syncWithInput();
        this.setOutputMarkupId(true);
        this.entityLink.setOutputMarkupId(true);
        this.entityLink.setLabel((IModel)Model.of((Serializable)((Object)name)));
        FormGroup labelIfRegular = new FormGroup("scalarIfRegular", (FormComponent<?>)this.entityLink);
        labelIfRegular.add(new Component[]{this.entityLink});
        String describedAs = ((ScalarModel)this.getModel()).getDescribedAs();
        if (describedAs != null) {
            labelIfRegular.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)describedAs)))});
        }
        Label scalarName = new Label("scalarName", this.getRendering().getLabelCaption((LabeledWebMarkupContainer)this.entityLink));
        labelIfRegular.add(new Component[]{scalarName});
        NamedFacet namedFacet = (NamedFacet)((ScalarModel)this.getModel()).getFacet(NamedFacet.class);
        if (namedFacet != null) {
            scalarName.setEscapeModelStrings(namedFacet.escaped());
        }
        List<LinkAndLabel> entityActions = EntityActionUtil.getEntityActionLinksForAssociation(this.scalarModel, this.getDeploymentType());
        this.addPositioningCssTo((MarkupContainer)labelIfRegular, entityActions);
        this.addOrReplace(new Component[]{labelIfRegular});
        this.addFeedbackTo((MarkupContainer)labelIfRegular, (Component)this.entityLink);
        this.addEntityActionLinksBelowAndRight((MarkupContainer)labelIfRegular, entityActions);
        this.entityLink.setRequired(((ScalarModel)this.getModel()).isRequired());
        this.entityLink.add((IValidator)new IValidator<ObjectAdapter>(){
            private static final long serialVersionUID = 1L;

            public void validate(IValidatable<ObjectAdapter> validatable) {
                ObjectAdapter proposedAdapter = (ObjectAdapter)validatable.getValue();
                String reasonIfAny = ((ScalarModel)ReferencePanel.this.getModel()).validate(proposedAdapter);
                if (reasonIfAny != null) {
                    ValidationError error = new ValidationError();
                    error.setMessage(reasonIfAny);
                    validatable.error((IValidationError)error);
                }
            }
        });
        if (((ScalarModel)this.getModel()).isRequired()) {
            labelIfRegular.add(new Behavior[]{new CssClassAppender("mandatory")});
        }
        return labelIfRegular;
    }

    @Override
    protected void addFormComponentBehavior(Behavior behavior) {
        if (this.select2Field != null) {
            this.select2Field.add(new Behavior[]{behavior});
        }
    }

    @Override
    protected void onBeforeRenderWhenEnabled() {
        super.onBeforeRenderWhenEnabled();
        this.entityLink.setEnabled(true);
        this.syncWithInput();
    }

    @Override
    protected void onBeforeRenderWhenViewMode() {
        super.onBeforeRenderWhenViewMode();
        this.entityLink.setEnabled(false);
        this.syncWithInput();
    }

    @Override
    protected void onBeforeRenderWhenDisabled(String disableReason) {
        super.onBeforeRenderWhenDisabled(disableReason);
        this.syncWithInput();
        EntityModel entityLinkModel = (EntityModel)this.entityLink.getModel();
        entityLinkModel.toViewMode();
        this.entityLink.setEnabled(false);
        this.entityLink.add(new Behavior[]{new AttributeModifier("title", (IModel)Model.of((Serializable)((Object)disableReason)))});
    }

    private void syncWithInput() {
        ObjectAdapter adapter = ((ScalarModel)this.getModel()).getPendingElseCurrentAdapter();
        MarkupContainer componentForRegular = (MarkupContainer)this.getComponentForRegular();
        if (adapter != null) {
            if (componentForRegular != null) {
                EntityModel entityModelForLink = new EntityModel(adapter);
                entityModelForLink.setContextAdapterIfAny(((ScalarModel)this.getModel()).getContextAdapterIfAny());
                entityModelForLink.setRenderingHint(((ScalarModel)this.getModel()).getRenderingHint());
                ComponentFactory componentFactory = this.getComponentFactoryRegistry().findComponentFactory(ComponentType.ENTITY_ICON_AND_TITLE, (IModel<?>)entityModelForLink);
                Component component = componentFactory.createComponent((IModel<?>)entityModelForLink);
                componentForRegular.addOrReplace(new Component[]{component});
                Components.permanentlyHide(componentForRegular, "entityTitleIfNull");
            }
        } else if (componentForRegular != null) {
            componentForRegular.addOrReplace(new Component[]{new Label("entityTitleIfNull", "(none)")});
            Components.permanentlyHide(componentForRegular, ID_ENTITY_ICON_TITLE);
        }
        if (this.isEditableWithEitherAutoCompleteOrChoices()) {
            Model model = ScalarModelWithPending.Util.createModel((ScalarModelWithPending)((ScalarModel)this.getModel()).asScalarModelWithPending());
            if (this.select2Field == null) {
                this.entityLink.setRequired(((ScalarModel)this.getModel()).isRequired());
                this.select2Field = Select2ChoiceUtil.newSelect2Choice(ID_AUTO_COMPLETE, (IModel<ObjectAdapterMemento>)model, (ScalarModel)this.getModel());
                this.setProviderAndCurrAndPending(this.select2Field, ((ScalarModel)this.getModel()).getActionArgsHint());
                if (!((ScalarModel)this.getModel()).hasChoices()) {
                    Settings settings = this.select2Field.getSettings();
                    int minLength = ((ScalarModel)this.getModel()).getAutoCompleteMinLength();
                    settings.setMinimumInputLength(Integer.valueOf(minLength));
                    settings.setPlaceholder((Object)((ScalarModel)this.getModel()).getName());
                }
                this.entityLink.addOrReplace(new Component[]{this.select2Field});
            } else {
                this.select2Field.clearInput();
            }
            if (this.getComponentForRegular() != null) {
                Components.permanentlyHide((MarkupContainer)this.getComponentForRegular(), ID_ENTITY_ICON_TITLE);
                Components.permanentlyHide(componentForRegular, "entityTitleIfNull");
            }
            if (this.select2Field != null) {
                boolean mutability = this.entityLink.isEnableAllowed() && !((ScalarModel)this.getModel()).isViewMode();
                this.select2Field.setEnabled(mutability);
            }
            Components.permanentlyHide((MarkupContainer)this.entityLink, "entityLinkIfNull");
        } else {
            Components.permanentlyHide((MarkupContainer)this.entityLink, ID_AUTO_COMPLETE);
            this.select2Field = null;
        }
    }

    private void permanentlyHideEntityIconAndTitleIfInRegularMode() {
        if (this.getComponentForRegular() != null) {
            Components.permanentlyHide((MarkupContainer)this.getComponentForRegular(), ID_ENTITY_ICON_TITLE);
        }
    }

    private void setProviderAndCurrAndPending(Select2Choice<ObjectAdapterMemento> select2Field, ObjectAdapter[] argsIfAvailable) {
        if (((ScalarModel)this.getModel()).hasChoices()) {
            List<ObjectAdapterMemento> choiceMementos = this.obtainChoiceMementos(argsIfAvailable);
            ObjectAdapterMementoProviderAbstract providerForChoices = this.providerForChoices(choiceMementos);
            select2Field.setProvider((ChoiceProvider)providerForChoices);
            ((ScalarModel)this.getModel()).clearPending();
            this.resetIfCurrentNotInChoices(select2Field, choiceMementos);
        } else if (this.hasParamOrPropertyAutoComplete()) {
            select2Field.setProvider(this.providerForParamOrPropertyAutoComplete());
            ((ScalarModel)this.getModel()).clearPending();
        } else {
            select2Field.setProvider(this.providerForObjectAutoComplete());
            ((ScalarModel)this.getModel()).clearPending();
        }
    }

    private List<ObjectAdapterMemento> obtainChoiceMementos(ObjectAdapter[] argsIfAvailable) {
        ArrayList choices = Lists.newArrayList();
        if (((ScalarModel)this.getModel()).hasChoices()) {
            choices.addAll(((ScalarModel)this.getModel()).getChoices(argsIfAvailable, this.getAuthenticationSession(), this.getDeploymentCategory()));
        }
        return Lists.newArrayList((Iterable)Lists.transform((List)choices, (Function)ObjectAdapterMemento.Functions.fromAdapter()));
    }

    private void resetIfCurrentNotInChoices(Select2Choice<ObjectAdapterMemento> select2Field, List<ObjectAdapterMemento> choiceMementos) {
        ObjectAdapterMemento curr = (ObjectAdapterMemento)select2Field.getModelObject();
        if (curr == null) {
            select2Field.getModel().setObject(null);
            ((ScalarModel)this.getModel()).setObject(null);
            return;
        }
        if (!curr.containedIn(choiceMementos)) {
            if (!choiceMementos.isEmpty() && this.autoSelect()) {
                ObjectAdapterMemento newAdapterMemento = choiceMementos.get(0);
                select2Field.getModel().setObject((Object)newAdapterMemento);
                ((ScalarModel)this.getModel()).setObject(newAdapterMemento.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK));
            } else {
                select2Field.getModel().setObject(null);
                ((ScalarModel)this.getModel()).setObject(null);
            }
        }
    }

    private boolean autoSelect() {
        boolean disableAutoSelect = this.getConfiguration().getBoolean(KEY_DISABLE_DEPENDENT_CHOICE_AUTO_SELECTION, false);
        boolean autoSelect = !disableAutoSelect;
        return autoSelect;
    }

    private ChoiceProvider<ObjectAdapterMemento> providerForObjectAutoComplete() {
        return new ObjectAdapterMementoProviderAbstract((ScalarModel)this.getModel(), this.wicketViewerSettings){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<ObjectAdapterMemento> obtainMementos(String term) {
                ObjectSpecification typeOfSpecification = this.getScalarModel().getTypeOfSpecification();
                AutoCompleteFacet autoCompleteFacet = (AutoCompleteFacet)typeOfSpecification.getFacet(AutoCompleteFacet.class);
                List autoCompleteAdapters = autoCompleteFacet.execute(term, ReferencePanel.this.getAuthenticationSession(), ReferencePanel.this.getDeploymentCategory());
                return Lists.newArrayList((Iterable)Lists.transform((List)autoCompleteAdapters, (Function)ObjectAdapterMemento.Functions.fromAdapter()));
            }
        };
    }

    private ChoiceProvider<ObjectAdapterMemento> providerForParamOrPropertyAutoComplete() {
        return new ObjectAdapterMementoProviderAbstract((ScalarModel)this.getModel(), this.wicketViewerSettings){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<ObjectAdapterMemento> obtainMementos(String term) {
                ArrayList autoCompleteChoices = Lists.newArrayList();
                if (this.getScalarModel().hasAutoComplete()) {
                    List autoCompleteAdapters = this.getScalarModel().getAutoComplete(term, ReferencePanel.this.getAuthenticationSession(), ReferencePanel.this.getDeploymentCategory());
                    autoCompleteChoices.addAll(autoCompleteAdapters);
                }
                return Lists.newArrayList((Iterable)Lists.transform((List)autoCompleteChoices, (Function)ObjectAdapterMemento.Functions.fromAdapter()));
            }
        };
    }

    private ObjectAdapterMementoProviderAbstract providerForChoices(final List<ObjectAdapterMemento> choiceMementos) {
        return new ObjectAdapterMementoProviderAbstract((ScalarModel)this.getModel(), this.wicketViewerSettings){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<ObjectAdapterMemento> obtainMementos(String term) {
                return this.obtainMementos(term, choiceMementos);
            }
        };
    }

    String getInput() {
        ObjectAdapter pendingElseCurrentAdapter = ((ScalarModel)this.getModel()).getPendingElseCurrentAdapter();
        return pendingElseCurrentAdapter != null ? pendingElseCurrentAdapter.titleString(null) : "(no object)";
    }

    void convertInput() {
        if (this.isEditableWithEitherAutoCompleteOrChoices()) {
            ObjectAdapterMemento convertedInput = (ObjectAdapterMemento)this.select2Field.getConvertedInput();
            ((ScalarModel)this.getModel()).setPending(convertedInput);
            if (this.select2Field != null) {
                this.select2Field.getModel().setObject((Object)convertedInput);
            }
            ObjectAdapter adapter = convertedInput != null ? convertedInput.getObjectAdapter(AdapterManager.ConcurrencyChecking.NO_CHECK) : null;
            ((ScalarModel)this.getModel()).setObject(adapter);
        }
        ObjectAdapter pendingAdapter = ((ScalarModel)this.getModel()).getPendingAdapter();
        this.entityLink.setConvertedInput(pendingAdapter);
    }

    @Override
    public boolean updateChoices(ObjectAdapter[] argsIfAvailable) {
        if (this.select2Field != null) {
            this.setProviderAndCurrAndPending(this.select2Field, argsIfAvailable);
            return true;
        }
        return false;
    }

    private boolean isEditableWithEitherAutoCompleteOrChoices() {
        if (((ScalarModel)this.getModel()).getRenderingHint().isInTable()) {
            return false;
        }
        if (((ScalarModel)this.getModel()).isViewMode()) {
            return false;
        }
        return ((ScalarModel)this.getModel()).hasChoices() || this.hasParamOrPropertyAutoComplete() || this.hasObjectAutoComplete();
    }

    private boolean hasParamOrPropertyAutoComplete() {
        return ((ScalarModel)this.getModel()).hasAutoComplete();
    }

    private boolean hasObjectAutoComplete() {
        ObjectSpecification typeOfSpecification = ((ScalarModel)this.getModel()).getTypeOfSpecification();
        AutoCompleteFacet autoCompleteFacet = typeOfSpecification != null ? (AutoCompleteFacet)typeOfSpecification.getFacet(AutoCompleteFacet.class) : null;
        return autoCompleteFacet != null;
    }

    private DeploymentCategory getDeploymentCategory() {
        return this.getDeploymentType().getDeploymentCategory();
    }

    IsisConfiguration getConfiguration() {
        return IsisContext.getConfiguration();
    }
}

