/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt;

import java.util.UUID;
import javax.inject.Inject;
import org.apache.isis.viewer.wicket.model.models.PageType;
import org.apache.isis.viewer.wicket.ui.pages.EmailVerificationUrlService;
import org.apache.isis.viewer.wicket.ui.pages.PageClassRegistry;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.AccountConfirmationMap;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.UrlRenderer;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class EmailVerificationUrlServiceDefault
implements EmailVerificationUrlService {
    private final PageClassRegistry pageClassRegistry;

    @Inject
    public EmailVerificationUrlServiceDefault(PageClassRegistry pageClassRegistry) {
        this.pageClassRegistry = pageClassRegistry;
    }

    @Override
    public String createVerificationUrl(PageType pageType, String datum) {
        Class<? extends Page> pageClass = this.pageClassRegistry.getPageClass(pageType);
        return this.createVerificationUrl(pageClass, datum);
    }

    @Override
    public String createVerificationUrl(Class<? extends Page> pageClass, String datum) {
        String uuid = UUID.randomUUID().toString();
        uuid = uuid.replace("-", "");
        AccountConfirmationMap accountConfirmationMap = this.getAccountConfirmationMap();
        accountConfirmationMap.put(uuid, (Object)datum);
        PageParameters parameters = new PageParameters();
        parameters.set(0, (Object)uuid);
        String fullUrl = this.fullUrlFor(pageClass, parameters);
        return fullUrl;
    }

    protected String fullUrlFor(Class<? extends Page> pageClass, PageParameters parameters) {
        RequestCycle requestCycle = RequestCycle.get();
        CharSequence relativeUrl = requestCycle.urlFor(pageClass, parameters);
        UrlRenderer urlRenderer = requestCycle.getUrlRenderer();
        String fullUrl = urlRenderer.renderFullUrl(Url.parse((CharSequence)relativeUrl));
        return fullUrl;
    }

    protected AccountConfirmationMap getAccountConfirmationMap() {
        return (AccountConfirmationMap)((Object)Application.get().getMetaData(AccountConfirmationMap.KEY));
    }
}

