/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.accmngt.password_reset;

import de.agilecoders.wicket.core.markup.html.bootstrap.common.NotificationPanel;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.isis.applib.services.userreg.UserRegistrationService;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.viewer.wicket.ui.errors.ExceptionModel;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.AccountConfirmationMap;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.AccountManagementPageAbstract;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.password_reset.PasswordResetEmailPanel;
import org.apache.isis.viewer.wicket.ui.pages.accmngt.password_reset.PasswordResetPanel;
import org.apache.isis.viewer.wicket.ui.pages.login.WicketSignInPage;
import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;

public class PasswordResetPage
extends AccountManagementPageAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_CONTENT_PANEL = "passwordResetPanel";

    public PasswordResetPage(PageParameters parameters) {
        this(parameters, PasswordResetPage.getAndClearExceptionModelIfAny());
    }

    private PasswordResetPage(PageParameters parameters, ExceptionModel exceptionModel) {
        super(parameters, exceptionModel);
        boolean suppressPasswordResetLink = this.getConfiguration().getBoolean("isis.viewer.wicket.suppressPasswordReset", false);
        if (suppressPasswordResetLink) {
            throw new RestartResponseAtInterceptPageException(WicketSignInPage.class);
        }
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{new NotificationPanel("feedback")});
        StringValue uuidValue = this.getPageParameters().get(0);
        if (uuidValue.isEmpty()) {
            this.addPasswordResetEmailPanel(ID_CONTENT_PANEL);
        } else {
            String uuid = uuidValue.toString();
            AccountConfirmationMap accountConfirmationMap = (AccountConfirmationMap)((Object)this.getApplication().getMetaData(AccountConfirmationMap.KEY));
            final String email = accountConfirmationMap.get(uuid);
            if (Strings.isEmpty((CharSequence)email)) {
                this.error((Serializable)((Object)this.getString("passwordResetExpiredOrInvalidToken")));
                this.addOrReplace(new Component[]{this.addPasswordResetEmailPanel(ID_CONTENT_PANEL)});
            } else {
                Boolean emailExists = (Boolean)IsisContext.doInSession((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        UserRegistrationService userRegistrationService = (UserRegistrationService)IsisContext.getPersistenceSession().getServicesInjector().lookupService(UserRegistrationService.class);
                        return userRegistrationService.emailExists(email);
                    }
                });
                if (!emailExists.booleanValue()) {
                    this.error((Serializable)((Object)this.getString("noUserForAnEmailValidToken")));
                    this.addOrReplace(new Component[]{this.addPasswordResetEmailPanel(ID_CONTENT_PANEL)});
                } else {
                    this.addPasswordResetPanel(ID_CONTENT_PANEL, uuid);
                }
            }
        }
    }

    protected PasswordResetPanel addPasswordResetPanel(String id, String uuid) {
        PasswordResetPanel passwordResetPanel = new PasswordResetPanel(id, uuid);
        this.addOrReplace(new Component[]{passwordResetPanel});
        return passwordResetPanel;
    }

    protected PasswordResetEmailPanel addPasswordResetEmailPanel(String id) {
        PasswordResetEmailPanel passwordResetEmailPanel = new PasswordResetEmailPanel(id);
        this.addOrReplace(new Component[]{passwordResetEmailPanel});
        return passwordResetEmailPanel;
    }
}

