/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.wicket.ui.pages.voidreturn;

import org.apache.isis.viewer.wicket.model.common.PageParametersUtils;
import org.apache.isis.viewer.wicket.model.models.ActionModel;
import org.apache.isis.viewer.wicket.model.models.VoidModel;
import org.apache.isis.viewer.wicket.ui.ComponentType;
import org.apache.isis.viewer.wicket.ui.pages.PageAbstract;
import org.apache.wicket.Component;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;

@AuthorizeInstantiation(value={"org.apache.isis.viewer.wicket.roles.USER"})
public class VoidReturnPage
extends PageAbstract {
    private static final long serialVersionUID = 1L;
    private static final String ID_ACTION_NAME = "actionName";

    public VoidReturnPage(VoidModel model) {
        this(model, VoidReturnPage.actionNameFrom(model));
    }

    private VoidReturnPage(VoidModel model, String actionName) {
        super(PageParametersUtils.newPageParameters(), actionName, ComponentType.VOID_RETURN);
        this.themeDiv.addOrReplace(new Component[]{new Label(ID_ACTION_NAME, actionName)});
        this.addChildComponents(this.themeDiv, (IModel<?>)model);
        this.addBookmarkedPages(this.themeDiv);
    }

    private static String actionNameFrom(VoidModel model) {
        ActionModel actionModel = model.getActionModelHint();
        if (actionModel != null) {
            return actionModel.getActionMemento().getAction().getName();
        }
        return "Results";
    }
}

