/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.MockClient;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;

public class AdminClientUnitTestEnv
implements AutoCloseable {
    private final Time time;
    private final Cluster cluster;
    private final MockClient mockClient;
    private final KafkaAdminClient adminClient;

    public AdminClientUnitTestEnv(Cluster cluster, String ... vals) {
        this(Time.SYSTEM, cluster, vals);
    }

    public AdminClientUnitTestEnv(Time time, Cluster cluster, String ... vals) {
        this(time, cluster, AdminClientUnitTestEnv.newStrMap(vals));
    }

    public AdminClientUnitTestEnv(Time time, Cluster cluster) {
        this(time, cluster, AdminClientUnitTestEnv.newStrMap(new String[0]));
    }

    public AdminClientUnitTestEnv(Time time, final Cluster cluster, Map<String, Object> config) {
        this.time = time;
        this.cluster = cluster;
        AdminClientConfig adminClientConfig = new AdminClientConfig(config);
        AdminMetadataManager metadataManager = new AdminMetadataManager(new LogContext(), adminClientConfig.getLong("retry.backoff.ms").longValue(), adminClientConfig.getLong("metadata.max.age.ms").longValue());
        this.mockClient = new MockClient(time, new MockClient.MockMetadataUpdater(){

            @Override
            public List<Node> fetchNodes() {
                return cluster.nodes();
            }

            @Override
            public boolean isUpdateNeeded() {
                return false;
            }

            @Override
            public void update(Time time, MockClient.MetadataUpdate update) {
                throw new UnsupportedOperationException();
            }
        });
        metadataManager.update(cluster, time.milliseconds());
        this.adminClient = KafkaAdminClient.createInternal((AdminClientConfig)adminClientConfig, (AdminMetadataManager)metadataManager, (KafkaClient)this.mockClient, (Time)time);
    }

    public Time time() {
        return this.time;
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public AdminClient adminClient() {
        return this.adminClient;
    }

    public MockClient kafkaClient() {
        return this.mockClient;
    }

    @Override
    public void close() {
        this.adminClient.close();
    }

    private static Map<String, Object> newStrMap(String ... vals) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bootstrap.servers", "localhost:8121");
        map.put("request.timeout.ms", "1000");
        if (vals.length % 2 != 0) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < vals.length; i += 2) {
            map.put(vals[i], vals[i + 1]);
        }
        return map;
    }

    public static String kafkaAdminClientNetworkThreadPrefix() {
        return "kafka-admin-client-thread";
    }
}

