/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.Bytes;

public class FetchResponseData
implements ApiMessage {
    private int throttleTimeMs;
    private short errorCode;
    private int sessionId;
    private List<FetchableTopicResponse> topics;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_0), "The response topics.")});
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema SCHEMA_10;
    public static final Schema[] SCHEMAS;

    public FetchResponseData(Readable readable, short version) {
        this.topics = new ArrayList<FetchableTopicResponse>();
        this.read(readable, version);
    }

    public FetchResponseData(Struct struct, short version) {
        this.topics = new ArrayList<FetchableTopicResponse>();
        this.fromStruct(struct, version);
    }

    public FetchResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.sessionId = 0;
        this.topics = new ArrayList<FetchableTopicResponse>();
    }

    public short apiKey() {
        return 1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 10;
    }

    public void read(Readable readable, short version) {
        this.throttleTimeMs = version >= 1 ? readable.readInt() : 0;
        this.errorCode = version >= 7 ? readable.readShort() : (short)0;
        this.sessionId = version >= 7 ? readable.readInt() : 0;
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics.clear();
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new FetchableTopicResponse(readable, version));
            }
        }
    }

    public void write(Writable writable, short version) {
        if (version >= 1) {
            writable.writeInt(this.throttleTimeMs);
        }
        if (version >= 7) {
            writable.writeShort(this.errorCode);
        }
        if (version >= 7) {
            writable.writeInt(this.sessionId);
        }
        writable.writeInt(this.topics.size());
        for (FetchableTopicResponse element : this.topics) {
            element.write(writable, version);
        }
    }

    public void fromStruct(Struct struct, short version) {
        this.throttleTimeMs = version >= 1 ? struct.getInt("throttle_time_ms") : 0;
        this.errorCode = version >= 7 ? struct.getShort("error_code") : (short)0;
        this.sessionId = version >= 7 ? struct.getInt("session_id") : 0;
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<FetchableTopicResponse>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new FetchableTopicResponse((Struct)nestedObject, version));
        }
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        if (version >= 1) {
            struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        }
        if (version >= 7) {
            struct.set("error_code", (Object)this.errorCode);
        }
        if (version >= 7) {
            struct.set("session_id", (Object)this.sessionId);
        }
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (FetchableTopicResponse element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        if (version >= 1) {
            size += 4;
        }
        if (version >= 7) {
            size += 2;
        } else if (this.errorCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default errorCode at version " + version);
        }
        if (version >= 7) {
            size += 4;
        } else if (this.sessionId != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default sessionId at version " + version);
        }
        size += 4;
        for (FetchableTopicResponse element : this.topics) {
            size += element.size(version);
        }
        return size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FetchResponseData)) {
            return false;
        }
        FetchResponseData other = (FetchResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.sessionId != other.sessionId) {
            return false;
        }
        return !(this.topics == null ? other.topics != null : !this.topics.equals(other.topics));
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + this.sessionId;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public String toString() {
        return "FetchResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", sessionId=" + this.sessionId + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public List<FetchableTopicResponse> topics() {
        return this.topics;
    }

    public FetchResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public FetchResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public FetchResponseData setSessionId(int v) {
        this.sessionId = v;
        return this;
    }

    public FetchResponseData setTopics(List<FetchableTopicResponse> v) {
        this.topics = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_0), "The response topics.")}));
        SCHEMA_4 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_4), "The response topics.")});
        SCHEMA_6 = SCHEMA_5 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("topics", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_5), "The response topics.")});
        SCHEMA_10 = SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The top level response error code."), new Field("session_id", (Type)Type.INT32, "The fetch session ID, or 0 if this is not part of a fetch session."), new Field("topics", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_5), "The response topics.")})));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10};
    }

    public static class AbortedTransaction
    implements Message {
        private long producerId;
        private long firstOffset;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema[] SCHEMAS;

        public AbortedTransaction(Readable readable, short version) {
            this.read(readable, version);
        }

        public AbortedTransaction(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public AbortedTransaction() {
            this.producerId = 0L;
            this.firstOffset = 0L;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 10;
        }

        public void read(Readable readable, short version) {
            if (version < 4) {
                throw new UnsupportedVersionException("Can't read version " + version + " of AbortedTransaction");
            }
            this.producerId = readable.readLong();
            this.firstOffset = readable.readLong();
        }

        public void write(Writable writable, short version) {
            if (version < 4) {
                throw new UnsupportedVersionException("Can't write version " + version + " of AbortedTransaction");
            }
            writable.writeLong(this.producerId);
            writable.writeLong(this.firstOffset);
        }

        public void fromStruct(Struct struct, short version) {
            if (version < 4) {
                throw new UnsupportedVersionException("Can't read version " + version + " of AbortedTransaction");
            }
            this.producerId = struct.getLong("producer_id");
            this.firstOffset = struct.getLong("first_offset");
        }

        public Struct toStruct(short version) {
            if (version < 4) {
                throw new UnsupportedVersionException("Can't write version " + version + " of AbortedTransaction");
            }
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("producer_id", (Object)this.producerId);
            struct.set("first_offset", (Object)this.firstOffset);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            if (version < 4) {
                throw new UnsupportedVersionException("Can't size version " + version + " of AbortedTransaction");
            }
            size += 8;
            return size += 8;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AbortedTransaction)) {
                return false;
            }
            AbortedTransaction other = (AbortedTransaction)obj;
            if (this.producerId != other.producerId) {
                return false;
            }
            return this.firstOffset == other.firstOffset;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
            hashCode = 31 * hashCode + ((int)(this.firstOffset >> 32) ^ (int)this.firstOffset);
            return hashCode;
        }

        public String toString() {
            return "AbortedTransaction(producerId=" + this.producerId + ", firstOffset=" + this.firstOffset + ")";
        }

        public long producerId() {
            return this.producerId;
        }

        public long firstOffset() {
            return this.firstOffset;
        }

        public AbortedTransaction setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public AbortedTransaction setFirstOffset(long v) {
            this.firstOffset = v;
            return this;
        }

        static {
            SCHEMA_10 = SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = new Schema(new Field[]{new Field("producer_id", (Type)Type.INT64, "The producer id associated with the aborted transaction."), new Field("first_offset", (Type)Type.INT64, "The first offset in the aborted transaction.")}))))));
            SCHEMAS = new Schema[]{null, null, null, null, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10};
        }
    }

    public static class FetchablePartitionResponse
    implements Message {
        private int partitionIndex;
        private short errorCode;
        private long highWatermark;
        private long lastStableOffset;
        private long logStartOffset;
        private List<AbortedTransaction> aborted;
        private byte[] records;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema[] SCHEMAS;

        public FetchablePartitionResponse(Readable readable, short version) {
            this.aborted = new ArrayList<AbortedTransaction>();
            this.read(readable, version);
        }

        public FetchablePartitionResponse(Struct struct, short version) {
            this.aborted = new ArrayList<AbortedTransaction>();
            this.fromStruct(struct, version);
        }

        public FetchablePartitionResponse() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.highWatermark = 0L;
            this.lastStableOffset = -1L;
            this.logStartOffset = -1L;
            this.aborted = new ArrayList<AbortedTransaction>();
            this.records = Bytes.EMPTY;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 10;
        }

        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.errorCode = readable.readShort();
            this.highWatermark = readable.readLong();
            this.lastStableOffset = version >= 4 ? readable.readLong() : -1L;
            this.logStartOffset = version >= 5 ? readable.readLong() : -1L;
            if (version >= 4) {
                int arrayLength = readable.readInt();
                if (arrayLength < 0) {
                    this.aborted.clear();
                } else {
                    this.aborted.clear();
                    for (int i = 0; i < arrayLength; ++i) {
                        this.aborted.add(new AbortedTransaction(readable, version));
                    }
                }
            } else {
                this.aborted = new ArrayList<AbortedTransaction>();
            }
            this.records = readable.readNullableBytes();
        }

        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeShort(this.errorCode);
            writable.writeLong(this.highWatermark);
            if (version >= 4) {
                writable.writeLong(this.lastStableOffset);
            }
            if (version >= 5) {
                writable.writeLong(this.logStartOffset);
            }
            if (version >= 4) {
                if (this.aborted == null) {
                    writable.writeInt(-1);
                } else {
                    writable.writeInt(this.aborted.size());
                    for (AbortedTransaction element : this.aborted) {
                        element.write(writable, version);
                    }
                }
            }
            writable.writeNullableBytes(this.records);
        }

        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.errorCode = struct.getShort("error_code");
            this.highWatermark = struct.getLong("high_watermark");
            this.lastStableOffset = version >= 4 ? struct.getLong("last_stable_offset") : -1L;
            this.logStartOffset = version >= 5 ? struct.getLong("log_start_offset") : -1L;
            if (version >= 4) {
                Object[] nestedObjects = struct.getArray("aborted");
                if (nestedObjects == null) {
                    this.aborted = null;
                } else {
                    this.aborted = new ArrayList<AbortedTransaction>(nestedObjects.length);
                    for (Object nestedObject : nestedObjects) {
                        this.aborted.add(new AbortedTransaction((Struct)nestedObject, version));
                    }
                }
            } else {
                this.aborted = new ArrayList<AbortedTransaction>();
            }
            this.records = struct.getByteArray("records");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("error_code", (Object)this.errorCode);
            struct.set("high_watermark", (Object)this.highWatermark);
            if (version >= 4) {
                struct.set("last_stable_offset", (Object)this.lastStableOffset);
            }
            if (version >= 5) {
                struct.set("log_start_offset", (Object)this.logStartOffset);
            }
            if (version >= 4) {
                if (this.aborted == null) {
                    struct.set("aborted", null);
                } else {
                    Struct[] nestedObjects = new Struct[this.aborted.size()];
                    int i = 0;
                    for (AbortedTransaction element : this.aborted) {
                        nestedObjects[i++] = element.toStruct(version);
                    }
                    struct.set("aborted", (Object)nestedObjects);
                }
            }
            struct.setByteArray("records", this.records);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 4;
            size += 2;
            size += 8;
            if (version >= 4) {
                size += 8;
            }
            if (version >= 5) {
                size += 8;
            }
            if (version >= 4) {
                if (this.aborted == null) {
                    size += 4;
                } else {
                    size += 4;
                    for (AbortedTransaction element : this.aborted) {
                        size += element.size(version);
                    }
                }
            } else if (!this.aborted.isEmpty()) {
                throw new UnsupportedVersionException("Attempted to write a non-default aborted at version " + version);
            }
            size += 4;
            if (this.records != null) {
                size += this.records.length;
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchablePartitionResponse)) {
                return false;
            }
            FetchablePartitionResponse other = (FetchablePartitionResponse)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.highWatermark != other.highWatermark) {
                return false;
            }
            if (this.lastStableOffset != other.lastStableOffset) {
                return false;
            }
            if (this.logStartOffset != other.logStartOffset) {
                return false;
            }
            if (this.aborted == null ? other.aborted != null : !this.aborted.equals(other.aborted)) {
                return false;
            }
            return Arrays.equals(this.records, other.records);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + ((int)(this.highWatermark >> 32) ^ (int)this.highWatermark);
            hashCode = 31 * hashCode + ((int)(this.lastStableOffset >> 32) ^ (int)this.lastStableOffset);
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            hashCode = 31 * hashCode + (this.aborted == null ? 0 : this.aborted.hashCode());
            hashCode = 31 * hashCode + Arrays.hashCode(this.records);
            return hashCode;
        }

        public String toString() {
            return "FetchablePartitionResponse(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", highWatermark=" + this.highWatermark + ", lastStableOffset=" + this.lastStableOffset + ", logStartOffset=" + this.logStartOffset + ", aborted=" + MessageUtil.deepToString(this.aborted.iterator()) + ", records=" + Arrays.toString(this.records) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public long highWatermark() {
            return this.highWatermark;
        }

        public long lastStableOffset() {
            return this.lastStableOffset;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        public List<AbortedTransaction> aborted() {
            return this.aborted;
        }

        public byte[] records() {
            return this.records;
        }

        public FetchablePartitionResponse setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public FetchablePartitionResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public FetchablePartitionResponse setHighWatermark(long v) {
            this.highWatermark = v;
            return this;
        }

        public FetchablePartitionResponse setLastStableOffset(long v) {
            this.lastStableOffset = v;
            return this;
        }

        public FetchablePartitionResponse setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }

        public FetchablePartitionResponse setAborted(List<AbortedTransaction> v) {
            this.aborted = v;
            return this;
        }

        public FetchablePartitionResponse setRecords(byte[] v) {
            this.records = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partiiton index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", (Type)Type.INT64, "The current high water mark."), new Field("records", (Type)Type.NULLABLE_BYTES, "The record data.")})));
            SCHEMA_4 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partiiton index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", (Type)Type.INT64, "The current high water mark."), new Field("last_stable_offset", (Type)Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field("aborted", (Type)ArrayOf.nullable((Type)AbortedTransaction.SCHEMA_4), "The aborted transactions."), new Field("records", (Type)Type.NULLABLE_BYTES, "The record data.")});
            SCHEMA_10 = SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partiiton index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", (Type)Type.INT64, "The current high water mark."), new Field("last_stable_offset", (Type)Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field("log_start_offset", (Type)Type.INT64, "The current log start offset."), new Field("aborted", (Type)ArrayOf.nullable((Type)AbortedTransaction.SCHEMA_4), "The aborted transactions."), new Field("records", (Type)Type.NULLABLE_BYTES, "The record data.")})))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10};
        }
    }

    public static class FetchableTopicResponse
    implements Message {
        private String name;
        private List<FetchablePartitionResponse> partitions;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema[] SCHEMAS;

        public FetchableTopicResponse(Readable readable, short version) {
            this.partitions = new ArrayList<FetchablePartitionResponse>();
            this.read(readable, version);
        }

        public FetchableTopicResponse(Struct struct, short version) {
            this.partitions = new ArrayList<FetchablePartitionResponse>();
            this.fromStruct(struct, version);
        }

        public FetchableTopicResponse() {
            this.name = "";
            this.partitions = new ArrayList<FetchablePartitionResponse>();
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 10;
        }

        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions.clear();
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new FetchablePartitionResponse(readable, version));
                }
            }
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (FetchablePartitionResponse element : this.partitions) {
                element.write(writable, version);
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<FetchablePartitionResponse>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new FetchablePartitionResponse((Struct)nestedObject, version));
            }
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (FetchablePartitionResponse element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.name);
            size += 4;
            for (FetchablePartitionResponse element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchableTopicResponse)) {
                return false;
            }
            FetchableTopicResponse other = (FetchableTopicResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "FetchableTopicResponse(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<FetchablePartitionResponse> partitions() {
            return this.partitions;
        }

        public FetchableTopicResponse setName(String v) {
            this.name = v;
            return this;
        }

        public FetchableTopicResponse setPartitions(List<FetchablePartitionResponse> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)FetchablePartitionResponse.SCHEMA_0), "The topic partitions.")})));
            SCHEMA_4 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)FetchablePartitionResponse.SCHEMA_4), "The topic partitions.")});
            SCHEMA_10 = SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)FetchablePartitionResponse.SCHEMA_5), "The topic partitions.")})))));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10};
        }
    }
}

