/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\tUd\u0001B\u001f?\u0001\rCQ\u0001\u0016\u0001\u0005\u0002UCQa\u0016\u0001\u0005BaC\u0011\"\u001c\u0001A\u0002\u0003\u0007I\u0011\u00028\t\u0013i\u0004\u0001\u0019!a\u0001\n\u0013Y\bBCA\u0003\u0001\u0001\u0007\t\u0011)Q\u0005_\"Y\u0011q\u0001\u0001A\u0002\u0003\u0007I\u0011BA\u0005\u0011-\t\u0019\u0003\u0001a\u0001\u0002\u0004%I!!\n\t\u0017\u0005%\u0002\u00011A\u0001B\u0003&\u00111\u0002\u0005\f\u0003W\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0003C\u0006\u0002@\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0003bCA#\u0001\u0001\u0007\t\u0011)Q\u0005\u0003_A\u0011\"a\u0012\u0001\u0005\u0004%I!!\u0013\t\u0011\u0005m\u0003\u0001)A\u0005\u0003\u0017Bq!!\u0018\u0001\t\u0003\tI\u0005C\u0004\u0002j\u0001!\t!a\u001b\t\u000f\u0005\u0005\u0005\u0001\"\u0001\u0002\u0004\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAM\u0001\u0011\u0005\u00111\u0014\u0005\n\u0003K\u0003\u0011\u0013!C\u0001\u0003OCq!!0\u0001\t\u0003\ty\fC\u0004\u0002J\u0002!\t!a0\t\u000f\u0005M\u0007\u0001\"\u0001\u0002@\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0006bBAq\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0003K\u0004A\u0011AA`\u0011\u001d\tI\u000f\u0001C\u0001\u0003\u007fCq!!<\u0001\t\u0003\ty\fC\u0004\u0002r\u0002!\t!a0\t\u000f\u0005U\b\u0001\"\u0001\u0002@\"9\u0011\u0011 \u0001\u0005\u0002\u0005}\u0006bBA\u007f\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0005\u0003\u0001A\u0011AA`\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003\u007fCqA!\u0003\u0001\t\u0003\ty\fC\u0004\u0003\u000e\u0001!\t!a0\t\u000f\tE\u0001\u0001\"\u0001\u0002@\"9!Q\u0003\u0001\u0005\u0002\u0005}\u0006b\u0002B\r\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0005;\u0001A\u0011AA`\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0003\u007fCqA!\n\u0001\t\u0003\ty\fC\u0004\u0003*\u0001!\t!a0\t\u000f\t5\u0002\u0001\"\u0001\u0002@\"9!\u0011\u0007\u0001\u0005\u0002\u0005}\u0006b\u0002B\u001b\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0005s\u0001A\u0011AA`\u0011\u001d\u0011i\u0004\u0001C\u0001\u0003\u007fCqA!\u0011\u0001\t\u0003\ty\fC\u0004\u0003F\u0001!\t!a0\t\u000f\t%\u0003\u0001\"\u0001\u0002@\"9!Q\n\u0001\u0005\u0002\u0005}\u0006b\u0002B)\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0005+\u0002A\u0011AA`\u0011\u001d\u0011I\u0006\u0001C\u0001\u0003\u007fCqA!\u0018\u0001\t\u0003\ty\fC\u0004\u0003b\u0001!\t!a0\t\u000f\t\u0015\u0004\u0001\"\u0001\u0002@\"9!\u0011\u000e\u0001\u0005\u0002\u0005}\u0006b\u0002B7\u0001\u0011\u0005\u0011q\u0018\u0005\b\u0005c\u0002A\u0011AA`\u0005}!v\u000e]5d\u0007>lW.\u00198e/&$\b.\u00113nS:\u001cE.[3oiR+7\u000f\u001e\u0006\u0003\u007f\u0001\u000bQ!\u00193nS:T\u0011!Q\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001AI\u0013)\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001d\u0003\u0015aC5oi\u0016<'/\u0019;j_:L!!\u0013$\u0003--\u000bgm[1TKJ4XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"a\u0013(\u000e\u00031S!!\u0014!\u0002\u000bU$\u0018\u000e\\:\n\u0005=c%a\u0002'pO\u001eLgn\u001a\t\u0003#Jk\u0011AP\u0005\u0003'z\u0012QBU1dW\u0006;\u0018M]3UKN$\u0018A\u0002\u001fj]&$h\bF\u0001W!\t\t\u0006!A\bhK:,'/\u0019;f\u0007>tg-[4t+\u0005I\u0006c\u0001.eO:\u00111,\u0019\b\u00039~k\u0011!\u0018\u0006\u0003=\n\u000ba\u0001\u0010:p_Rt\u0014\"\u00011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\t\u001c\u0017a\u00029bG.\fw-\u001a\u0006\u0002A&\u0011QM\u001a\u0002\u0004'\u0016\f(B\u00012d!\tA7.D\u0001j\u0015\tQ\u0007)\u0001\u0004tKJ4XM]\u0005\u0003Y&\u00141bS1gW\u0006\u001cuN\u001c4jO\u0006aAo\u001c9jGN+'O^5dKV\tq\u000e\u0005\u0002qo:\u0011\u0011/\u001e\b\u0003eRt!\u0001X:\n\u0003\u0005K!a\u0010!\n\u0005Yt\u0014\u0001\u0004+pa&\u001c7i\\7nC:$\u0017B\u0001=z\u0005]\tE-\\5o\u00072LWM\u001c;U_BL7mU3sm&\u001cWM\u0003\u0002w}\u0005\u0001Bo\u001c9jGN+'O^5dK~#S-\u001d\u000b\u0004y\u0006\u0005\u0001CA?\u007f\u001b\u0005\u0019\u0017BA@d\u0005\u0011)f.\u001b;\t\u0011\u0005\rA!!AA\u0002=\f1\u0001\u001f\u00132\u00035!x\u000e]5d'\u0016\u0014h/[2fA\u0005Y\u0011\rZ7j]\u000ec\u0017.\u001a8u+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005}QBAA\b\u0015\ry\u0014\u0011\u0003\u0006\u0005\u0003'\t)\"A\u0004dY&,g\u000e^:\u000b\u0007\u0005\u000b9B\u0003\u0003\u0002\u001a\u0005m\u0011AB1qC\u000eDWM\u0003\u0002\u0002\u001e\u0005\u0019qN]4\n\t\u0005\u0005\u0012q\u0002\u0002\f\u0003\u0012l\u0017N\\\"mS\u0016tG/A\bbI6Lgn\u00117jK:$x\fJ3r)\ra\u0018q\u0005\u0005\n\u0003\u00079\u0011\u0011!a\u0001\u0003\u0017\tA\"\u00193nS:\u001cE.[3oi\u0002\nQ\u0002^3tiR{\u0007/[2OC6,WCAA\u0018!\u0011\t\t$!\u000f\u000f\t\u0005M\u0012Q\u0007\t\u00039\u000eL1!a\u000ed\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\u0019\u0019FO]5oO*\u0019\u0011qG2\u0002#Q,7\u000f\u001e+pa&\u001cg*Y7f?\u0012*\u0017\u000fF\u0002}\u0003\u0007B\u0011\"a\u0001\u000b\u0003\u0003\u0005\r!a\f\u0002\u001dQ,7\u000f\u001e+pa&\u001cg*Y7fA\u0005Iq\f^3ti:\u000bW.Z\u000b\u0003\u0003\u0017\u0002B!!\u0014\u0002X5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&A\u0003sk2,7O\u0003\u0003\u0002V\u0005m\u0011!\u00026v]&$\u0018\u0002BA-\u0003\u001f\u0012\u0001\u0002V3ti:\u000bW.Z\u0001\u000b?R,7\u000f\u001e(b[\u0016\u0004\u0013\u0001\u0003;fgRt\u0015-\\3)\u00079\t\t\u0007\u0005\u0003\u0002d\u0005\u0015TBAA*\u0013\u0011\t9'a\u0015\u0003\tI+H.Z\u0001\u000fCN\u001cXM\u001d;Fq&$8i\u001c3f)\u0015a\u0018QNA<\u0011\u001d\tyg\u0004a\u0001\u0003c\n\u0001\"\u001a=qK\u000e$X\r\u001a\t\u0004{\u0006M\u0014bAA;G\n\u0019\u0011J\u001c;\t\u000f\u0005et\u00021\u0001\u0002|\u00051Q.\u001a;i_\u0012\u0004B!`A?y&\u0019\u0011qP2\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0014aF1tg\u0016\u0014Ho\u00115fG.\f%oZ:Fq&$8i\u001c3f)\u0015a\u0018QQAD\u0011\u001d\ty\u0007\u0005a\u0001\u0003cBq!!#\u0011\u0001\u0004\tY)A\u0004paRLwN\\:\u0011\u0007A\fi)C\u0002\u0002\u0010f\u00141\u0003V8qS\u000e\u001cu.\\7b]\u0012|\u0005\u000f^5p]N\f!c\u0019:fCR,\u0017I\u001c3XC&$Hk\u001c9jGR\u0019A0!&\t\u000f\u0005]\u0015\u00031\u0001\u0002\f\u0006!q\u000e\u001d;t\u0003M9\u0018-\u001b;G_J$v\u000e]5d\u0007J,\u0017\r^3e)\u0015a\u0018QTAQ\u0011\u001d\tyJ\u0005a\u0001\u0003_\t\u0011\u0002^8qS\u000et\u0015-\\3\t\u0013\u0005\r&\u0003%AA\u0002\u0005E\u0014a\u0002;j[\u0016|W\u000f^\u0001\u001eo\u0006LGOR8s)>\u0004\u0018nY\"sK\u0006$X\r\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u0016\u0016\u0005\u0003c\nYk\u000b\u0002\u0002.B!\u0011qVA]\u001b\t\t\tL\u0003\u0003\u00024\u0006U\u0016!C;oG\",7m[3e\u0015\r\t9lY\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA^\u0003c\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\u0015\u0019X\r^;q)\u0005a\bf\u0001\u000b\u0002DB!\u00111MAc\u0013\u0011\t9-a\u0015\u0003\r\t+gm\u001c:f\u0003\u0015\u0019Gn\\:fQ\r)\u0012Q\u001a\t\u0005\u0003G\ny-\u0003\u0003\u0002R\u0006M#!B!gi\u0016\u0014\u0018a\u0005;fgR\u0004\u0016M]:f\u0003N\u001c\u0018n\u001a8nK:$\bf\u0001\f\u0002XB!\u00111MAm\u0013\u0011\tY.a\u0015\u0003\tQ+7\u000f^\u0001$i\u0016\u001cH\u000fU1sg\u0016\f5o]5h]6,g\u000e\u001e#va2L7-\u0019;f\u000b:$(/[3tQ\r9\u0012q[\u0001-i\u0016\u001cH\u000fU1sg\u0016\f5o]5h]6,g\u000e\u001e)beRLG/[8og>3G)\u001b4gKJ,g\u000e^*ju\u0016D3\u0001GAl\u0003\u0005\"Xm\u001d;D_:4\u0017nZ(qi^KG\u000f\u001b\"p_R\u001cHO]1q'\u0016\u0014h/\u001a:tQ\rI\u0012q[\u0001\u000bi\u0016\u001cHo\u0011:fCR,\u0007f\u0001\u000e\u0002X\u0006)B/Z:u\u0007J,\u0017\r^3XSRD7i\u001c8gS\u001e\u001c\bfA\u000e\u0002X\u0006YB/Z:u\u0007J,\u0017\r^3JM&#\u0018\t\u001c:fC\u0012LX\t_5tiND3\u0001HAl\u0003}!Xm\u001d;De\u0016\fG/Z,ji\"\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\u0015\u0004;\u0005]\u0017A\n;fgR\u001c%/Z1uK^KG\u000f[%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019;j_:4\u0015m\u0019;pe\"\u001aa$a6\u0002OQ,7\u000f^\"sK\u0006$XmV5uQ:+w-\u0019;jm\u0016\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN\u001d\u0015\u0004?\u0005]\u0017!\u000b;fgR\u001c%/Z1uK^KG\u000f[!tg&<g.\\3oi\u0006sG\rU1si&$\u0018n\u001c8D_VtG\u000fK\u0002!\u0003/\fA\u0006^3ti\u000e\u0013X-\u0019;f/&$\b.Q:tS\u001etW.\u001a8u\u0003:$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:)\u0007\u0005\n9.\u0001\u0013uKN$8I]3bi\u0016<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\r\u0011\u0013q[\u0001(i\u0016\u001cHo\u0011:fCR,w+\u001b;i+:\u001c\b/Z2jM&,G\rU1si&$\u0018n\u001c8D_VtG\u000fK\u0002$\u0003/\f1\u0004^3ti&sg/\u00197jIR{\u0007/[2MKZ,GnQ8oM&<\u0007f\u0001\u0013\u0002X\u0006qA/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001c\bfA\u0013\u0002X\u0006YB/Z:u\u0019&\u001cH\u000fV8qS\u000e\u001cx+\u001b;i/\"LG/\u001a7jgRD3AJAl\u0003\u0005\"Xm\u001d;MSN$Hk\u001c9jGN<\u0016\u000e\u001e5Fq\u000edW\u000fZ3J]R,'O\\1mQ\r9\u0013q[\u0001\u0018i\u0016\u001cH/\u00117uKJ\u0004\u0016M\u001d;ji&|gnQ8v]RD3\u0001KAl\u0003M!Xm\u001d;BYR,'/Q:tS\u001etW.\u001a8uQ\rI\u0013q[\u00014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e^,ji\"luN]3BgNLwM\\7f]R$\u0006.\u00198QCJ$\u0018\u000e^5p]ND3AKAl\u0003M\"Xm\u001d;BYR,'/Q:tS\u001etW.\u001a8u/&$\b.T8sKB\u000b'\u000f^5uS>t7\u000f\u00165b]\u0006\u001b8/[4o[\u0016tG\u000fK\u0002,\u0003/\f!\u0005^3ti\u0006cG/\u001a:XSRD\u0017J\u001c<bY&$\u0007+\u0019:uSRLwN\\\"pk:$\bf\u0001\u0017\u0002X\u00061C/Z:u\u00032$XM],ji\",fn\u001d9fG&4\u0017.\u001a3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;)\u00075\n9.A\u000fuKN$\u0018\t\u001c;fe^CWM\u001c+pa&\u001cGi\\3t]R,\u00050[:uQ\rq\u0013q[\u0001=i\u0016\u001cH/\u00134Fq&\u001cHo]!oI&3gj\u001c;Fq&\u001cHo](qi&|gn]%om\u0006d\u0017\u000eZ,ji\"\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000fK\u00020\u0003/\f\u0011\u0005^3ti\u000e\u0013X-\u0019;f\u00032$XM\u001d+pa&\u001cw+\u001b;i%\u0006\u001c7.Q<be\u0016D3\u0001MAl\u0003=\"Xm\u001d;D_:4\u0017n\u001a)sKN,'O^1uS>t\u0017i\u0019:pgN\u0004\u0016M\u001d;ji&|g.\u00117uKJ\fG/[8oQ\r\t\u0014q[\u0001\u0012i\u0016\u001cH\u000fV8qS\u000e$U\r\\3uS>t\u0007f\u0001\u001a\u0002X\u00069B/Z:u\t\u0016dW\r^3J]R,'O\\1m)>\u0004\u0018n\u0019\u0015\u0004g\u0005]\u0017A\u0005;fgR$U\r\\3uK&3W\t_5tiND3\u0001NAl\u00031!Xm\u001d;EKN\u001c'/\u001b2fQ\r)\u0014q[\u0001\"i\u0016\u001cH\u000fR3tGJL'-Z+oCZ\f\u0017\u000e\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004m\u0005]\u0017!\n;fgR$Um]2sS\n,WK\u001c3feJ+\u0007\u000f\\5dCR,G\rU1si&$\u0018n\u001c8tQ\r9\u0014q[\u0001\"i\u0016\u001cH\u000fR3tGJL'-Z+oI\u0016\u0014X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004q\u0005]\u0017A\b;fgR$Um]2sS\n,\u0017\t^'j]&\u001b(\u000fU1si&$\u0018n\u001c8tQ\rI\u0014q[\u0001'i\u0016\u001cH\u000fR3tGJL'-Z+oI\u0016\u0014X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn]'jq\u0016$\u0007f\u0001\u001e\u0002X\u0006\u0019C/Z:u\t\u0016\u001c8M]5cKJ+\u0007o\u001c:u\u001fZ,'O]5eI\u0016t7i\u001c8gS\u001e\u001c\bfA\u001e\u0002X\u0006qC/Z:u\t\u0016\u001c8M]5cK\u0006sG\rT5tiR{\u0007/[2t/&$\bn\\;u\u0013:$XM\u001d8bYR{\u0007/[2tQ\ra\u0014q\u001b")
public class TopicCommandWithAdminClientTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private TopicCommand.AdminClientTopicService topicService;
    private AdminClient adminClient;
    private String testTopicName;
    private final TestName _testName;

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        int x$1 = 6;
        String x$2 = this.zkConnect();
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfigs$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfigs$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfigs$default$5();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfigs$default$6();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfigs$default$7();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfigs$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfigs$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfigs$default$10();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfigs$default$11();
        int x$13 = TestUtils$.MODULE$.createBrokerConfigs$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfigs$default$14();
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(x$1, x$2, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, (Map<Object, String>)x$3, x$13, x$14).map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    private TopicCommand.AdminClientTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.AdminClientTopicService x$1) {
        this.topicService = x$1;
    }

    private AdminClient adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(AdminClient x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        Exit$.MODULE$.setExitProcedure((Function2 & Serializable & scala.Serializable)(exitCode, exitMessage) -> TopicCommandWithAdminClientTest.mockExitProcedure$1(BoxesRunTime.unboxToInt((Object)exitCode), exitMessage, expected));
        try {
            Assertions$.MODULE$.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    public void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        this.assertExitCode(expected, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> options.checkArgs());
    }

    public void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    public void waitForTopicCreated(String topicName, int timeout) {
        long finishTime = System.currentTimeMillis() + (long)timeout;
        boolean result = false;
        while (System.currentTimeMillis() < finishTime || !result) {
            java.util.Set topics = (java.util.Set)this.adminClient().listTopics(new ListTopicsOptions().listInternal(true)).names().get();
            result = topics.contains(topicName);
            Thread.sleep(100L);
        }
        Assert.assertTrue((String)new StringBuilder(50).append("Topic ").append(topicName).append(" has not been created within the given ").append(timeout).append(" time").toString(), (boolean)result);
    }

    public int waitForTopicCreated$default$2() {
        return 10000;
    }

    @Before
    public void setup() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq(AdminClient.create((Properties)props));
        this.topicService_$eq(TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient()));
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(Random$.MODULE$.alphanumeric().take(10).mkString()).toString());
    }

    @After
    public void close() {
        block0: {
            if (this.topicService() == null) break block0;
            this.topicService().close();
        }
    }

    @Test
    public void testParseAssignment() {
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        scala.collection.immutable.Map expectedAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}));
        Assert.assertEquals((Object)expectedAssignment, (Object)actualAssignment);
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions$.MODULE$.intercept((Function0 & Serializable & scala.Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--config", "cleanup.policy=compact"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--delete-config", "cleanup.policy"})));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--topic", this.testTopicName(), "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"}));
        opts.checkArgs();
        Assert.assertTrue((boolean)opts.hasCreateOption());
        Assert.assertEquals((Object)this.brokerList(), (Object)opts.bootstrapServer().get());
        Assert.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()})));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"})));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assert.assertEquals((Object)BoxesRunTime.boxToInteger((int)1000), (Object)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateIfItAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)3L, (long)partitions.size());
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()), Buffer$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)32768)).toString(), "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", "testTopic"})));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
    }

    @Test
    public void testCreateWithUnspecifiedPartitionCount() {
        this.assertExitCode(1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--replication-factor", "1", "--topic", this.testTopicName()}))));
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
    }

    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
    }

    @Test
    public void testListTopicsWithWhitelist() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, 2), (List)new .colon.colon((Object)new NewTopic(topic2, 2, 2), (List)new .colon.colon((Object)new NewTopic(topic3, 2, 2), (List)Nil$.MODULE$)))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "kafka.*"}))));
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(topic1, 2, 2), (List)new .colon.colon((Object)new NewTopic("__consumer_offsets", 2, 2), (List)Nil$.MODULE$))).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, 2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, 2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"})));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Buffer$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, 2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 349));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        this.adminClient().createTopics(JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, 2), (List)Nil$.MODULE$)).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "-1", "--topic", this.testTopicName()}))), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 372));
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName()})));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--partitions", "1"}));
        TopicCommand.AdminClientTopicService topicService = TopicCommand.AdminClientTopicService$.MODULE$.apply(this.adminClient());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> topicService.alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
    }

    @Test
    public void testIfExistsAndIfNotExistsOptionsInvalidWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--alter", "--if-exists", "--topic", this.testTopicName(), "--partitions", "1"})));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--bootstrap-server", "server1:9092", "--create", "--if-not-exists", "--topic", this.testTopicName(), "--partitions", "1", "--replication-factor", "1"})));
    }

    @Test
    public void testCreateAlterTopicWithRackAware() {
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"rack2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)"rack1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"rack3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)"rack3")}));
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)alteredNumPartitions)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        assignment = (scala.collection.immutable.Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()}))).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            Seq replicas = (Seq)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)replicas);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsOriginal)).toString(), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitionsModified)).toString(), "--topic", this.testTopicName()}));
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.testTopicName(), 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", "__consumer_offsets"}));
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteIfExists() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
    }

    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, 2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName()}))));
        String[] rows = output.split("\n");
        Assert.assertEquals((long)3L, (long)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rows)).size());
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:2").toString());
    }

    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, 1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).asScala()).apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(testTopicDescription.partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$1(x$5))).get()).partition();
            this.killBroker(0);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)((TraversableOnce)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$3(x$6)))).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$4(this, partitionOnBroker0, BoxesRunTime.unboxToBoolean((Object)result), server)))), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Partition metadata for ").append(this.testTopicName()).append(" is not propagated").toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertTrue((boolean)rows[0].endsWith("Leader: none\tReplicas: 0\tIsr: "));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, 6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitions$1(x$9)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-replicated-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, 6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitions$1(x$10)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, 6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--at-min-isr-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertEquals((long)1L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic(underMinIsrTopic, 1, 6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, 6), new NewTopic(offlineTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Collections.singletonList(Predef$.MODULE$.int2Integer(0)))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(Predef$.MODULE$.int2Integer(0), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)})))})).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(x$11)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, underMinIsrTopic, 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
            String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--under-min-isr-partitions"}))));
            String[] rows = output.split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assert.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assert.assertEquals((long)2L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)))));
        Assert.assertTrue((String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString(), (boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()})));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"})));
        String output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--describe", "--exclude-internal"}))));
        Assert.assertTrue((String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString(), (boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        output = TestUtils$.MODULE$.grabConsoleOutput((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--list", "--exclude-internal"}))));
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    private static final Nothing$ mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$5) {
        return x$5.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaServer x$6) {
        return x$6.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandWithAdminClientTest $this, MetadataResponse.TopicMetadata x$7) {
        return x$7.topic().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponse.PartitionMetadata x$8) {
        return x$8.partition() == partitionOnBroker0$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1, boolean result, KafkaServer server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()}));
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)x$1, x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)topicMetadatas.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$7))).get()).partitionMetadata()).asScala()).find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$8)));
        Option option = testPartitionMetadata;
        if (None$.MODULE$.equals(option)) {
            throw Assertions$.MODULE$.fail("Partition metadata is not found in metadata cache", new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 539));
        }
        if (!(option instanceof Some)) throw new MatchError((Object)option);
        Some some = (Some)option;
        MetadataResponse.PartitionMetadata metadata = (MetadataResponse.PartitionMetadata)some.value();
        if (!result) return false;
        Errors errors = metadata.error();
        Errors errors2 = Errors.LEADER_NOT_AVAILABLE;
        if (errors != null) {
            if (!errors.equals(errors2)) return false;
            return true;
        }
        if (errors2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$1(KafkaServer x$9) {
        return x$9.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(KafkaServer x$10) {
        return x$10.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(KafkaServer x$11) {
        return x$11.config().brokerId() == 0;
    }

    public TopicCommandWithAdminClientTest() {
        RackAwareTest.$init$(this);
        this._testName = new TestName();
    }
}

