/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupCoordinator$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B#G\u00015CQ\u0001\u0016\u0001\u0005\u0002UCq\u0001\u0017\u0001C\u0002\u0013%\u0011\f\u0003\u0004c\u0001\u0001\u0006IA\u0017\u0005\bG\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019!\u0007\u0001)A\u00055\"9Q\r\u0001b\u0001\n\u00131\u0007B\u00026\u0001A\u0003%q\rC\u0004l\u0001\t\u0007I\u0011B-\t\r1\u0004\u0001\u0015!\u0003[\u0011\u001di\u0007A1A\u0005\neCaA\u001c\u0001!\u0002\u0013Q\u0006bB8\u0001\u0005\u0004%I!\u0017\u0005\u0007a\u0002\u0001\u000b\u0011\u0002.\t\u000fE\u0004!\u0019!C\u0005e\"1a\u000f\u0001Q\u0001\nMDqa\u001e\u0001C\u0002\u0013%!\u000f\u0003\u0004y\u0001\u0001\u0006Ia\u001d\u0005\b\u000f\u0002\u0001\r\u0011\"\u0003z\u0011\u001di\b\u00011A\u0005\nyDq!!\u0003\u0001A\u0003&!\u0010C\u0005\u0002\f\u0001\u0001\r\u0011\"\u0003\u0002\u000e!I\u0011Q\u0003\u0001A\u0002\u0013%\u0011q\u0003\u0005\t\u00037\u0001\u0001\u0015)\u0003\u0002\u0010!9\u0011Q\u0004\u0001\u0005\u0002\u0005}\u0001bBA\u001a\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003{\u0001A\u0011AA\u0010\u0011\u001d\t\t\u0005\u0001C\u0001\u0003?Aq!!\u0012\u0001\t\u0003\ty\u0002C\u0004\u0002J\u0001!\t!a\b\t\u000f\u00055\u0003\u0001\"\u0001\u0002 !9\u0011\u0011\u000b\u0001\u0005\u0002\u0005}\u0001bBA+\u0001\u0011\u0005\u0011q\u0004\u0005\b\u00033\u0002A\u0011AA\u0010\u0011\u001d\ti\u0006\u0001C\u0001\u0003?Aq!!\u0019\u0001\t\u0003\ty\u0002C\u0004\u0002f\u0001!\t!a\b\t\u000f\u0005M\u0004\u0001\"\u0001\u0002 !9\u0011q\u000f\u0001\u0005\u0002\u0005}\u0001bBA>\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003\u007f\u0002A\u0011AA\u0010\u0011\u001d\t\u0019\t\u0001C\u0001\u0003?Aq!a\"\u0001\t\u0003\ty\u0002C\u0004\u0002\n\u0002!\t!a\b\t\u000f\u00055\u0005\u0001\"\u0001\u0002 !9\u0011\u0011\u0013\u0001\u0005\u0002\u0005}\u0001bBAK\u0001\u0011\u0005\u0011q\u0004\u0005\b\u00033\u0003A\u0011AA\u0010\u0011\u001d\ti\n\u0001C\u0001\u0003?Aq!!)\u0001\t\u0003\ty\u0002C\u0004\u0002&\u0002!\t!a\b\t\u000f\u0005%\u0006\u0001\"\u0001\u0002 !9\u0011Q\u0016\u0001\u0005\u0002\u0005}\u0001bBAY\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003k\u0003A\u0011AA\u0010\u0011\u001d\tI\f\u0001C\u0001\u0003?Aq!!0\u0001\t\u0003\ty\u0002C\u0004\u0002B\u0002!\t!a\b\t\u000f\u0005\u0015\u0007\u0001\"\u0001\u0002 !9\u0011\u0011\u001a\u0001\u0005\u0002\u0005}\u0001bBAg\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003W\u0004A\u0011AA\u0010\u0011\u001d\ty\u000f\u0001C\u0001\u0003?Aq!a=\u0001\t\u0003\ty\u0002C\u0004\u0002x\u0002!\t!a\b\t\u000f\u0005m\b\u0001\"\u0001\u0002 !9\u0011q \u0001\u0005\u0002\u0005}\u0001b\u0002B\u0002\u0001\u0011%!Q\u0001\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0005E9%o\\;q\u001b\u0016$\u0018\rZ1uCR+7\u000f\u001e\u0006\u0003\u000f\"\u000bQa\u001a:pkBT!!\u0013&\u0002\u0017\r|wN\u001d3j]\u0006$xN\u001d\u0006\u0002\u0017\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001O!\ty%+D\u0001Q\u0015\u0005\t\u0016!B:dC2\f\u0017BA*Q\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012A\u0016\t\u0003/\u0002i\u0011AR\u0001\raJ|Go\\2pYRK\b/Z\u000b\u00025B\u00111\fY\u0007\u00029*\u0011QLX\u0001\u0005Y\u0006twMC\u0001`\u0003\u0011Q\u0017M^1\n\u0005\u0005d&AB*ue&tw-A\u0007qe>$xnY8m)f\u0004X\rI\u0001\bOJ|W\u000f]%e\u0003!9'o\\;q\u0013\u0012\u0004\u0013aD4s_V\u0004\u0018J\\:uC:\u001cW-\u00133\u0016\u0003\u001d\u00042a\u00145[\u0013\tI\u0007K\u0001\u0003T_6,\u0017\u0001E4s_V\u0004\u0018J\\:uC:\u001cW-\u00133!\u0003!iW-\u001c2fe&#\u0017!C7f[\n,'/\u00133!\u0003!\u0019G.[3oi&#\u0017!C2mS\u0016tG/\u00133!\u0003)\u0019G.[3oi\"{7\u000f^\u0001\fG2LWM\u001c;I_N$\b%\u0001\nsK\n\fG.\u00198dKRKW.Z8vi6\u001bX#A:\u0011\u0005=#\u0018BA;Q\u0005\rIe\u000e^\u0001\u0014e\u0016\u0014\u0017\r\\1oG\u0016$\u0016.\\3pkRl5\u000fI\u0001\u0011g\u0016\u001c8/[8o)&lWm\\;u\u001bN\f\u0011c]3tg&|g\u000eV5nK>,H/T:!+\u0005Q\bCA,|\u0013\tahIA\u0007He>,\b/T3uC\u0012\fG/Y\u0001\nOJ|W\u000f]0%KF$2a`A\u0003!\ry\u0015\u0011A\u0005\u0004\u0003\u0007\u0001&\u0001B+oSRD\u0001\"a\u0002\u0014\u0003\u0003\u0005\rA_\u0001\u0004q\u0012\n\u0014AB4s_V\u0004\b%\u0001\u0004nK6\u0014WM]\u000b\u0003\u0003\u001f\u00012aVA\t\u0013\r\t\u0019B\u0012\u0002\u000f\u001b\u0016l'-\u001a:NKR\fG-\u0019;b\u0003)iW-\u001c2fe~#S-\u001d\u000b\u0004\u007f\u0006e\u0001\"CA\u0004-\u0005\u0005\t\u0019AA\b\u0003\u001diW-\u001c2fe\u0002\nQa]3u+B$\u0012a \u0015\u00041\u0005\r\u0002\u0003BA\u0013\u0003_i!!a\n\u000b\t\u0005%\u00121F\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u0003[\t1a\u001c:h\u0013\u0011\t\t$a\n\u0003\r\t+gm\u001c:f\u0003i!Xm\u001d;DC:\u0014VMY1mC:\u001cWm\u00165f]N#\u0018M\u00197fQ\rI\u0012q\u0007\t\u0005\u0003K\tI$\u0003\u0003\u0002<\u0005\u001d\"\u0001\u0002+fgR\fq\u0005^3ti\u000e\u000bgNU3cC2\fgnY3XQ\u0016t7i\\7qY\u0016$\u0018N\\4SK\n\fG.\u00198dK\"\u001a!$a\u000e\u0002SQ,7\u000f^\"b]:|GOU3cC2\fgnY3XQ\u0016t\u0007K]3qCJLgn\u001a*fE\u0006d\u0017M\\2fQ\rY\u0012qG\u0001\u001ci\u0016\u001cHoQ1o]>$(+\u001a2bY\u0006t7-Z,iK:$U-\u00193)\u0007q\t9$\u0001\u0015uKN$8\u000b^1cY\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR\u0013\u0018M\\:ji&|g\u000eK\u0002\u001e\u0003o\t!\u0004^3tiN#\u0018M\u00197f)>$U-\u00193Ue\u0006t7/\u001b;j_:D3AHA\u001c\u0003M\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR\u0013\u0018M\\:ji&|g\u000eK\u0002 \u0003o\ta\u0005^3tiB\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a+p\t\u0016\fG\r\u0016:b]NLG/[8oQ\r\u0001\u0013qG\u0001(i\u0016\u001cH\u000f\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dKR{W)\u001c9usR\u0013\u0018M\\:ji&|g\u000eK\u0002\"\u0003o\t\u0011\u0004^3ti\u0016k\u0007\u000f^=U_\u0012+\u0017\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a!%a\u000e\u0002OQ,7\u000f^!xC&$\u0018N\\4SK\n\fG.\u00198dKR{7\u000b^1cY\u0016$&/\u00198tSRLwN\u001c\u0015\u0004G\u0005]\u0012A\t;fgR,U\u000e\u001d;z)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0004%\u0003o\tI'a\u001b\u0002\u0011\u0015D\b/Z2uK\u0012\u001c#!!\u001c\u0011\u0007m\u000by'C\u0002\u0002rq\u0013Q#\u00137mK\u001e\fGn\u0015;bi\u0016,\u0005pY3qi&|g.A\u0012uKN$8\u000b^1cY\u0016$vn\u0015;bE2,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007\u0015\n9$A\u0017uKN$X)\u001c9usR{\u0017i^1ji&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:DsAJA\u001c\u0003S\nY'A\u001euKN$\bK]3qCJLgn\u001a*fE\u0006d\u0017M\\2f)>\u0004&/\u001a9be&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:DsaJA\u001c\u0003S\nY'A\u0018uKN$\bK]3qCJLgn\u001a*fE\u0006d\u0017M\\2f)>\u001cF/\u00192mK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0004)\u0003o\tI'a\u001b\u0002sQ,7\u000f^!xC&$\u0018N\\4SK\n\fG.\u00198dKR{\u0017i^1ji&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds!KA\u001c\u0003S\nY'A\u0010uKN$H)Z1e)>$U-\u00193JY2,w-\u00197Ue\u0006t7/\u001b;j_:\f\u0011\u0005^3ti\u0012+\u0017\r\u001a+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:DsaKA\u001c\u0003S\nY'A\u0017uKN$H)Z1e)>\u0004&/\u001a9be&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:Ds\u0001LA\u001c\u0003S\nY'\u0001\u0017uKN$H)Z1e)>\fu/Y5uS:<'+\u001a2bY\u0006t7-Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\":Q&a\u000e\u0002j\u0005-\u0014A\u0005;fgR\u001cV\r\\3diB\u0013x\u000e^8d_2D3ALA\u001c\u0003\r\"Xm\u001d;TK2,7\r\u001e)s_R|7m\u001c7SC&\u001cXm]%g\u001d>lU-\u001c2feNDsaLA\u001c\u0003S\nY'A\u0016uKN$8+\u001a7fGR\u0004&o\u001c;pG>d7\t[8pg\u0016\u001c8i\\7qCRL'\r\\3Qe>$xnY8mQ\r\u0001\u0014qG\u0001\u0016i\u0016\u001cHoU;qa>\u0014Ho\u001d)s_R|7m\u001c7tQ\r\t\u0014qG\u0001\u0017i\u0016\u001cH/\u00138ji:+\u0007\u0010^$f]\u0016\u0014\u0018\r^5p]\"\u001a!'a\u000e\u0002AQ,7\u000f^%oSRtU\r\u001f;HK:,'/\u0019;j_:,U\u000e\u001d;z\u000fJ|W\u000f\u001d\u0015\u0004g\u0005]\u0012\u0001\u0005;fgR|eMZ:fi\u000e{W.\\5uQ\r!\u0014qG\u0001\u0018i\u0016\u001cHo\u00144gg\u0016$8i\\7nSR4\u0015-\u001b7ve\u0016D3!NA\u001c\u0003%\"Xm\u001d;PM\u001a\u001cX\r^\"p[6LGOR1jYV\u0014XmV5uQ\u0006sw\u000e\u001e5feB+g\u000eZ5oO\"\u001aa'a\u000e\u0002EQ,7\u000f^(gMN,GoQ8n[&$x+\u001b;i\u0003:|G\u000f[3s!\u0016tG-\u001b8hQ\r9\u0014qG\u0001+i\u0016\u001cHoQ8ogVlWM\u001d\"fCR\u001cHK]1og\u0006\u001cG/[8oC2|eMZ:fi\u000e{W.\\5uQ\rA\u0014qG\u0001)i\u0016\u001cH\u000f\u0016:b]N\f7\r^5p]\n+\u0017\r^:D_:\u001cX/\\3s\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004s\u0005]\u0012!\u000e;fgR$&/\u00198tC\u000e$\u0018n\u001c8bY\u000e{W.\\5u\u0013N\f%m\u001c:uK\u0012\fe\u000eZ\"p]N,X.\u001a:D_6l\u0017\u000e^,j]ND3AOA\u001c\u00035\"Xm\u001d;GC&dW\r\u001a+y]>3gm]3u\u0007>lW.\u001b;MK\u00064Xm\u001d(p!\u0016tG-\u001b8h'R\fG/\u001a\u0015\u0004w\u0005]\u0012\u0001\r;fgR\u0014V\r\u001d7bG\u0016<%o\\;q\u0013:\u001cH/\u00198dK^KG\u000f[#naRLxI]8va&s7\u000f^1oG\u0016LE\rK\u0004=\u0003o\tI'!5$\u0005\u0005M\u0007\u0003BAk\u0003KtA!a6\u0002b:!\u0011\u0011\\Ap\u001b\t\tYNC\u0002\u0002^2\u000ba\u0001\u0010:p_Rt\u0014\"A)\n\u0007\u0005\r\b+A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u001d\u0018\u0011\u001e\u0002\u0019\u00132dWmZ1m\u0003J<W/\\3oi\u0016C8-\u001a9uS>t'bAAr!\u0006iC/Z:u%\u0016\u0004H.Y2f\u000fJ|W\u000f]%ogR\fgnY3XSRDgj\u001c8Fq&\u001cH/\u001b8h\u001b\u0016l'-\u001a:)\u000fu\n9$!\u001b\u0002R\u0006AB/Z:u%\u0016\u0004H.Y2f\u000fJ|W\u000f]%ogR\fgnY3)\u0007y\n9$\u0001\fuKN$\u0018J\u001c<pW\u0016Tu.\u001b8DC2d'-Y2lQ\ry\u0014qG\u0001\u001ai\u0016\u001cHOT8u\u0013:4xn[3K_&t7)\u00197mE\u0006\u001c7\u000eK\u0002A\u0003o\ta\u0003^3ti&sgo\\6f'ft7mQ1mY\n\f7m\u001b\u0015\u0004\u0003\u0006]\u0012!\u0007;fgRtu\u000e^%om>\\WmU=oG\u000e\u000bG\u000e\u001c2bG.D3AQA\u001c\u0003-\t7o]3siN#\u0018\r^3\u0015\u000b}\u00149A!\u0003\t\u000b\u001d\u001b\u0005\u0019\u0001>\t\u000f\t-1\t1\u0001\u0003\u000e\u0005YA/\u0019:hKR\u001cF/\u0019;f!\r9&qB\u0005\u0004\u0005#1%AC$s_V\u00048\u000b^1uK\u0006\trN\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\u0015\t\t]!1\u0005\t\u0005\u00053\u0011y\"\u0004\u0002\u0003\u001c)\u0019!Q\u0004&\u0002\r\r|W.\\8o\u0013\u0011\u0011\tCa\u0007\u0003#=3gm]3u\u0003:$W*\u001a;bI\u0006$\u0018\rC\u0004\u0003&\u0011\u0003\rAa\n\u0002\r=4gm]3u!\ry%\u0011F\u0005\u0004\u0005W\u0001&\u0001\u0002'p]\u001e\u0004")
public class GroupMetadataTest {
    private final String protocolType;
    private final String groupId;
    private final Some<String> groupInstanceId = new Some((Object)"groupInstanceId");
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;
    private MemberMetadata member = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupId() {
        return this.groupId;
    }

    private Some<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    private MemberMetadata member() {
        return this.member;
    }

    private void member_$eq(MemberMetadata x$1) {
        this.member = x$1;
    }

    @Before
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
        this.member_$eq(new MemberMetadata(this.memberId(), this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$))));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assert.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assert.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToStableIllegalTransition() {
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        try {
            this.group().transitionTo((GroupState)Stable$.MODULE$);
            Assert.fail((String)"should have failed due to illegal transition");
        }
        catch (IllegalStateException illegalStateException) {}
    }

    @Test(expected=IllegalStateException.class)
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = member;
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        Assert.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$2 = this.group();
        MemberMetadata x$3 = otherMember;
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(x$3, x$4);
        Assert.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$3 = this.group();
        MemberMetadata x$5 = lastMember;
        Function1 x$6 = qual$3.add$default$2();
        qual$3.add(x$5, x$6);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test(expected=IllegalStateException.class)
    public void testSelectProtocolRaisesIfNoMembers() {
        this.group().selectProtocol();
        Assert.fail();
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = member;
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        GroupMetadata qual$2 = this.group();
        MemberMetadata x$3 = otherMember;
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(x$3, x$4);
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, this.groupId(), this.groupInstanceId(), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)));
        GroupMetadata qual$2 = this.group();
        MemberMetadata x$3 = otherMember;
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(x$3, x$4);
        Assert.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assert.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testInitNextGeneration() {
        this.member().supportedProtocols_$eq((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(this.member(), (Function1 & Serializable & scala.Serializable)x$1 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$1);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertEquals((Object)"roundrobin", (Object)this.group().protocolOrNull());
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assert.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assert.assertEquals((long)0L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assert.assertEquals((long)1L, (long)this.group().generationId());
        Assert.assertNull((Object)this.group().protocolOrNull());
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L);
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L);
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L);
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assert.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assert.assertTrue((boolean)this.group().hasOffsets());
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assert.assertFalse((boolean)this.group().hasOffsets());
        Assert.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceGroupInstanceWithEmptyGroupInstanceId() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assert.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assert.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, Option$.MODULE$.empty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
    }

    @Test
    public void testReplaceGroupInstance() {
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1 & Serializable & scala.Serializable)joinGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$1(joinAwaitingMemberFenced, joinGroupResult);
            return BoxedUnit.UNIT;
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.member().awaitingSyncCallback_$eq((Function1 & Serializable & scala.Serializable)syncGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$2(syncAwaitingMemberFenced, syncGroupResult);
            return BoxedUnit.UNIT;
        });
        this.group().addStaticMember(this.groupInstanceId(), this.memberId());
        Assert.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assert.assertEquals((Object)this.memberId(), (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceGroupInstance(this.memberId(), newMemberId, this.groupInstanceId());
        Assert.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assert.assertEquals((Object)newMemberId, (Object)this.group().getStaticMemberId(this.groupInstanceId()));
        Assert.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assert.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(this.member(), (Function1 & Serializable & scala.Serializable)x$2 -> {
            invoked.elem = true;
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(this.member(), GroupCoordinator$.MODULE$.joinError(this.member().memberId(), Errors.NONE));
        Assert.assertTrue((boolean)invoked.elem);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(this.member(), GroupCoordinator$.MODULE$.joinError(this.member().memberId(), Errors.NONE));
        Assert.assertFalse((boolean)this.member().isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        this.member().awaitingSyncCallback_$eq((Function1 & Serializable & scala.Serializable)x$3 -> {
            GroupMetadataTest.$anonfun$testInvokeSyncCallback$1(x$3);
            return BoxedUnit.UNIT;
        });
        boolean invoked = this.group().maybeInvokeSyncCallback(this.member(), new SyncGroupResult((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), Errors.NONE));
        Assert.assertTrue((boolean)invoked);
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        GroupMetadata qual$1 = this.group();
        MemberMetadata x$1 = this.member();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(x$1, x$2);
        boolean invoked = this.group().maybeInvokeSyncCallback(this.member(), new SyncGroupResult((byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte()), Errors.NONE));
        Assert.assertFalse((boolean)invoked);
        Assert.assertFalse((boolean)this.member().isAwaitingSync());
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        Set states = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}));
        Set otherStates = (Set)states.$minus((Object)targetState);
        otherStates.foreach((Function1 & Serializable & scala.Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", Time.SYSTEM.milliseconds());
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$1(BooleanRef joinAwaitingMemberFenced$1, JoinGroupResult joinGroupResult) {
        Errors errors = joinGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$2(BooleanRef syncAwaitingMemberFenced$1, SyncGroupResult syncGroupResult) {
        Errors errors = syncGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testInvokeSyncCallback$1(SyncGroupResult x$3) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assert.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupId = "groupId";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

