/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.MockTime;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3AAD\b\u0001-!)Q\u0004\u0001C\u0001=!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0003BB\u0015\u0001A\u0003%1\u0005C\u0003+\u0001\u0011\u00051\u0006C\u00039\u0001\u0011\u00051\u0006C\u0003;\u0001\u0011\u00051\u0006C\u0003G\u0001\u0011\u00051\u0006C\u0003I\u0001\u0011\u00051\u0006C\u0003K\u0001\u0011\u00051\u0006C\u0003M\u0001\u0011\u00051\u0006C\u0003O\u0001\u0011\u00051\u0006C\u0003Q\u0001\u0011\u00051\u0006C\u0003M\u0001\u0011%!KA\fUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018\rV3ti*\u0011\u0001#E\u0001\fiJ\fgn]1di&|gN\u0003\u0002\u0013'\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0003\u0001]\u0001\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\u0010\u0003\u0011!\u0018.\\3\u0016\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R!AJ\n\u0002\u000bU$\u0018\u000e\\:\n\u0005!*#\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002'Q,7\u000f^%oSRL\u0017\r\\5{K\u0016\u0003xn\u00195\u0015\u00031\u0002\"\u0001G\u0017\n\u00059J\"\u0001B+oSRD#\u0001\u0002\u0019\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014!\u00026v]&$(\"A\u001b\u0002\u0007=\u0014x-\u0003\u00028e\t!A+Z:u\u0003M!Xm\u001d;O_Jl\u0017\r\\#q_\u000eD')^7qQ\t)\u0001'\u0001\u0015uKN$()^7q\u000bB|7\r\u001b(pi\u0006cGn\\<fI&3W\t]8dQN,\u0005\u0010[1vgR,G\r\u000b\u0003\u0007aqj\u0014\u0001C3ya\u0016\u001cG/\u001a3$\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\t1\fgn\u001a\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)\u0005IA\u000bJY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8\u0002KQ,7\u000f\u001e$f]\u000e,\u0007K]8ek\u000e,'/\u00114uKJ,\u0005o\\2ig\u0016C\b.Y;ti\u0016$\u0007FA\u00041\u00031\"Xm\u001d;GK:\u001cW\r\u0015:pIV\u001cWM\u001d(pi\u0006cGn\\<fI&3\u0017\n^,pk2$wJ^3sM2|w\u000f\u000b\u0003\taqj\u0014\u0001\u0006;fgR\u0014v\u000e^1uKB\u0013x\u000eZ;dKJLE\r\u000b\u0002\na\u0005\u0011C/Z:u%>$\u0018\r^3Qe>$WoY3s\u0013\u0012Len\u00148h_&twm\u0015;bi\u0016DCA\u0003\u0019={\u00059C/Z:u%>$\u0018\r^3Qe>$WoY3s\u0013\u0012Le\u000e\u0015:fa\u0006\u0014X-\u00112peR\u001cF/\u0019;fQ\u0011Y\u0001\u0007P\u001f\u0002QQ,7\u000f\u001e*pi\u0006$X\r\u0015:pIV\u001cWM]%e\u0013:\u0004&/\u001a9be\u0016\u001cu.\\7jiN#\u0018\r^3)\t1\u0001D(\u0010\u000b\u0003YMCQ\u0001V\u0007A\u0002U\u000bQa\u001d;bi\u0016\u0004\"\u0001\t,\n\u0005]{!\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0001")
public class TransactionMetadataTest {
    private final MockTime time = new MockTime();

    public MockTime time() {
        return this.time;
    }

    @Test
    public void testInitializeEpoch() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = -1;
        String x$1 = transactionalId;
        long x$2 = producerId;
        short x$3 = producerEpoch;
        int x$4 = 30000;
        Empty$ x$5 = Empty$.MODULE$;
        Set x$6 = Set$.MODULE$.empty();
        long x$7 = this.time().milliseconds();
        long x$8 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, (TransactionState)x$5, x$6, x$8, x$7);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareIncrementProducerEpoch(30000, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)producerId, (long)txnMetadata.producerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
    }

    @Test
    public void testNormalEpochBump() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = (short)735;
        String x$1 = transactionalId;
        long x$2 = producerId;
        short x$3 = producerEpoch;
        int x$4 = 30000;
        Empty$ x$5 = Empty$.MODULE$;
        Set x$6 = Set$.MODULE$.empty();
        long x$7 = this.time().milliseconds();
        long x$8 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, (TransactionState)x$5, x$6, x$8, x$7);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareIncrementProducerEpoch(30000, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)producerId, (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
    }

    @Test(expected=IllegalStateException.class)
    public void testBumpEpochNotAllowedIfEpochsExhausted() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = (short)32766;
        String x$1 = transactionalId;
        long x$2 = producerId;
        short x$3 = producerEpoch;
        int x$4 = 30000;
        Empty$ x$5 = Empty$.MODULE$;
        Set x$6 = Set$.MODULE$.empty();
        long x$7 = this.time().milliseconds();
        long x$8 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, (TransactionState)x$5, x$6, x$8, x$7);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareIncrementProducerEpoch(30000, this.time().milliseconds());
    }

    @Test
    public void testFenceProducerAfterEpochsExhausted() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = (short)32766;
        String x$1 = transactionalId;
        long x$2 = producerId;
        short x$3 = producerEpoch;
        int x$4 = 30000;
        Ongoing$ x$5 = Ongoing$.MODULE$;
        Set x$6 = Set$.MODULE$.empty();
        long x$7 = this.time().milliseconds();
        long x$8 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, (TransactionState)x$5, x$6, x$8, x$7);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        TxnTransitMetadata fencingTransitMetadata = txnMetadata.prepareFenceProducerEpoch();
        Assert.assertEquals((long)32767L, (long)fencingTransitMetadata.producerEpoch());
        Assert.assertEquals((Object)new Some((Object)PrepareEpochFence$.MODULE$), (Object)txnMetadata.pendingState());
        txnMetadata.pendingState_$eq((Option)None$.MODULE$);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)producerId, (long)transitMetadata.producerId());
    }

    @Test(expected=IllegalStateException.class)
    public void testFenceProducerNotAllowedIfItWouldOverflow() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = Short.MAX_VALUE;
        String x$1 = transactionalId;
        long x$2 = producerId;
        short x$3 = producerEpoch;
        int x$4 = 30000;
        Ongoing$ x$5 = Ongoing$.MODULE$;
        Set x$6 = Set$.MODULE$.empty();
        long x$7 = this.time().milliseconds();
        long x$8 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, (TransactionState)x$5, x$6, x$8, x$7);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareFenceProducerEpoch();
    }

    @Test
    public void testRotateProducerId() {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = (short)32766;
        String x$1 = transactionalId;
        long x$2 = producerId;
        short x$3 = producerEpoch;
        int x$4 = 30000;
        Empty$ x$5 = Empty$.MODULE$;
        Set x$6 = Set$.MODULE$.empty();
        long x$7 = this.time().milliseconds();
        long x$8 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, (TransactionState)x$5, x$6, x$8, x$7);
        long newProducerId = 9893L;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)newProducerId, (long)txnMetadata.producerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInOngoingState() {
        this.testRotateProducerIdInOngoingState((TransactionState)Ongoing$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInPrepareAbortState() {
        this.testRotateProducerIdInOngoingState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInPrepareCommitState() {
        this.testRotateProducerIdInOngoingState((TransactionState)PrepareCommit$.MODULE$);
    }

    private void testRotateProducerIdInOngoingState(TransactionState state) {
        String transactionalId = "txnlId";
        long producerId = 23423L;
        short producerEpoch = (short)32766;
        String x$1 = transactionalId;
        long x$2 = producerId;
        short x$3 = producerEpoch;
        int x$4 = 30000;
        TransactionState x$5 = state;
        Set x$6 = Set$.MODULE$.empty();
        long x$7 = this.time().milliseconds();
        long x$8 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$7);
        long newProducerId = 9893L;
        txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds());
    }
}

