/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.LogUtils$;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Logging;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t=c\u0001\u0002\u00192\u0001YBQa\u0011\u0001\u0005\u0002\u0011Cqa\u0012\u0001C\u0002\u0013\u0005\u0001\n\u0003\u0004R\u0001\u0001\u0006I!\u0013\u0005\b%\u0002\u0011\r\u0011\"\u0001I\u0011\u0019\u0019\u0006\u0001)A\u0005\u0013\"9A\u000b\u0001b\u0001\n\u0003)\u0006BB1\u0001A\u0003%a\u000bC\u0004c\u0001\t\u0007I\u0011A2\t\r)\u0004\u0001\u0015!\u0003e\u0011\u001dY\u0007A1A\u0005\u00021Da\u0001\u001d\u0001!\u0002\u0013i\u0007bB9\u0001\u0005\u0004%\tA\u001d\u0005\u0007m\u0002\u0001\u000b\u0011B:\t\u000f]\u0004!\u0019!C\u0001q\"9\u0011\u0011\u0002\u0001!\u0002\u0013IhABA\u0006\u0001\u0001\ti\u0001\u0003\u0007\u0002\u0016A\u0011\t\u0011)A\u0005\u0003/\ty\u0003\u0003\u0007\u00022A\u0011\t\u0011)A\u0005\u0003g\ty\u0004\u0003\u0007\u0002BA\u0011\t\u0011)A\u0005\u0003\u0007\ny\u0005\u0003\u0004D!\u0011\u0005\u0011\u0011\u000b\u0005\b\u0003;\u0002B\u0011IA0\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!a\"\u0001\t\u0003\t\t\bC\u0004\u0002\u0012\u0002!\t!!\u001d\t\u000f\u0005U\u0005\u0001\"\u0001\u0002r!9\u0011\u0011\u0014\u0001\u0005\u0002\u0005E\u0004bBAO\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003C\u0003A\u0011AA9\u0011\u001d\t)\u000b\u0001C\u0001\u0003cBq!!+\u0001\t\u0003\t\t\bC\u0004\u0002.\u0002!\t!!\u001d\t\u000f\u0005E\u0006\u0001\"\u0001\u0002r!9\u0011Q\u0017\u0001\u0005\u0002\u0005E\u0004bBA]\u0001\u0011\u0005\u0011\u0011\u000f\u0005\b\u0003{\u0003A\u0011AA9\u0011\u001d\t\t\r\u0001C\u0001\u0003cBq!!2\u0001\t\u0003\t\t\bC\u0004\u0002J\u0002!\t!!\u001d\t\u000f\u00055\u0007\u0001\"\u0001\u0002r!9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0007bBAi\u0001\u0011%\u0011q\u001b\u0005\n\u0003O\u0004\u0011\u0013!C\u0005\u0003SDq!a@\u0001\t\u0013\u0011\t\u0001C\u0005\u0003\u001c\u0001\t\n\u0011\"\u0003\u0003\u001e!9!\u0011\u0005\u0001\u0005\n\t\r\u0002\"\u0003B\u0017\u0001E\u0005I\u0011\u0002B\u0018\u0011\u001d\u0011\u0019\u0004\u0001C\u0005\u0005k\u0011Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u00023g\u0005\u0019An\\4\u000b\u0003Q\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001ou\u0002\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0007C\u0001 B\u001b\u0005y$B\u0001!4\u0003\u0015)H/\u001b7t\u0013\t\u0011uHA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005)\u0005C\u0001$\u0001\u001b\u0005\t\u0014A\u0002;na\u0012K'/F\u0001J!\tQu*D\u0001L\u0015\taU*\u0001\u0002j_*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005\u00111\u0015\u000e\\3\u0002\u000fQl\u0007\u000fR5sA\u00051An\\4ESJ\fq\u0001\\8h\t&\u0014\b%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003Y\u0003\"aV0\u000e\u0003aS!!\u0017.\u0002\r\r|W.\\8o\u0015\t!4L\u0003\u0002];\u00061\u0011\r]1dQ\u0016T\u0011AX\u0001\u0004_J<\u0017B\u00011Y\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\tY><\u0007K]8qgV\tA\r\u0005\u0002fQ6\taM\u0003\u0002h\u001b\u0006!Q\u000f^5m\u0013\tIgM\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0002\\8h!J|\u0007o\u001d\u0011\u0002\u00131|wmQ8oM&<W#A7\u0011\u0005\u0019s\u0017BA82\u0005%aunZ\"p]\u001aLw-\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\nA\u0001^5nKV\t1\u000f\u0005\u0002?i&\u0011Qo\u0010\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005\u00112\r\\3b]\u0016\u00148\t[3dWB|\u0017N\u001c;t+\u0005I\b#\u0002>\u0000-\u0006\rQ\"A>\u000b\u0005ql\u0018aB7vi\u0006\u0014G.\u001a\u0006\u0003}f\n!bY8mY\u0016\u001cG/[8o\u0013\r\t\ta\u001f\u0002\u0004\u001b\u0006\u0004\bc\u0001\u001d\u0002\u0006%\u0019\u0011qA\u001d\u0003\t1{gnZ\u0001\u0014G2,\u0017M\\3s\u0007\",7m\u001b9pS:$8\u000f\t\u0002\u0016\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014Xj\\2l'\r\u0001\u0012q\u0002\t\u0004\r\u0006E\u0011bAA\nc\t\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\u0002\u000f1|w\rR5sgB)\u0011\u0011DA\u0015\u0013:!\u00111DA\u0013\u001d\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011k\u00051AH]8pizJ\u0011AO\u0005\u0004\u0003OI\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003W\tiCA\u0002TKFT1!a\n:\u0013\u0011\t)\"!\u0005\u0002\t1|wm\u001d\t\u0007}\u0005Ub+!\u000f\n\u0007\u0005]rH\u0001\u0003Q_>d\u0007c\u0001$\u0002<%\u0019\u0011QH\u0019\u0003\u00071{w-\u0003\u0003\u00022\u0005E\u0011\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G\u000e\u0005\u0003\u0002F\u0005-SBAA$\u0015\r\tIeM\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u00055\u0013q\t\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\n\t\u0005\u0005\u0013\u0011\u0003\u000b\t\u0003'\n9&!\u0017\u0002\\A\u0019\u0011Q\u000b\t\u000e\u0003\u0001Aq!!\u0006\u0015\u0001\u0004\t9\u0002C\u0004\u00022Q\u0001\r!a\r\t\u000f\u0005\u0005C\u00031\u0001\u0002D\u0005)\u0012\r\u001c7DY\u0016\fg.\u001a:DQ\u0016\u001c7\u000e]8j]R\u001cXCAA1!\u001d\t\u0019'a\u001bW\u0003\u0007qA!!\u001a\u0002hA\u0019\u0011QD\u001d\n\u0007\u0005%\u0014(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\tiGC\u0002\u0002je\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003g\u00022\u0001OA;\u0013\r\t9(\u000f\u0002\u0005+:LG\u000fK\u0002\u0017\u0003w\u0002B!! \u0002\u00046\u0011\u0011q\u0010\u0006\u0004\u0003\u0003k\u0016!\u00026v]&$\u0018\u0002BAC\u0003\u007f\u0012Q!\u00114uKJ\f\u0001\b^3ti\u001e\u0013\u0018M\u0019$jYRD\u0017.Z:u\u0007>l\u0007/Y2uK\u0012dun\u001a*fiV\u0014hn\u001d'pO^KG\u000f\u001b#jeRLWm\u001d;SCRLw\u000eK\u0002\u0018\u0003\u0017\u0003B!! \u0002\u000e&!\u0011qRA@\u0005\u0011!Vm\u001d;\u0002sQ,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001eLuM\\8sKN,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]ND3\u0001GAF\u0003a\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001c\u0018J\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]ND3!GAF\u0003Q#Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001c(i\u001c;i\u0013:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\\:B]\u0012,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]ND3AGAF\u0003\u0011#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI:{GoQ8og&$WM]\"mK\u0006tW\u000f\u001d)pY&\u001c\u0017\u0010R3mKR,Gj\\4tQ\rY\u00121R\u0001Ii\u0016\u001cH\u000fT8hg^KG\u000f[*fO6,g\u000e^:U_\u0012+G.\u001a;f'\"|W\u000f\u001c3D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;EK2,G/\u001a'pOND3\u0001HAF\u0003\t#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI\u000e{gn]5eKJ\u001cE.Z1okB\u0004v\u000e\\5ds\u000e{W\u000e]1di2{wm\u001d\u0015\u0004;\u0005-\u0015a\u000b;fgRdunZ:V]\u0012,'o\u00117fC:,\b/\u00138fY&<\u0017N\u00197f\r>\u00148i\\7qC\u000e$\u0018n\u001c8)\u0007y\tY)\u0001\u0015uKN$8i\u001c8dkJ\u0014XM\u001c;M_\u001e\u001cE.Z1okB\fe\u000e\u001a'pOR\u0013XO\\2bi&|g\u000eK\u0002 \u0003\u0017\u000b\u0001\u0006^3ti\u000e{gnY;se\u0016tG\u000fT8h\u00072,\u0017M\\;q\u0003:$Gk\u001c9jG\u0012+G.\u001a;j_:D3\u0001IAF\u0003\t#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI:{GoQ8og&$WM]+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004C\u0005-\u0015a\u0007;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s\u001d>tW\rK\u0002#\u0003\u0017\u000b1\u0004^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001chi\u001c:US6,\u0007fA\u0012\u0002\f\u0006\u0001C/Z:u\u00072,\u0017M\\1cY\u0016|eMZ:fiN4uN]*i_J$H+[7fQ\r!\u00131R\u0001+i\u0016\u001cH/\u00168eK\u000eLG-\u001a3Ue\u0006t7/Y2uS>t\u0017\r\u001c#bi\u0006tu\u000e^\"mK\u0006t\u0017M\u00197fQ\r)\u00131R\u0001\u0011i\u0016\u001cH\u000fR8oK\u000ecW-\u00198j]\u001eD3AJAF\u0003A!Xm\u001d;E_:,G)\u001a7fi&tw\rK\u0002(\u0003\u0017\u000bAc\u0019:fCR,7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014H\u0003BA\b\u0003+DaA\r\u0015A\u0002\u0005eBCBA\b\u00033\fi\u000eC\u0004\u0002\\&\u0002\r!a\r\u0002\tA|w\u000e\u001c\u0005\n\u0003?L\u0003\u0013!a\u0001\u0003C\fa\u0001^8N_\u000e\\\u0007c\u0001\u001d\u0002d&\u0019\u0011Q]\u001d\u0003\u000f\t{w\u000e\\3b]\u0006q2M]3bi\u0016\u001cE.Z1oKJl\u0015M\\1hKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003WTC!!9\u0002n.\u0012\u0011q\u001e\t\u0005\u0003c\fY0\u0004\u0002\u0002t*!\u0011Q_A|\u0003%)hn\u00195fG.,GMC\u0002\u0002zf\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti0a=\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0005de\u0016\fG/\u001a'pORA\u0011\u0011\bB\u0002\u0005\u001b\u00119\u0002C\u0004\u0003\u0006-\u0002\rAa\u0002\u0002\u0017M,w-\\3oiNK'0\u001a\t\u0004q\t%\u0011b\u0001B\u0006s\t\u0019\u0011J\u001c;\t\u000f\t=1\u00061\u0001\u0003\u0012\u0005i1\r\\3b]V\u0004\bk\u001c7jGf\u0004B!a\u0019\u0003\u0014%!!QCA7\u0005\u0019\u0019FO]5oO\"I!\u0011D\u0016\u0011\u0002\u0003\u0007!qA\u0001\u000eg\u0016<W.\u001a8ug\u000e{WO\u001c;\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\t}!\u0006\u0002B\u0004\u0003[\fq!\\1lK2{w\r\u0006\u0004\u0002:\t\u0015\"\u0011\u0006\u0005\t\u0005Oi\u0003\u0013!a\u0001\u0013\u0006\u0019A-\u001b:\t\r\t-R\u00061\u0001n\u0003\u0019\u0019wN\u001c4jO\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tE\"fA%\u0002n\u00069!/Z2pe\u0012\u001cH\u0003\u0003B\u001c\u0005\u0007\u00129Ea\u0013\u0011\t\te\"qH\u0007\u0003\u0005wQ1A!\u0010Y\u0003\u0019\u0011XmY8sI&!!\u0011\tB\u001e\u00055iU-\\8ssJ+7m\u001c:eg\"9!QI\u0018A\u0002\t\u001d\u0011aA6fs\"9!\u0011J\u0018A\u0002\t\u001d\u0011!\u0002<bYV,\u0007b\u0002B'_\u0001\u0007\u00111A\u0001\ni&lWm\u001d;b[B\u0004")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final TopicPartition topicPartition;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManagerTest logCleanerManagerTest = this;
        synchronized (logCleanerManagerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)log2, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.markPartitionUncleanable(log2.dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)log3, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp3, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assert.assertEquals((Object)log3, (Object)filthiestLog.log());
        Assert.assertEquals((Object)tp3, (Object)filthiestLog.topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log1 = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), 1);
        Log log2 = this.createLog(records.sizeInBytes() * 10, LogConfig$.MODULE$.Compact(), 2);
        Log log3 = this.createLog(records.sizeInBytes() * 15, LogConfig$.MODULE$.Compact(), 3);
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        TopicPartition tp1 = new TopicPartition("wishing well", 0);
        logs.put((Object)tp1, (Object)log1);
        TopicPartition tp2 = new TopicPartition("wishing well", 1);
        logs.put((Object)tp2, (Object)log2);
        TopicPartition tp3 = new TopicPartition("wishing well", 2);
        logs.put((Object)tp3, (Object)log3);
        LogCleanerManagerMock cleanerManager = (LogCleanerManagerMock)this.createCleanerManager((Pool<TopicPartition, Log>)logs, true);
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)0L));
        this.cleanerCheckpoints().put((Object)tp2, (Object)BoxesRunTime.boxToLong((long)1L));
        this.cleanerCheckpoints().put((Object)tp3, (Object)BoxesRunTime.boxToLong((long)15L));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(log3.dir().getParent(), tp3);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertTrue((boolean)filthiestLog.isEmpty());
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.onHighWatermarkIncremented(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog.size());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), log.config().segmentSize());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), log.config().retentionMs());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 0 logs ready to be compacted", (long)0L, (long)Option$.MODULE$.option2Iterable(cleanable).size());
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable & scala.Serializable)x$1 -> (TopicPartition)x$1._1(), Iterable$.MODULE$.canBuildFrom()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assert.assertEquals((String)"should have 1 logs ready to be compacted", (long)1L, (long)Option$.MODULE$.option2Iterable(cleanable2).size());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig config2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        log.config_$eq(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)deletableLog2.size());
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{((LogToClean)cleanable2.get()).topicPartition()})));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)deletableLog3.size());
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{log.topicPartition()})));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$2 -> (TopicPartition)x$2._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Delete(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable & scala.Serializable)x$3 -> (TopicPartition)x$3._1(), Iterable$.MODULE$.canBuildFrom()));
        Assert.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, LogConfig$.MODULE$.Compact(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        this.time().sleep(compactionLag + 1);
        scala.collection.immutable.Map lastClean = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)producerEpoch, (int)(sequence + 2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.onHighWatermarkIncremented(3L);
        this.time().sleep(compactionLag + 1);
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._2$mcJ$sp());
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)this.time().milliseconds(), (long)producerId, (short)producerEpoch, (EndTransactionMarker)new EndTransactionMarker(ControlRecordType.ABORT, 15)), 0, false, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.onHighWatermarkIncremented(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)3L, (long)cleanableOffsets._2$mcJ$sp());
        this.time().sleep(compactionLag + 1);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, this.topicPartition(), (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)0L))})), this.time().milliseconds());
        Assert.assertEquals((long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((long)4L, (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L);
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assert.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()).nonEmpty());
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records.sizeInBytes() * 5, new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString(), this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp}))), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("LogCleanerManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assert.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    private LogCleanerManager createCleanerManager(Log log) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)this.topicPartition(), (Object)log);
        return this.createCleanerManager((Pool<TopicPartition, Log>)logs, this.createCleanerManager$default$2());
    }

    private LogCleanerManager createCleanerManager(Pool<TopicPartition, Log> pool, boolean toMock) {
        return toMock ? new LogCleanerManagerMock((Seq<File>)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null) : new LogCleanerManager((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{this.logDir()}), pool, null);
    }

    private boolean createCleanerManager$default$2() {
        return false;
    }

    private Log createLog(int segmentSize, String cleanupPolicy, int segmentsCount) {
        File partitionDir;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.double2Double(0.05));
        LogConfig config = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File x$1 = partitionDir = new File(this.logDir(), "log-0");
        LogConfig x$2 = config;
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        Log log = Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), segmentsCount).foreach((Function1 & Serializable & scala.Serializable)i -> LogCleanerManagerTest.$anonfun$createLog$1(this, log, BoxesRunTime.unboxToInt((Object)i)));
        return log;
    }

    private int createLog$default$3() {
        return 0;
    }

    private Log makeLog(File dir, LogConfig config) {
        File x$1 = dir;
        LogConfig x$2 = config;
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 3600000;
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private MemoryRecords records(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(timestamp, ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public static final /* synthetic */ SimpleRecord $anonfun$createLog$2(LogCleanerManagerTest $this, int endOffset$1, LongRef lastTimestamp$1, int offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public static final /* synthetic */ LogSegment $anonfun$createLog$1(LogCleanerManagerTest $this, Log log$2, int i) {
        int startOffset = i * 10;
        int endOffset = startOffset + 10;
        LogSegment segment = LogUtils$.MODULE$.createSegment(startOffset, $this.logDir(), LogUtils$.MODULE$.createSegment$default$3(), LogUtils$.MODULE$.createSegment$default$4());
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startOffset), endOffset).map((Function1 & Serializable & scala.Serializable)offset -> LogCleanerManagerTest.$anonfun$createLog$2($this, endOffset, lastTimestamp, BoxesRunTime.unboxToInt((Object)offset)), IndexedSeq$.MODULE$.canBuildFrom());
        segment.append((long)endOffset, lastTimestamp.elem, (long)endOffset, MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class)))));
        return log$2.addSegment(segment);
    }

    public LogCleanerManagerTest() {
        Logging.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.topicPartition = new TopicPartition("log", 0);
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap(Predef$.MODULE$.$conforms());
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

