/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Base64;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import kafka.utils.CoreUtils$;
import kafka.utils.CoreUtilsTest;
import kafka.utils.CoreUtilsTest$TestException$2$;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0005\n\u0001/!)!\u0005\u0001C\u0001G!9Q\u0005\u0001b\u0001\n\u00031\u0003BB\u0019\u0001A\u0003%q\u0005C\u00033\u0001\u0011\u00051\u0007C\u0003A\u0001\u0011\u00051\u0007C\u0003C\u0001\u0011\u00051\u0007C\u0003E\u0001\u0011\u00051\u0007C\u0003G\u0001\u0011\u00051\u0007C\u0003I\u0001\u0011\u00051\u0007C\u0003K\u0001\u0011\u00051\u0007C\u0003M\u0001\u0011\u00051\u0007C\u0003O\u0001\u0011\u00051\u0007C\u0003Q\u0001\u0011\u00051\u0007C\u0003S\u0001\u0011\u00051\u0007C\u0003U\u0001\u0011\u00051\u0007C\u0003W\u0001\u0011\u00051GA\u0007D_J,W\u000b^5mgR+7\u000f\u001e\u0006\u0003'Q\tQ!\u001e;jYNT\u0011!F\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005}\u0001S\"\u0001\n\n\u0005\u0005\u0012\"a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0011\u0002\"a\b\u0001\u0002!\rdWo\u001d;fe&#\u0007+\u0019;uKJtW#A\u0014\u0011\u0005!zS\"A\u0015\u000b\u0005)Z\u0013!\u0002:fO\u0016D(B\u0001\u0017.\u0003\u0011)H/\u001b7\u000b\u00039\nAA[1wC&\u0011\u0001'\u000b\u0002\b!\u0006$H/\u001a:o\u0003E\u0019G.^:uKJLE\rU1ui\u0016\u0014h\u000eI\u0001\fi\u0016\u001cHoU<bY2|w\u000fF\u00015!\tIR'\u0003\u000275\t!QK\\5uQ\t!\u0001\b\u0005\u0002:}5\t!H\u0003\u0002<y\u0005)!.\u001e8ji*\tQ(A\u0002pe\u001eL!a\u0010\u001e\u0003\tQ+7\u000f^\u0001\u000bi\u0016\u001cH\u000f\u0016:z\u00032d\u0007FA\u00039\u0003Q!Xm\u001d;DSJ\u001cW\u000f\\1s\u0013R,'/\u0019;pe\"\u0012a\u0001O\u0001\u000ei\u0016\u001cHOU3bI\nKH/Z:)\u0005\u001dA\u0014a\u0002;fgR\f%m\u001d\u0015\u0003\u0011a\n\u0011\u0003^3tiJ+\u0007\u000f\\1dKN+hMZ5yQ\tI\u0001(A\u0006uKN$(+Z1e\u0013:$\bF\u0001\u00069\u0003-!Xm\u001d;DgZd\u0015n\u001d;)\u0005-A\u0014A\u0003;fgR\u001c5O^'ba\"\u0012A\u0002O\u0001\u000bi\u0016\u001cH/\u00138M_\u000e\\\u0007FA\u00079\u0003m!Xm\u001d;Ve2\u001c\u0016MZ3CCN,g\u0007N#oG>$W-V+J\t\"\u0012a\u0002O\u0001\u0019i\u0016\u001cHoR3oKJ\fG/Z+vS\u0012\f5OQ1tKZ\"\u0004FA\b9\u0003U!Xm\u001d;Bi>l\u0017nY$fi>\u0013X\u000b\u001d3bi\u0016D#\u0001\u0005\u001d")
public class CoreUtilsTest
implements Logging {
    private final Pattern clusterIdPattern;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        CoreUtilsTest coreUtilsTest = this;
        synchronized (coreUtilsTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Pattern clusterIdPattern() {
        return this.clusterIdPattern;
    }

    @Test
    public void testSwallow() {
        CoreUtils$.MODULE$.swallow((Function0 & Serializable & scala.Serializable)() -> {
            throw new KafkaException("test");
        }, (Logging)this, Level.INFO);
    }

    @Test
    public void testTryAll() {
        public class Kafka_utils_CoreUtilsTest$TestException$1
        extends Exception
        implements Product,
        scala.Serializable {
            private final String key;
            private final /* synthetic */ CoreUtilsTest $outer;

            public String key() {
                return this.key;
            }

            public Kafka_utils_CoreUtilsTest$TestException$1 copy(String key) {
                return new Kafka_utils_CoreUtilsTest$TestException$1(this.$outer, key);
            }

            public String copy$default$1() {
                return this.key();
            }

            public String productPrefix() {
                return "TestException";
            }

            public int productArity() {
                return 1;
            }

            public Object productElement(int x$1) {
                int n = x$1;
                switch (n) {
                    case 0: {
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                    }
                }
                return this.key();
            }

            public Iterator<Object> productIterator() {
                return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_utils_CoreUtilsTest$TestException$1;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                Object object = x$1;
                if (!(object instanceof Kafka_utils_CoreUtilsTest$TestException$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_utils_CoreUtilsTest$TestException$1 var4_4 = (Kafka_utils_CoreUtilsTest$TestException$1)x$1;
                String string = this.key();
                String string2 = var4_4.key();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                if (!var4_4.canEqual(this)) return false;
                return true;
            }

            public Kafka_utils_CoreUtilsTest$TestException$1(CoreUtilsTest $outer, String key) {
                this.key = key;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                Product.$init$((Product)this);
            }
        }
        LazyRef TestException$module = new LazyRef();
        scala.collection.mutable.Map recorded = Map$.MODULE$.empty();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-0"), recorded), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$1(this, "exception-1")), recorded), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-2"), recorded), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$1(this, "exception-3")), recorded)})));
        scala.collection.immutable.Map expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-0"), (Object)package$.MODULE$.Right().apply((Object)"valid-0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-1"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$3(TestException$module).apply("exception-1"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-2"), (Object)package$.MODULE$.Right().apply((Object)"valid-2")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-3"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$3(TestException$module).apply("exception-3")))}));
        Assert.assertEquals((Object)expected, (Object)recorded);
        recorded.clear();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-0"), recorded), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Right().apply((Object)"valid-1"), recorded)})));
        expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-0"), (Object)package$.MODULE$.Right().apply((Object)"valid-0")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valid-1"), (Object)package$.MODULE$.Right().apply((Object)"valid-1"))}));
        Assert.assertEquals((Object)expected, (Object)recorded);
        recorded.clear();
        CoreUtils$.MODULE$.tryAll((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$1(this, "exception-0")), recorded), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> CoreUtilsTest.recordingFunction$1((Either)package$.MODULE$.Left().apply((Object)new Kafka_utils_CoreUtilsTest$TestException$1(this, "exception-1")), recorded)})));
        expected = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-0"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$3(TestException$module).apply("exception-0"))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception-1"), (Object)package$.MODULE$.Left().apply((Object)this.TestException$3(TestException$module).apply("exception-1")))}));
        Assert.assertEquals((Object)expected, (Object)recorded);
    }

    @Test
    public void testCircularIterator() {
        List l = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator itl = CoreUtils$.MODULE$.circularIterator((Iterable)l);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)itl.next()));
        Assert.assertFalse((boolean)itl.hasDefiniteSize());
        Set s = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        Iterator its = CoreUtils$.MODULE$.circularIterator((Iterable)s);
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
        Assert.assertEquals((long)1L, (long)BoxesRunTime.unboxToInt((Object)its.next()));
    }

    @Test
    public void testReadBytes() {
        new .colon.colon((Object)"", (List)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"abcd", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)testCase -> {
            CoreUtilsTest.$anonfun$testReadBytes$1(testCase);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAbs() {
        Assert.assertEquals((long)0L, (long)Utils.abs((int)Integer.MIN_VALUE));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)-1));
        Assert.assertEquals((long)0L, (long)Utils.abs((int)0));
        Assert.assertEquals((long)1L, (long)Utils.abs((int)1));
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)Utils.abs((int)Integer.MAX_VALUE));
    }

    @Test
    public void testReplaceSuffix() {
        Assert.assertEquals((Object)"blah.foo.text", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ".text"));
        Assert.assertEquals((Object)"blah.foo", (Object)CoreUtils$.MODULE$.replaceSuffix("blah.foo.txt", ".txt", ""));
        Assert.assertEquals((Object)"txt.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("txt.txt.txt", ".txt", ""));
        Assert.assertEquals((Object)"foo.txt", (Object)CoreUtils$.MODULE$.replaceSuffix("foo", "", ".txt"));
    }

    @Test
    public void testReadInt() {
        int[] values = new int[]{0, 1, -1, 127, Short.MAX_VALUE, 65534, 0x3FFFFFFF, -1073741824, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE};
        ByteBuffer buffer = ByteBuffer.allocate(4 * new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(values)).size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), values.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            buffer.putInt(i * 4, values[i]);
            Assert.assertEquals((String)"Written value should match read value.", (long)values[i], (long)CoreUtils$.MODULE$.readInt(buffer.array(), i * 4));
        });
    }

    @Test
    public void testCsvList() {
        String emptyString = "";
        String nullString = null;
        Seq emptyList = CoreUtils$.MODULE$.parseCsvList(emptyString);
        Seq emptyListFromNullString = CoreUtils$.MODULE$.parseCsvList(nullString);
        Seq emptyStringList = (Seq)Seq$.MODULE$.empty();
        Assert.assertTrue((emptyList != null ? 1 : 0) != 0);
        Assert.assertTrue((emptyListFromNullString != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyListFromNullString));
        Assert.assertTrue((boolean)emptyStringList.equals((Object)emptyList));
    }

    @Test
    public void testCsvMap() {
        String emptyString = "";
        Map emptyMap = CoreUtils$.MODULE$.parseCsvMap(emptyString);
        scala.collection.immutable.Map emptyStringMap = Predef$.MODULE$.Map().empty();
        Assert.assertTrue((emptyMap != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)emptyStringMap.equals((Object)emptyStringMap));
        String kvPairsIpV6 = "a:b:c:v,a:b:c:v";
        Map ipv6Map = CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV6);
        ipv6Map.foreach((Function1 & Serializable & scala.Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$1(m);
            return BoxedUnit.UNIT;
        });
        String singleEntry = "key:value";
        Map singleMap = CoreUtils$.MODULE$.parseCsvMap(singleEntry);
        Object value = singleMap.getOrElse((Object)"key", (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0);
        Assert.assertTrue((boolean)value.equals("value"));
        String kvPairsIpV4 = "192.168.2.1/30:allow, 192.168.2.1/30:allow";
        Map ipv4Map = CoreUtils$.MODULE$.parseCsvMap(kvPairsIpV4);
        ipv4Map.foreach((Function1 & Serializable & scala.Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$3(m);
            return BoxedUnit.UNIT;
        });
        String kvPairsSpaces = "key:value      , key:   value";
        Map spaceMap = CoreUtils$.MODULE$.parseCsvMap(kvPairsSpaces);
        spaceMap.foreach((Function1 & Serializable & scala.Serializable)m -> {
            CoreUtilsTest.$anonfun$testCsvMap$4(m);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInLock() {
        ReentrantLock lock = new ReentrantLock();
        int result = BoxesRunTime.unboxToInt((Object)CoreUtils$.MODULE$.inLock((Lock)lock, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> {
            Assert.assertTrue((String)"Should be in lock", (boolean)lock.isHeldByCurrentThread());
            return 2;
        }));
        Assert.assertEquals((long)2L, (long)result);
        Assert.assertFalse((String)"Should be unlocked", (boolean)lock.isLocked());
    }

    @Test
    public void testUrlSafeBase64EncodeUUID() {
        String clusterId1 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("a149b4a3-06e1-4b49-a8cb-8a9c4a59fa46")));
        Assert.assertEquals((Object)clusterId1, (Object)"oUm0owbhS0moy4qcSln6Rg");
        Assert.assertEquals((long)clusterId1.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId1).matches());
        String clusterId2 = Base64.getUrlEncoder().withoutPadding().encodeToString(CoreUtils$.MODULE$.getBytesFromUuid(UUID.fromString("d418ec02-277e-4853-81e6-afe30259daec")));
        Assert.assertEquals((Object)clusterId2, (Object)"1BjsAid-SFOB5q_jAlna7A");
        Assert.assertEquals((long)clusterId2.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId2).matches());
    }

    @Test
    public void testGenerateUuidAsBase64() {
        String clusterId = CoreUtils$.MODULE$.generateUuidAsBase64();
        Assert.assertEquals((long)clusterId.length(), (long)22L);
        Assert.assertTrue((boolean)this.clusterIdPattern().matcher(clusterId).matches());
    }

    @Test
    public void testAtomicGetOrUpdate() {
        int count = 1000;
        int nThreads = 5;
        AtomicInteger createdCount = new AtomicInteger();
        scala.collection.concurrent.Map map = (scala.collection.concurrent.Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        ExecutionContextExecutorService executionContext = ExecutionContext$.MODULE$.fromExecutorService(Executors.newFixedThreadPool(nThreads));
        try {
            Await$.MODULE$.result((Awaitable)Future$.MODULE$.traverse((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count), (Function1 & Serializable & scala.Serializable)i -> Future$.MODULE$.apply((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((AtomicInteger)CoreUtils$.MODULE$.atomicGetOrUpdate(map$1, (Object)BoxesRunTime.boxToInteger((int)0), (Function0 & Serializable & scala.Serializable)() -> {
                createdCount$1.incrementAndGet();
                return new AtomicInteger();
            })).incrementAndGet(), (ExecutionContext)executionContext), IndexedSeq$.MODULE$.canBuildFrom(), (ExecutionContext)executionContext), (Duration)Duration$.MODULE$.apply(1L, TimeUnit.MINUTES));
            Assert.assertEquals((long)count, (long)((AtomicInteger)map.apply((Object)BoxesRunTime.boxToInteger((int)0))).get());
            int created = createdCount.get();
            Assert.assertTrue((String)new StringBuilder(19).append("Too many creations ").append(created).toString(), (created > 0 && created <= nThreads ? 1 : 0) != 0);
        }
        finally {
            executionContext.shutdownNow();
        }
    }

    private final /* synthetic */ CoreUtilsTest$TestException$2$ TestException$lzycompute$1(LazyRef TestException$module$1) {
        CoreUtilsTest$TestException$2$ coreUtilsTest$TestException$2$;
        LazyRef lazyRef = TestException$module$1;
        synchronized (lazyRef) {
            coreUtilsTest$TestException$2$ = TestException$module$1.initialized() ? (CoreUtilsTest$TestException$2$)((Object)TestException$module$1.value()) : (CoreUtilsTest$TestException$2$)((Object)TestException$module$1.initialize((Object)new CoreUtilsTest$TestException$2$(this)));
        }
        return coreUtilsTest$TestException$2$;
    }

    private final CoreUtilsTest$TestException$2$ TestException$3(LazyRef TestException$module$1) {
        return TestException$module$1.initialized() ? (CoreUtilsTest$TestException$2$)((Object)TestException$module$1.value()) : this.TestException$lzycompute$1(TestException$module$1);
    }

    private static final void recordingFunction$1(Either v, scala.collection.mutable.Map recorded$1) {
        String string;
        Either either = v;
        if (either instanceof Right) {
            String key;
            Right right = (Right)either;
            string = key = (String)right.value();
        } else if (either instanceof Left) {
            Left left = (Left)either;
            Kafka_utils_CoreUtilsTest$TestException$1 e = (Kafka_utils_CoreUtilsTest$TestException$1)left.value();
            string = e.key();
        } else {
            throw new MatchError((Object)either);
        }
        String key = string;
        recorded$1.update((Object)key, (Object)v);
    }

    public static final /* synthetic */ void $anonfun$testReadBytes$1(String testCase) {
        byte[] bytes = testCase.getBytes();
        Assert.assertTrue((boolean)Arrays.equals(bytes, Utils.readBytes((ByteBuffer)ByteBuffer.wrap(bytes))));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$1(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("a:b:c"));
        Assert.assertTrue((boolean)((String)m._2()).equals("v"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$3(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("192.168.2.1/30"));
        Assert.assertTrue((boolean)((String)m._2()).equals("allow"));
    }

    public static final /* synthetic */ void $anonfun$testCsvMap$4(Tuple2 m) {
        Assert.assertTrue((boolean)((String)m._1()).equals("key"));
        Assert.assertTrue((boolean)((String)m._2()).equals("value"));
    }

    public CoreUtilsTest() {
        Logging.$init$((Logging)this);
        this.clusterIdPattern = Pattern.compile("[a-zA-Z0-9_\\-]+");
    }
}

