/*
 * Decompiled with CFR 0.152.
 */
package kafka.zk;

import kafka.security.auth.Resource;
import kafka.security.auth.ResourceType;
import kafka.security.auth.Topic$;
import kafka.zk.AclChangeNode;
import kafka.zk.ExtendedAclStore;
import org.apache.kafka.common.resource.PatternType;
import org.junit.Assert;
import org.junit.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001a3AAD\b\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003BB\u0015\u0001A\u0003%\u0011\u0005C\u0004+\u0001\t\u0007I\u0011\u0002\u0011\t\r-\u0002\u0001\u0015!\u0003\"\u0011\u001da\u0003A1A\u0005\n5Ba!\r\u0001!\u0002\u0013q\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0004\"\u0002!\u0001\t\u0003\u0019\u0004\"\u0002\"\u0001\t\u0003\u0019\u0004\"\u0002*\u0001\t\u0003\u0019\u0004\"\u0002+\u0001\t\u0003\u0019\u0004\"\u0002,\u0001\t\u0003\u0019$\u0001F#yi\u0016tG-\u001a3BG2\u001cFo\u001c:f)\u0016\u001cHO\u0003\u0002\u0011#\u0005\u0011!p\u001b\u0006\u0002%\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0016!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012!\b\t\u0003=\u0001i\u0011aD\u0001\u0010Y&$XM]1m%\u0016\u001cx.\u001e:dKV\t\u0011\u0005\u0005\u0002#O5\t1E\u0003\u0002%K\u0005!\u0011-\u001e;i\u0015\t1\u0013#\u0001\u0005tK\u000e,(/\u001b;z\u0013\tA3E\u0001\u0005SKN|WO]2f\u0003Aa\u0017\u000e^3sC2\u0014Vm]8ve\u000e,\u0007%\u0001\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\u0006\t\u0002O]3gSb,GMU3t_V\u00148-\u001a\u0011\u0002\u000bM$xN]3\u0016\u00039\u0002\"AH\u0018\n\u0005Az!\u0001E#yi\u0016tG-\u001a3BG2\u001cFo\u001c:f\u0003\u0019\u0019Ho\u001c:fA\u000512\u000f[8vY\u0012D\u0015M^3D_J\u0014Xm\u0019;QCRD7\u000fF\u00015!\t1R'\u0003\u00027/\t!QK\\5uQ\tA\u0001\b\u0005\u0002:}5\t!H\u0003\u0002<y\u0005)!.\u001e8ji*\tQ(A\u0002pe\u001eL!a\u0010\u001e\u0003\tQ+7\u000f^\u0001\u001dg\"|W\u000f\u001c3ICZ,7i\u001c:sK\u000e$\b+\u0019;uKJtG+\u001f9fQ\tI\u0001(A\u0012tQ>,H\u000e\u001a+ie><\u0018JZ\"p]N$(/^2uK\u0012<\u0016\u000e\u001e5MSR,'/\u00197)\t)AD)R\u0001\tKb\u0004Xm\u0019;fI\u000e\na\t\u0005\u0002H\u001f:\u0011\u0001*\u0014\b\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017N\ta\u0001\u0010:p_Rt\u0014\"\u0001\r\n\u00059;\u0012a\u00029bG.\fw-Z\u0005\u0003!F\u0013\u0001$\u00137mK\u001e\fG.\u0011:hk6,g\u000e^#yG\u0016\u0004H/[8o\u0015\tqu#\u0001\u0010tQ>,H\u000e\u001a+ie><hI]8n\u000b:\u001cw\u000eZ3P]2KG/\u001a:bY\"\"1\u0002\u000f#F\u0003\u0001\u001a\bn\\;mI^\u0013\u0018\u000e^3DQ\u0006tw-Z:U_RCWm\u0016:ji\u0016\u0004\u0016\r\u001e5)\u00051A\u0014!G:i_VdGMU8v]\u0012$&/\u001b9DQ\u0006tw-\u001a(pI\u0016D#!\u0004\u001d")
public class ExtendedAclStoreTest {
    private final Resource literalResource = new Resource((ResourceType)Topic$.MODULE$, "some-topic", PatternType.LITERAL);
    private final Resource prefixedResource = new Resource((ResourceType)Topic$.MODULE$, "some-topic", PatternType.PREFIXED);
    private final ExtendedAclStore store = new ExtendedAclStore(PatternType.PREFIXED);

    private Resource literalResource() {
        return this.literalResource;
    }

    private Resource prefixedResource() {
        return this.prefixedResource;
    }

    private ExtendedAclStore store() {
        return this.store;
    }

    @Test
    public void shouldHaveCorrectPaths() {
        Assert.assertEquals((Object)"/kafka-acl-extended/prefixed", (Object)this.store().aclPath());
        Assert.assertEquals((Object)"/kafka-acl-extended/prefixed/Topic", (Object)this.store().path((ResourceType)Topic$.MODULE$));
        Assert.assertEquals((Object)"/kafka-acl-extended-changes", (Object)this.store().changeStore().aclChangePath());
    }

    @Test
    public void shouldHaveCorrectPatternType() {
        Assert.assertEquals((Object)PatternType.PREFIXED, (Object)this.store().patternType());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowIfConstructedWithLiteral() {
        new ExtendedAclStore(PatternType.LITERAL);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowFromEncodeOnLiteral() {
        this.store().changeStore().createChangeNode(this.literalResource());
    }

    @Test
    public void shouldWriteChangesToTheWritePath() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.prefixedResource());
        Assert.assertEquals((Object)"/kafka-acl-extended-changes/acl_changes_", (Object)changeNode.path());
    }

    @Test
    public void shouldRoundTripChangeNode() {
        AclChangeNode changeNode = this.store().changeStore().createChangeNode(this.prefixedResource());
        Resource actual = this.store().changeStore().decode(changeNode.bytes());
        Assert.assertEquals((Object)this.prefixedResource(), (Object)actual);
    }
}

