/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.tools.plugin.annotations.scanner.visitors;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.logging.Logger;
import org.objectweb.asm.AnnotationVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MojoAnnotationVisitor
implements AnnotationVisitor {
    private Logger logger;
    private String annotationClassName;
    private Map<String, Object> annotationValues = new HashMap<String, Object>();

    MojoAnnotationVisitor(Logger logger, String annotationClassName) {
        this.logger = logger;
        this.annotationClassName = annotationClassName;
    }

    public Map<String, Object> getAnnotationValues() {
        return this.annotationValues;
    }

    public void visit(String name, Object value) {
        this.annotationValues.put(name, value);
        this.logger.debug("MojoAnnotationVisitor#visit:" + name + ":" + value);
    }

    public void visitEnum(String name, String desc, String value) {
        this.annotationValues.put(name, value);
        this.logger.debug("MojoAnnotationVisitor#visitEnum:" + name + ":" + desc + ":" + value);
    }

    public AnnotationVisitor visitAnnotation(String name, String desc) {
        this.logger.debug("MojoAnnotationVisitor#visitAnnotation:" + name + ":" + desc);
        return new MojoAnnotationVisitor(this.logger, this.annotationClassName);
    }

    public AnnotationVisitor visitArray(String s) {
        this.logger.debug("MojoAnnotationVisitor#visitArray");
        return new MojoAnnotationVisitor(this.logger, this.annotationClassName);
    }

    public void visitEnd() {
    }

    public String getAnnotationClassName() {
        return this.annotationClassName;
    }
}

