/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dal.impl;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.encrypt.metadata.EncryptColumnMetaData;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.sql.parser.binder.type.TableAvailable;
import org.apache.shardingsphere.sql.parser.sql.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.underlying.merge.result.MergedResult;

public abstract class EncryptColumnsMergedResult
implements MergedResult {
    private final SchemaMetaData schemaMetaData;
    private final String tableName;

    protected EncryptColumnsMergedResult(SQLStatementContext sqlStatementContext, SchemaMetaData schemaMetaData) {
        this.schemaMetaData = schemaMetaData;
        Preconditions.checkState((sqlStatementContext instanceof TableAvailable && 1 == ((TableAvailable)sqlStatementContext).getAllTables().size() ? 1 : 0) != 0);
        this.tableName = ((SimpleTableSegment)((TableAvailable)sqlStatementContext).getAllTables().iterator().next()).getTableName().getIdentifier().getValue();
    }

    public final boolean next() throws SQLException {
        boolean hasNext = this.nextValue();
        if (hasNext && this.getTableEncryptColumnMetaDatas().isEmpty()) {
            return true;
        }
        if (!hasNext) {
            return false;
        }
        String columnName = this.getOriginalValue(1, String.class).toString();
        while (this.getAssistedQueryColumns().contains(columnName) || this.getPlainColumns().contains(columnName)) {
            hasNext = this.nextValue();
            if (!hasNext) {
                return false;
            }
            columnName = this.getOriginalValue(1, String.class).toString();
        }
        return true;
    }

    private Collection<String> getAssistedQueryColumns() {
        return this.getTableEncryptColumnMetaDatas().stream().map(EncryptColumnMetaData::getAssistedQueryColumnName).collect(Collectors.toList());
    }

    private Collection<String> getPlainColumns() {
        return this.getTableEncryptColumnMetaDatas().stream().map(EncryptColumnMetaData::getPlainColumnName).collect(Collectors.toList());
    }

    private Collection<EncryptColumnMetaData> getTableEncryptColumnMetaDatas() {
        LinkedList<EncryptColumnMetaData> result = new LinkedList<EncryptColumnMetaData>();
        for (Map.Entry entry : this.schemaMetaData.get(this.tableName).getColumns().entrySet()) {
            if (!(entry.getValue() instanceof EncryptColumnMetaData)) continue;
            result.add((EncryptColumnMetaData)entry.getValue());
        }
        return result;
    }

    public final Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (1 == columnIndex) {
            String columnName = this.getOriginalValue(columnIndex, type).toString();
            Optional<String> logicColumn = this.getLogicColumnOfCipher(columnName);
            return logicColumn.isPresent() ? logicColumn.get() : columnName;
        }
        return this.getOriginalValue(columnIndex, type);
    }

    private Optional<String> getLogicColumnOfCipher(String cipherColumn) {
        for (Map.Entry entry : this.schemaMetaData.get(this.tableName).getColumns().entrySet()) {
            EncryptColumnMetaData encryptColumnMetaData;
            if (!(entry.getValue() instanceof EncryptColumnMetaData) || !(encryptColumnMetaData = (EncryptColumnMetaData)entry.getValue()).getCipherColumnName().equalsIgnoreCase(cipherColumn)) continue;
            return Optional.of(entry.getKey());
        }
        return Optional.empty();
    }

    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    protected abstract boolean nextValue() throws SQLException;

    protected abstract Object getOriginalValue(int var1, Class<?> var2) throws SQLException;
}

