/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.merge.dql;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.strategy.spi.Encryptor;
import org.apache.shardingsphere.sql.parser.binder.metadata.schema.SchemaMetaData;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.Projection;
import org.apache.shardingsphere.sql.parser.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.sql.parser.binder.statement.dml.SelectStatementContext;

public final class EncryptorMetaData {
    private final SchemaMetaData schemaMetaData;
    private final EncryptRule encryptRule;
    private final SelectStatementContext selectStatementContext;

    public Optional<Encryptor> findEncryptor(int columnIndex) {
        Projection projection = (Projection)this.selectStatementContext.getProjectionsContext().getExpandProjections().get(columnIndex - 1);
        if (projection instanceof ColumnProjection) {
            String columnName = ((ColumnProjection)projection).getName();
            Optional tableName = this.selectStatementContext.getTablesContext().findTableName((ColumnProjection)projection, this.schemaMetaData);
            return tableName.isPresent() ? this.findEncryptor((String)tableName.get(), columnName) : this.findEncryptor(columnName);
        }
        return Optional.empty();
    }

    private Optional<Encryptor> findEncryptor(String tableName, String columnName) {
        return this.encryptRule.findEncryptor(tableName, columnName);
    }

    private Optional<Encryptor> findEncryptor(String columnName) {
        for (String each : this.selectStatementContext.getTablesContext().getTableNames()) {
            Optional result = this.encryptRule.findEncryptor(each, columnName);
            if (!result.isPresent()) continue;
            return result;
        }
        return Optional.empty();
    }

    @Generated
    public EncryptorMetaData(SchemaMetaData schemaMetaData, EncryptRule encryptRule, SelectStatementContext selectStatementContext) {
        this.schemaMetaData = schemaMetaData;
        this.encryptRule = encryptRule;
        this.selectStatementContext = selectStatementContext;
    }
}

