/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.api.hint;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;

public final class HintManager
implements AutoCloseable {
    private static final ThreadLocal<HintManager> HINT_MANAGER_HOLDER = new ThreadLocal();
    private final Multimap<String, Comparable<?>> databaseShardingValues = HashMultimap.create();
    private final Multimap<String, Comparable<?>> tableShardingValues = HashMultimap.create();
    private boolean databaseShardingOnly;
    private boolean masterRouteOnly;

    public static HintManager getInstance() {
        Preconditions.checkState((null == HINT_MANAGER_HOLDER.get() ? 1 : 0) != 0, (Object)"Hint has previous value, please clear first.");
        HintManager result = new HintManager();
        HINT_MANAGER_HOLDER.set(result);
        return result;
    }

    public void setDatabaseShardingValue(Comparable<?> value) {
        this.databaseShardingValues.clear();
        this.databaseShardingValues.put((Object)"", value);
        this.databaseShardingOnly = true;
    }

    public void addDatabaseShardingValue(String logicTable, Comparable<?> value) {
        this.databaseShardingValues.put((Object)logicTable, value);
        this.databaseShardingOnly = false;
    }

    public void addTableShardingValue(String logicTable, Comparable<?> value) {
        this.tableShardingValues.put((Object)logicTable, value);
        this.databaseShardingOnly = false;
    }

    public static Collection<Comparable<?>> getDatabaseShardingValues() {
        return HintManager.getDatabaseShardingValues("");
    }

    public static Collection<Comparable<?>> getDatabaseShardingValues(String logicTable) {
        return null == HINT_MANAGER_HOLDER.get() ? Collections.emptyList() : HintManager.HINT_MANAGER_HOLDER.get().databaseShardingValues.get((Object)logicTable);
    }

    public static Collection<Comparable<?>> getTableShardingValues(String logicTable) {
        return null == HINT_MANAGER_HOLDER.get() ? Collections.emptyList() : HintManager.HINT_MANAGER_HOLDER.get().tableShardingValues.get((Object)logicTable);
    }

    public static boolean isDatabaseShardingOnly() {
        return null != HINT_MANAGER_HOLDER.get() && HintManager.HINT_MANAGER_HOLDER.get().databaseShardingOnly;
    }

    public void setMasterRouteOnly() {
        this.masterRouteOnly = true;
    }

    public static boolean isMasterRouteOnly() {
        return null != HINT_MANAGER_HOLDER.get() && HintManager.HINT_MANAGER_HOLDER.get().masterRouteOnly;
    }

    public static void clear() {
        HINT_MANAGER_HOLDER.remove();
    }

    @Override
    public void close() {
        HintManager.clear();
    }

    private HintManager() {
    }
}

