/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.api.config.sharding.strategy;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.shardingsphere.api.config.sharding.strategy.ShardingStrategyConfiguration;

public final class InlineShardingStrategyConfiguration
implements ShardingStrategyConfiguration {
    private final String shardingColumn;
    private final String algorithmExpression;

    public InlineShardingStrategyConfiguration(String shardingColumn, String algorithmExpression) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)shardingColumn) ? 1 : 0) != 0, (Object)"ShardingColumn is required.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)algorithmExpression) ? 1 : 0) != 0, (Object)"AlgorithmExpression is required.");
        this.shardingColumn = shardingColumn;
        this.algorithmExpression = algorithmExpression;
    }

    public String toString() {
        return "Inline{shardingColumn='" + this.shardingColumn + '\'' + ", algorithmExpression='" + this.algorithmExpression + '\'' + '}';
    }

    public String getShardingColumn() {
        return this.shardingColumn;
    }

    public String getAlgorithmExpression() {
        return this.algorithmExpression;
    }
}

