/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.api.config.masterslave;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.api.config.masterslave.LoadBalanceStrategyConfiguration;
import org.apache.shardingsphere.underlying.common.config.RuleConfiguration;

public final class MasterSlaveRuleConfiguration
implements RuleConfiguration {
    private final String name;
    private final String masterDataSourceName;
    private final List<String> slaveDataSourceNames;
    private final LoadBalanceStrategyConfiguration loadBalanceStrategyConfiguration;

    public MasterSlaveRuleConfiguration(String name, String masterDataSourceName, List<String> slaveDataSourceNames) {
        this(name, masterDataSourceName, slaveDataSourceNames, null);
    }

    public MasterSlaveRuleConfiguration(String name, String masterDataSourceName, List<String> slaveDataSourceNames, LoadBalanceStrategyConfiguration loadBalanceStrategyConfiguration) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Name is required.");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)masterDataSourceName) ? 1 : 0) != 0, (Object)"MasterDataSourceName is required.");
        Preconditions.checkArgument((null != slaveDataSourceNames && !slaveDataSourceNames.isEmpty() ? 1 : 0) != 0, (Object)"SlaveDataSourceNames is required.");
        this.name = name;
        this.masterDataSourceName = masterDataSourceName;
        this.slaveDataSourceNames = slaveDataSourceNames;
        this.loadBalanceStrategyConfiguration = loadBalanceStrategyConfiguration;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getMasterDataSourceName() {
        return this.masterDataSourceName;
    }

    @Generated
    public List<String> getSlaveDataSourceNames() {
        return this.slaveDataSourceNames;
    }

    @Generated
    public LoadBalanceStrategyConfiguration getLoadBalanceStrategyConfiguration() {
        return this.loadBalanceStrategyConfiguration;
    }
}

