/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dal;

import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.List;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.merge.MergeEngine;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowCreateTableMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowDatabasesMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowIndexMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowOtherMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowTableStatusMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowTablesMergedResult;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.sql.statement.dal.DALStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.ShowCreateTableStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.ShowDatabasesStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.ShowIndexStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.ShowTableStatusStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.ShowTablesStatement;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class DALMergeEngine
implements MergeEngine {
    private final ShardingRule shardingRule;
    private final List<QueryResult> queryResults;
    private final DALStatement dalStatement;
    private final ShardingTableMetaData shardingTableMetaData;

    @Override
    public MergedResult merge() throws SQLException {
        if (this.dalStatement instanceof ShowDatabasesStatement) {
            return new ShowDatabasesMergedResult();
        }
        if (this.dalStatement instanceof ShowTableStatusStatement) {
            return new ShowTableStatusMergedResult(this.shardingRule, this.queryResults, this.shardingTableMetaData);
        }
        if (this.dalStatement instanceof ShowTablesStatement) {
            return new ShowTablesMergedResult(this.shardingRule, this.queryResults, this.shardingTableMetaData);
        }
        if (this.dalStatement instanceof ShowCreateTableStatement) {
            return new ShowCreateTableMergedResult(this.shardingRule, this.queryResults, this.shardingTableMetaData);
        }
        if (this.dalStatement instanceof ShowIndexStatement) {
            return new ShowIndexMergedResult(this.shardingRule, this.queryResults, this.shardingTableMetaData);
        }
        return new ShowOtherMergedResult(this.queryResults.get(0));
    }

    @ConstructorProperties(value={"shardingRule", "queryResults", "dalStatement", "shardingTableMetaData"})
    public DALMergeEngine(ShardingRule shardingRule, List<QueryResult> queryResults, DALStatement dalStatement, ShardingTableMetaData shardingTableMetaData) {
        this.shardingRule = shardingRule;
        this.queryResults = queryResults;
        this.dalStatement = dalStatement;
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

