/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dql.groupby;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.merge.dql.common.MemoryMergedResult;
import org.apache.shardingsphere.core.merge.dql.common.MemoryQueryResultRow;
import org.apache.shardingsphere.core.merge.dql.groupby.GroupByRowComparator;
import org.apache.shardingsphere.core.merge.dql.groupby.GroupByValue;
import org.apache.shardingsphere.core.merge.dql.groupby.aggregation.AggregationUnit;
import org.apache.shardingsphere.core.merge.dql.groupby.aggregation.AggregationUnitFactory;
import org.apache.shardingsphere.core.optimize.sharding.segment.select.item.AggregationSelectItem;
import org.apache.shardingsphere.core.optimize.sharding.statement.dml.ShardingSelectOptimizedStatement;

public final class GroupByMemoryMergedResult
extends MemoryMergedResult {
    private final ShardingSelectOptimizedStatement optimizedStatement;
    private final Iterator<MemoryQueryResultRow> memoryResultSetRows;

    public GroupByMemoryMergedResult(Map<String, Integer> labelAndIndexMap, List<QueryResult> queryResults, ShardingSelectOptimizedStatement optimizedStatement) throws SQLException {
        super(labelAndIndexMap);
        this.optimizedStatement = optimizedStatement;
        this.memoryResultSetRows = this.init(queryResults);
    }

    private Iterator<MemoryQueryResultRow> init(List<QueryResult> queryResults) throws SQLException {
        HashMap<GroupByValue, MemoryQueryResultRow> dataMap = new HashMap<GroupByValue, MemoryQueryResultRow>(1024);
        HashMap<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap = new HashMap<GroupByValue, Map<AggregationSelectItem, AggregationUnit>>(1024);
        for (QueryResult each : queryResults) {
            while (each.next()) {
                GroupByValue groupByValue = new GroupByValue(each, this.optimizedStatement.getGroupBy().getItems());
                this.initForFirstGroupByValue(each, groupByValue, dataMap, aggregationMap);
                this.aggregate(each, groupByValue, aggregationMap);
            }
        }
        this.setAggregationValueToMemoryRow(dataMap, aggregationMap);
        List<Boolean> valueCaseSensitive = queryResults.isEmpty() ? Collections.emptyList() : this.getValueCaseSensitive(queryResults.iterator().next());
        List<MemoryQueryResultRow> result = this.getMemoryResultSetRows(dataMap, valueCaseSensitive);
        if (!result.isEmpty()) {
            this.setCurrentResultSetRow(result.get(0));
        }
        return result.iterator();
    }

    private void initForFirstGroupByValue(QueryResult queryResult, GroupByValue groupByValue, Map<GroupByValue, MemoryQueryResultRow> dataMap, Map<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap) throws SQLException {
        if (!dataMap.containsKey(groupByValue)) {
            dataMap.put(groupByValue, new MemoryQueryResultRow(queryResult));
        }
        if (!aggregationMap.containsKey(groupByValue)) {
            ImmutableMap map = Maps.toMap((Iterable)this.optimizedStatement.getSelectItems().getAggregationSelectItems(), (Function)new Function<AggregationSelectItem, AggregationUnit>(){

                public AggregationUnit apply(AggregationSelectItem input) {
                    return AggregationUnitFactory.create(input.getType());
                }
            });
            aggregationMap.put(groupByValue, (Map<AggregationSelectItem, AggregationUnit>)map);
        }
    }

    private void aggregate(QueryResult queryResult, GroupByValue groupByValue, Map<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap) throws SQLException {
        for (AggregationSelectItem each : this.optimizedStatement.getSelectItems().getAggregationSelectItems()) {
            ArrayList values = new ArrayList(2);
            if (each.getDerivedAggregationItems().isEmpty()) {
                values.add(this.getAggregationValue(queryResult, each));
            } else {
                for (AggregationSelectItem derived : each.getDerivedAggregationItems()) {
                    values.add(this.getAggregationValue(queryResult, derived));
                }
            }
            aggregationMap.get(groupByValue).get(each).merge(values);
        }
    }

    private Comparable<?> getAggregationValue(QueryResult queryResult, AggregationSelectItem aggregationSelectItem) throws SQLException {
        Object result = queryResult.getValue(aggregationSelectItem.getIndex(), Object.class);
        Preconditions.checkState((null == result || result instanceof Comparable ? 1 : 0) != 0, (Object)"Aggregation value must implements Comparable");
        return (Comparable)result;
    }

    private void setAggregationValueToMemoryRow(Map<GroupByValue, MemoryQueryResultRow> dataMap, Map<GroupByValue, Map<AggregationSelectItem, AggregationUnit>> aggregationMap) {
        for (Map.Entry<GroupByValue, MemoryQueryResultRow> entry : dataMap.entrySet()) {
            for (AggregationSelectItem each : this.optimizedStatement.getSelectItems().getAggregationSelectItems()) {
                entry.getValue().setCell(each.getIndex(), aggregationMap.get(entry.getKey()).get(each).getResult());
            }
        }
    }

    private List<Boolean> getValueCaseSensitive(QueryResult queryResult) throws SQLException {
        ArrayList result = Lists.newArrayList((Object[])new Boolean[]{false});
        for (int columnIndex = 1; columnIndex <= queryResult.getColumnCount(); ++columnIndex) {
            result.add(queryResult.isCaseSensitive(columnIndex));
        }
        return result;
    }

    private List<MemoryQueryResultRow> getMemoryResultSetRows(Map<GroupByValue, MemoryQueryResultRow> dataMap, List<Boolean> valueCaseSensitive) {
        ArrayList<MemoryQueryResultRow> result = new ArrayList<MemoryQueryResultRow>(dataMap.values());
        Collections.sort(result, new GroupByRowComparator(this.optimizedStatement, valueCaseSensitive));
        return result;
    }

    @Override
    public boolean next() {
        if (this.memoryResultSetRows.hasNext()) {
            this.setCurrentResultSetRow(this.memoryResultSetRows.next());
            return true;
        }
        return false;
    }
}

