/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dql.orderby;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.merge.dql.common.StreamMergedResult;
import org.apache.shardingsphere.core.merge.dql.orderby.OrderByValue;
import org.apache.shardingsphere.core.optimize.sharding.segment.select.orderby.OrderByItem;

public class OrderByStreamMergedResult
extends StreamMergedResult {
    private final Collection<OrderByItem> orderByItems;
    private final Queue<OrderByValue> orderByValuesQueue;
    private boolean isFirstNext;

    public OrderByStreamMergedResult(List<QueryResult> queryResults, Collection<OrderByItem> orderByItems) throws SQLException {
        this.orderByItems = orderByItems;
        this.orderByValuesQueue = new PriorityQueue<OrderByValue>(queryResults.size());
        this.orderResultSetsToQueue(queryResults);
        this.isFirstNext = true;
    }

    private void orderResultSetsToQueue(List<QueryResult> queryResults) throws SQLException {
        for (QueryResult each : queryResults) {
            OrderByValue orderByValue = new OrderByValue(each, this.orderByItems);
            if (!orderByValue.next()) continue;
            this.orderByValuesQueue.offer(orderByValue);
        }
        this.setCurrentQueryResult(this.orderByValuesQueue.isEmpty() ? queryResults.get(0) : this.orderByValuesQueue.peek().getQueryResult());
    }

    @Override
    public boolean next() throws SQLException {
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        if (this.isFirstNext) {
            this.isFirstNext = false;
            return true;
        }
        OrderByValue firstOrderByValue = this.orderByValuesQueue.poll();
        if (firstOrderByValue.next()) {
            this.orderByValuesQueue.offer(firstOrderByValue);
        }
        if (this.orderByValuesQueue.isEmpty()) {
            return false;
        }
        this.setCurrentQueryResult(this.orderByValuesQueue.peek().getQueryResult());
        return true;
    }

    protected Queue<OrderByValue> getOrderByValuesQueue() {
        return this.orderByValuesQueue;
    }

    protected boolean isFirstNext() {
        return this.isFirstNext;
    }
}

