/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dql.pagination;

import java.sql.SQLException;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dql.common.DecoratorMergedResult;
import org.apache.shardingsphere.core.optimize.sharding.segment.select.pagination.Pagination;

public final class LimitDecoratorMergedResult
extends DecoratorMergedResult {
    private final Pagination pagination;
    private final boolean skipAll;
    private int rowNumber;

    public LimitDecoratorMergedResult(MergedResult mergedResult, Pagination pagination) throws SQLException {
        super(mergedResult);
        this.pagination = pagination;
        this.skipAll = this.skipOffset();
    }

    private boolean skipOffset() throws SQLException {
        for (int i = 0; i < this.pagination.getActualOffset(); ++i) {
            if (this.getMergedResult().next()) continue;
            return true;
        }
        this.rowNumber = 0;
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.skipAll) {
            return false;
        }
        if (!this.pagination.getActualRowCount().isPresent()) {
            return this.getMergedResult().next();
        }
        return ++this.rowNumber <= (Integer)this.pagination.getActualRowCount().get() && this.getMergedResult().next();
    }
}

