/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dal;

import java.beans.ConstructorProperties;
import java.sql.SQLException;
import java.util.List;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.merge.MergeEngine;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dal.desc.DescribeTableMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowCreateTableMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowDatabasesMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowIndexMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowOtherMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowTableStatusMergedResult;
import org.apache.shardingsphere.core.merge.dal.show.ShowTablesMergedResult;
import org.apache.shardingsphere.core.metadata.table.TableMetas;
import org.apache.shardingsphere.core.parse.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.DescribeStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.ShowCreateTableStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.ShowDatabasesStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.ShowIndexStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.ShowTableStatusStatement;
import org.apache.shardingsphere.core.parse.sql.statement.dal.dialect.mysql.ShowTablesStatement;
import org.apache.shardingsphere.core.preprocessor.statement.SQLStatementContext;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class DALMergeEngine
implements MergeEngine {
    private final ShardingRule shardingRule;
    private final List<QueryResult> queryResults;
    private final SQLStatementContext sqlStatementContext;
    private final TableMetas tableMetas;

    @Override
    public MergedResult merge() throws SQLException {
        SQLStatement dalStatement = this.sqlStatementContext.getSqlStatement();
        if (dalStatement instanceof ShowDatabasesStatement) {
            return new ShowDatabasesMergedResult(this.shardingRule, this.queryResults);
        }
        if (dalStatement instanceof ShowTableStatusStatement) {
            return new ShowTableStatusMergedResult(this.shardingRule, this.queryResults, this.tableMetas);
        }
        if (dalStatement instanceof ShowTablesStatement) {
            return new ShowTablesMergedResult(this.shardingRule, this.queryResults, this.tableMetas);
        }
        if (dalStatement instanceof ShowCreateTableStatement) {
            return new ShowCreateTableMergedResult(this.shardingRule, this.queryResults, this.tableMetas);
        }
        if (dalStatement instanceof ShowIndexStatement) {
            return new ShowIndexMergedResult(this.shardingRule, this.queryResults, this.tableMetas);
        }
        if (dalStatement instanceof DescribeStatement) {
            return new DescribeTableMergedResult(this.shardingRule, this.queryResults, this.sqlStatementContext);
        }
        return new ShowOtherMergedResult(this.queryResults.get(0));
    }

    @ConstructorProperties(value={"shardingRule", "queryResults", "sqlStatementContext", "tableMetas"})
    public DALMergeEngine(ShardingRule shardingRule, List<QueryResult> queryResults, SQLStatementContext sqlStatementContext, TableMetas tableMetas) {
        this.shardingRule = shardingRule;
        this.queryResults = queryResults;
        this.sqlStatementContext = sqlStatementContext;
        this.tableMetas = tableMetas;
    }
}

