/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.merge.dal.show;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.merge.MergedResult;
import org.apache.shardingsphere.core.merge.dal.show.LocalMergedResultAdapter;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class ShowDatabasesMergedResult
extends LocalMergedResultAdapter
implements MergedResult {
    private final List<String> schemas;
    private int currentIndex;

    public ShowDatabasesMergedResult() {
        this(Collections.singletonList("logic_db"));
    }

    public ShowDatabasesMergedResult(List<String> schemas) {
        this.schemas = schemas;
        this.currentIndex = 0;
    }

    public ShowDatabasesMergedResult(ShardingRule shardingRule, List<QueryResult> queryResults) throws SQLException {
        this(ShowDatabasesMergedResult.convertToScheme(queryResults));
    }

    private static List<String> convertToScheme(List<QueryResult> queryResults) throws SQLException {
        LinkedList<String> result = new LinkedList<String>();
        for (QueryResult queryResult : queryResults) {
            while (queryResult.next()) {
                result.add((String)queryResult.getValue(1, String.class));
            }
        }
        return new ArrayList<String>(result);
    }

    @Override
    public boolean next() {
        return this.currentIndex++ < this.schemas.size();
    }

    @Override
    public Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.schemas.get(this.currentIndex - 1);
    }
}

