/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.api.yaml;

import java.io.File;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.yaml.config.encrypt.YamlRootEncryptRuleConfiguration;
import org.apache.shardingsphere.core.yaml.engine.YamlEngine;
import org.apache.shardingsphere.core.yaml.swapper.impl.EncryptRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.shardingjdbc.api.EncryptDataSourceFactory;

public final class YamlEncryptDataSourceFactory {
    public static DataSource createDataSource(File yamlFile) {
        YamlRootEncryptRuleConfiguration config = (YamlRootEncryptRuleConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlRootEncryptRuleConfiguration.class);
        return EncryptDataSourceFactory.createDataSource(config.getDataSource(), new EncryptRuleConfigurationYamlSwapper().swap(config.getEncryptRule()));
    }

    public static DataSource createDataSource(byte[] yamlBytes) {
        YamlRootEncryptRuleConfiguration config = (YamlRootEncryptRuleConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlRootEncryptRuleConfiguration.class);
        return EncryptDataSourceFactory.createDataSource(config.getDataSource(), new EncryptRuleConfigurationYamlSwapper().swap(config.getEncryptRule()));
    }

    public static DataSource createDataSource(DataSource dataSource, File yamlFile) {
        YamlRootEncryptRuleConfiguration config = (YamlRootEncryptRuleConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlRootEncryptRuleConfiguration.class);
        return EncryptDataSourceFactory.createDataSource(dataSource, new EncryptRuleConfigurationYamlSwapper().swap(config.getEncryptRule()));
    }

    public static DataSource createDataSource(DataSource dataSource, byte[] yamlBytes) {
        YamlRootEncryptRuleConfiguration config = (YamlRootEncryptRuleConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlRootEncryptRuleConfiguration.class);
        return EncryptDataSourceFactory.createDataSource(dataSource, new EncryptRuleConfigurationYamlSwapper().swap(config.getEncryptRule()));
    }

    private YamlEncryptDataSourceFactory() {
    }
}

