/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.api.yaml;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlRootShardingConfiguration;
import org.apache.shardingsphere.core.yaml.engine.YamlEngine;
import org.apache.shardingsphere.core.yaml.swapper.impl.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.shardingjdbc.api.ShardingDataSourceFactory;

public final class YamlShardingDataSourceFactory {
    public static DataSource createDataSource(File yamlFile) throws SQLException, IOException {
        YamlRootShardingConfiguration config = (YamlRootShardingConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlRootShardingConfiguration.class);
        return ShardingDataSourceFactory.createDataSource(config.getDataSources(), new ShardingRuleConfigurationYamlSwapper().swap(config.getShardingRule()), config.getProps());
    }

    public static DataSource createDataSource(byte[] yamlBytes) throws SQLException, IOException {
        YamlRootShardingConfiguration config = (YamlRootShardingConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlRootShardingConfiguration.class);
        return ShardingDataSourceFactory.createDataSource(config.getDataSources(), new ShardingRuleConfigurationYamlSwapper().swap(config.getShardingRule()), config.getProps());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, File yamlFile) throws SQLException, IOException {
        YamlRootShardingConfiguration config = (YamlRootShardingConfiguration)YamlEngine.unmarshal((File)yamlFile, YamlRootShardingConfiguration.class);
        return ShardingDataSourceFactory.createDataSource(dataSourceMap, new ShardingRuleConfigurationYamlSwapper().swap(config.getShardingRule()), config.getProps());
    }

    public static DataSource createDataSource(Map<String, DataSource> dataSourceMap, byte[] yamlBytes) throws SQLException, IOException {
        YamlRootShardingConfiguration config = (YamlRootShardingConfiguration)YamlEngine.unmarshal((byte[])yamlBytes, YamlRootShardingConfiguration.class);
        return ShardingDataSourceFactory.createDataSource(dataSourceMap, new ShardingRuleConfigurationYamlSwapper().swap(config.getShardingRule()), config.getProps());
    }

    private YamlShardingDataSourceFactory() {
    }
}

