/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shardingjdbc.executor;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.core.constant.ConnectionMode;
import org.apache.shardingsphere.core.execute.ShardingExecuteGroup;
import org.apache.shardingsphere.core.execute.StatementExecuteUnit;
import org.apache.shardingsphere.core.execute.sql.execute.SQLExecuteCallback;
import org.apache.shardingsphere.core.execute.sql.execute.result.MemoryQueryResult;
import org.apache.shardingsphere.core.execute.sql.execute.result.QueryResult;
import org.apache.shardingsphere.core.execute.sql.execute.result.StreamQueryResult;
import org.apache.shardingsphere.core.execute.sql.execute.threadlocal.ExecutorExceptionHandler;
import org.apache.shardingsphere.core.execute.sql.prepare.SQLExecutePrepareCallback;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.rule.ShardingRule;
import org.apache.shardingsphere.shardingjdbc.executor.AbstractStatementExecutor;
import org.apache.shardingsphere.shardingjdbc.executor.SQLExecuteCallbackFactory;
import org.apache.shardingsphere.shardingjdbc.jdbc.core.connection.ShardingConnection;

public final class PreparedStatementExecutor
extends AbstractStatementExecutor {
    private final boolean returnGeneratedKeys;

    public PreparedStatementExecutor(int resultSetType, int resultSetConcurrency, int resultSetHoldability, boolean returnGeneratedKeys, ShardingConnection shardingConnection) {
        super(resultSetType, resultSetConcurrency, resultSetHoldability, shardingConnection);
        this.returnGeneratedKeys = returnGeneratedKeys;
    }

    public void init(SQLRouteResult routeResult) throws SQLException {
        this.setSqlStatement(routeResult.getSqlStatement());
        this.getExecuteGroups().addAll(this.obtainExecuteGroups(routeResult.getRouteUnits()));
        this.cacheStatements();
    }

    private Collection<ShardingExecuteGroup<StatementExecuteUnit>> obtainExecuteGroups(Collection<RouteUnit> routeUnits) throws SQLException {
        return this.getSqlExecutePrepareTemplate().getExecuteUnitGroups(routeUnits, new SQLExecutePrepareCallback(){

            public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
                return PreparedStatementExecutor.super.getConnection().getConnections(connectionMode, dataSourceName, connectionSize);
            }

            public StatementExecuteUnit createStatementExecuteUnit(Connection connection, RouteUnit routeUnit, ConnectionMode connectionMode) throws SQLException {
                return new StatementExecuteUnit(routeUnit, (Statement)PreparedStatementExecutor.this.createPreparedStatement(connection, routeUnit.getSqlUnit().getSql()), connectionMode);
            }
        });
    }

    private PreparedStatement createPreparedStatement(Connection connection, String sql) throws SQLException {
        return this.returnGeneratedKeys ? connection.prepareStatement(sql, 1) : connection.prepareStatement(sql, this.getResultSetType(), this.getResultSetConcurrency(), this.getResultSetHoldability());
    }

    public List<QueryResult> executeQuery() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<QueryResult> executeCallback = new SQLExecuteCallback<QueryResult>(this.getDatabaseType(), isExceptionThrown){

            protected QueryResult executeSQL(RouteUnit routeUnit, Statement statement, ConnectionMode connectionMode) throws SQLException {
                return PreparedStatementExecutor.this.getQueryResult(statement, connectionMode);
            }
        };
        return this.executeCallback(executeCallback);
    }

    private QueryResult getQueryResult(Statement statement, ConnectionMode connectionMode) throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)statement;
        ResultSet resultSet = preparedStatement.executeQuery();
        ShardingRule shardingRule = this.getConnection().getShardingContext().getShardingRule();
        this.getResultSets().add(resultSet);
        return ConnectionMode.MEMORY_STRICTLY == connectionMode ? new StreamQueryResult(resultSet, shardingRule, shardingRule.getShardingEncryptorEngine()) : new MemoryQueryResult(resultSet, shardingRule, shardingRule.getShardingEncryptorEngine());
    }

    public int executeUpdate() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<Integer> executeCallback = SQLExecuteCallbackFactory.getPreparedUpdateSQLExecuteCallback(this.getDatabaseType(), isExceptionThrown);
        List<Integer> results = this.executeCallback(executeCallback);
        if (this.isAccumulate()) {
            return this.accumulate(results);
        }
        return results.get(0);
    }

    private int accumulate(List<Integer> results) {
        int result = 0;
        for (Integer each : results) {
            result += null == each ? 0 : each;
        }
        return result;
    }

    public boolean execute() throws SQLException {
        boolean isExceptionThrown = ExecutorExceptionHandler.isExceptionThrown();
        SQLExecuteCallback<Boolean> executeCallback = SQLExecuteCallbackFactory.getPreparedSQLExecuteCallback(this.getDatabaseType(), isExceptionThrown);
        List<Boolean> result = this.executeCallback(executeCallback);
        if (null == result || result.isEmpty() || null == result.get(0)) {
            return false;
        }
        return result.get(0);
    }

    public boolean isReturnGeneratedKeys() {
        return this.returnGeneratedKeys;
    }
}

